/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSBoundedRangeStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.ws.performance.tuning.calc.ILogReadingCalc;
import com.ibm.ws.performance.tuning.calc.IMemoryCalc;
import com.ibm.ws.tpv.advisor.calc.TPVData;

public class ClientMemoryCalc
implements IMemoryCalc,
ILogReadingCalc {
    private static TraceComponent tc = Tr.register(ClientMemoryCalc.class, null, null);
    private static final String[] jvmModule = new String[]{"jvmRuntimeModule"};
    private PerfDescriptor pd;
    private TPVData data;
    protected String userId = null;
    protected String logName = null;

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public void init(PerfDescriptor perfDescriptor) {
        this.pd = perfDescriptor;
        this.data = TPVData.createData(perfDescriptor, this.userId, this.logName);
    }

    public long getFreeMemory() {
        if (this.data == null) {
            Tr.debug(tc, "[ClientMemoryCalc] getFreeMemory() returned NO_DATA");
            return -102L;
        }
        long l = ((WSCountStatistic)this.data.getCacheValue(0, 2)).getCount();
        Tr.debug(tc, "[ClientMemoryCalc] getFreeMemory() returned: " + l);
        return l;
    }

    public long getTotalMemory() {
        if (this.data == null) {
            Tr.debug(tc, "[ClientMemoryCalc] getTotalMemory() returned NO_DATA");
            return -102L;
        }
        long l = ((WSBoundedRangeStatistic)this.data.getCacheValue(0, 1)).getUpperBound();
        Tr.debug(tc, "[ClientMemoryCalc] getTotalMemory() returned: " + l);
        return l;
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
    }
}

