/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.performance.tuning.calc.ILogReadingCalc;
import com.ibm.ws.performance.tuning.calc.IRateIncreaseCalc;
import com.ibm.ws.tpv.advisor.calc.TPVData;

public class ClientRateIncreaseCalc
implements IRateIncreaseCalc,
ILogReadingCalc {
    private static TraceComponent tc = Tr.register(ClientRateIncreaseCalc.class, null, null);
    private int maxExceedInRow;
    private double percentExceed;
    private double overAllRateOfInc;
    private double recentRateOfInc;
    private double threshold;
    private TPVData data;
    private boolean calcFlag = false;
    private PerfDescriptor pd;
    private int dataId;
    protected String userId = null;
    protected String logName = null;

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public ClientRateIncreaseCalc() {
        this.clear();
    }

    public void init(PerfDescriptor perfDescriptor, double d) {
        this.init(perfDescriptor, perfDescriptor.getDataDescriptor().getDataId(), d);
    }

    public void init(PerfDescriptor perfDescriptor, int n, double d) {
        this.clear();
        this.pd = perfDescriptor;
        this.threshold = d;
        this.dataId = n;
        this._init();
    }

    private void _init() {
        if (this.data == null) {
            this.data = TPVData.createData(this.pd, this.dataId, this.userId, this.logName);
        }
        if (this.data != null && this.data.numItemsInCache() == 0) {
            this.data = null;
        }
    }

    public double getPercentExceed() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientRateIncreaseCalc] getPercentExceed() returned: " + this.percentExceed);
        return this.percentExceed;
    }

    public double getAverageRateOfIncrease() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientRateIncreaseCalc] getAverageRateOfIncrease() returned: " + this.overAllRateOfInc);
        return this.overAllRateOfInc;
    }

    public double getIntervalRateIncrease() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientRateIncreaseCalc] getIntervalRateIncrease() returned: " + this.recentRateOfInc);
        return this.recentRateOfInc;
    }

    public int getMaxInARowCount() {
        if (!this.calcFlag) {
            this.calc();
        }
        Tr.debug(tc, "[ClientRateIncreaseCalc] getMaxInARowCount() returned: " + this.maxExceedInRow);
        return this.maxExceedInRow;
    }

    public void clear() {
        this.calcFlag = false;
        this.maxExceedInRow = -102;
        this.percentExceed = -102.0;
        this.overAllRateOfInc = -102.0;
        this.recentRateOfInc = -102.0;
        if (this.data != null) {
            this.data.clear();
        }
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public double getThreshold() {
        return this.threshold;
    }

    private void calc() {
        double d;
        this._init();
        if (this.data == null) {
            this.calcFlag = false;
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.data.numItemsInCache();
        for (int i = n3 - 2; i >= 0; --i) {
            double d2 = this._calcRate(this.data.getCacheValue(i), this.data.getCacheValue(i + 1));
            if (d2 >= this.threshold) {
                ++n2;
                ++n;
                continue;
            }
            if (this.maxExceedInRow < n) {
                this.maxExceedInRow = n;
            }
            n = 0;
        }
        if (this.maxExceedInRow < n) {
            this.maxExceedInRow = n;
        }
        if ((d = (double)n3 - 1.0) == 0.0) {
            this.percentExceed = 0.0;
            this.recentRateOfInc = 0.0;
            this.overAllRateOfInc = 0.0;
        } else {
            this.percentExceed = (double)n2 / d * 100.0;
            this.overAllRateOfInc = this._calcRate(this.data.getCacheValue(0), this.data.getCacheValue(n3 - 1));
            this.recentRateOfInc = this._calcRate(this.data.getCacheValue(0), this.data.getCacheValue(1));
        }
        this.calcFlag = true;
    }

    private double _calcRate(WSStatistic wSStatistic, WSStatistic wSStatistic2) {
        if (wSStatistic2 == null || wSStatistic == null || this.data.getType() != 2) {
            return 0.0;
        }
        double d = wSStatistic.getLastSampleTime() - wSStatistic2.getLastSampleTime();
        if (d == 0.0) {
            return 0.0;
        }
        return (double)(((WSCountStatistic)wSStatistic).getCount() - ((WSCountStatistic)wSStatistic2).getCount()) / (d /= 1000.0);
    }

    public void dump() {
        StringBuffer stringBuffer = new StringBuffer("ClientRateIncreaseCalc dump:\n");
        stringBuffer.append("% exceed = ");
        stringBuffer.append(this.percentExceed);
        stringBuffer.append("; maxExceedInRow = ");
        stringBuffer.append(this.maxExceedInRow);
        stringBuffer.append("; rateOfInc = ");
        stringBuffer.append(this.overAllRateOfInc);
        Tr.debug(tc, stringBuffer.toString());
    }
}

