/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.performance.tuning.calc.ILogReadingCalc;
import com.ibm.ws.performance.tuning.calc.ISessionCalc;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.tpv.advisor.calc.TPVData;
import java.util.ArrayList;

public class ClientSessionCalc
implements ISessionCalc,
ILogReadingCalc {
    private static TraceComponent tc = Tr.register(ClientSessionCalc.class, null, null);
    protected PerfDescriptor sessionPD;
    protected TPVData sessionData;
    protected WSStatistic val;
    protected WSTimeStatistic stat;
    protected WSRangeStatistic load;
    protected String[] sessionModule = new String[]{"servletSessionsModule"};
    protected String userId = null;
    protected String logName = null;

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public void init(String string, String string2) {
        this.sessionPD = new PerfDescriptorImpl(string, string2, new DataDescriptor(this.sessionModule));
        this.sessionPD.postInit();
    }

    public PerfDescriptor getSessionPD() {
        return this.sessionPD;
    }

    public PerfDescriptor[] getWebApps() {
        TPVData tPVData = TPVData.createData(this.sessionPD, this.userId, this.logName);
        if (tPVData == null) {
            return null;
        }
        ArrayList arrayList = tPVData.getChildren();
        PerfDescriptor[] perfDescriptorArray = new PerfDescriptor[arrayList.size()];
        for (int i = 0; i < perfDescriptorArray.length; ++i) {
            perfDescriptorArray[i] = (PerfDescriptor)arrayList.get(i);
        }
        return perfDescriptorArray;
    }

    public long getCreatedSessions(PerfDescriptor perfDescriptor) {
        this.sessionData = TPVData.createData(perfDescriptor, 1, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        this.val = this.sessionData.getCacheValue(0);
        if (this.val == null) {
            return -102L;
        }
        long l = ((WSCountStatistic)this.val).getCount();
        Tr.debug(tc, "[ClientSessionCalc] getCreatedSessions() returned: " + l);
        if (this.sessionData != null) {
            this.sessionData.dump();
        }
        return l;
    }

    public long getInvalidatedSessions(PerfDescriptor perfDescriptor) {
        this.sessionData = TPVData.createData(perfDescriptor, 2, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        this.val = this.sessionData.getCacheValue(0);
        if (this.val == null) {
            return -102L;
        }
        long l = ((WSCountStatistic)this.val).getCount();
        Tr.debug(tc, "[ClientSessionCalc] getInvalidatedSessions() returned: " + l);
        if (this.sessionData != null) {
            this.sessionData.dump();
        }
        return l;
    }

    public long getActiveSessions(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 6, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getActiveSessions()");
        return this.extractRangeStat(this.sessionData, s);
    }

    public long getLiveSessions(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 7, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getLiveSessions()");
        return this.extractRangeStat(this.sessionData, s);
    }

    public long getSessionLifeTime(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 4, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getSessionLifeTime()");
        return this.extractTimeStat(this.sessionData, s);
    }

    public long getCacheDiscards(PerfDescriptor perfDescriptor) {
        this.sessionData = TPVData.createData(perfDescriptor, 9, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        this.val = this.sessionData.getCacheValue(0);
        if (this.val == null) {
            return -102L;
        }
        long l = ((WSCountStatistic)this.val).getCount();
        Tr.debug(tc, "[ClientSessionCalc] getCacheDiscards() returned: " + l);
        if (this.sessionData != null) {
            this.sessionData.dump();
        }
        return l;
    }

    public long getExternalReadTime(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 10, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getExternalReadTime()");
        return this.extractTimeStat(this.sessionData, s);
    }

    public long getExternalReadSize(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 11, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getExternalReadSize()");
        return this.extractTimeStat(this.sessionData, s);
    }

    public long getExternalWriteTime(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 12, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getExternalWriteTime()");
        return this.extractTimeStat(this.sessionData, s);
    }

    public long getExternalWriteSize(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 13, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getExternalWriteSize()");
        return this.extractTimeStat(this.sessionData, s);
    }

    public long getSerializableSessObjSize(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 18, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getSerializableSessObjSize()");
        return this.extractTimeStat(this.sessionData, s);
    }

    public long getTimeSinceLastActivated(PerfDescriptor perfDescriptor, short s) {
        this.sessionData = TPVData.createData(perfDescriptor, 15, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        Tr.debug(tc, "[ClientSessionCalc] getTimeSinceLastActivated()");
        return this.extractTimeStat(this.sessionData, s);
    }

    public long getInvalidatedViaTimeout(PerfDescriptor perfDescriptor) {
        this.sessionData = TPVData.createData(perfDescriptor, 16, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        this.val = this.sessionData.getCacheValue(0);
        if (this.val == null) {
            return -102L;
        }
        long l = ((WSCountStatistic)this.val).getCount();
        Tr.debug(tc, "[ClientSessionCalc] getInvalidatedViaTimeout() returned: " + l);
        if (this.sessionData != null) {
            this.sessionData.dump();
        }
        return l;
    }

    public long getAffinityBreaks(PerfDescriptor perfDescriptor) {
        this.sessionData = TPVData.createData(perfDescriptor, 14, this.userId, this.logName);
        if (this.sessionData == null) {
            return -102L;
        }
        this.val = this.sessionData.getCacheValue(0);
        if (this.val == null) {
            return -102L;
        }
        long l = ((WSCountStatistic)this.val).getCount();
        Tr.debug(tc, "[ClientSessionCalc] getAffinityBreaks() returned: " + l);
        return l;
    }

    public void clear() {
    }

    protected long extractRangeStat(TPVData tPVData, short s) {
        long l;
        this.val = tPVData.getCacheValue(0);
        if (this.val == null) {
            return -102L;
        }
        if (!(this.val instanceof WSRangeStatistic)) {
            return -100L;
        }
        this.load = (WSRangeStatistic)this.val;
        switch (s) {
            case 10: {
                l = this.load.getHighWaterMark();
                break;
            }
            case 11: {
                l = this.load.getLowWaterMark();
                break;
            }
            case 12: {
                l = this.load.getCurrent();
                break;
            }
            default: {
                l = -100L;
            }
        }
        Tr.debug(tc, "[ClientSessionCalc] extractRangeStat() returned: " + l);
        if (tPVData != null) {
            tPVData.dump();
        }
        return l;
    }

    protected long extractTimeStat(TPVData tPVData, short s) {
        long l;
        this.val = tPVData.getCacheValue(0);
        if (this.val == null) {
            return -102L;
        }
        if (!(this.val instanceof WSTimeStatistic)) {
            return -100L;
        }
        this.stat = (WSTimeStatistic)this.val;
        Tr.debug(tc, "[ClientSessionCalc] TS_VAL: " + s + " TS_COUNT: " + 0 + " TS_MAX: " + 1 + " TS_MIN: " + 2 + " TS_TOTAL: " + 3 + " TS_MEAN: " + 4);
        switch (s) {
            case 0: {
                l = this.stat.getCount();
                break;
            }
            case 1: {
                l = this.stat.getMax();
                break;
            }
            case 2: {
                l = this.stat.getMin();
                break;
            }
            case 3: {
                l = this.stat.getTotal();
                break;
            }
            case 4: {
                l = (long)this.stat.getMean();
                break;
            }
            default: {
                l = -100L;
            }
        }
        Tr.debug(tc, "[ClientSessionCalc] extractTimeStat() returned: " + l);
        if (tPVData != null) {
            tPVData.dump();
        }
        return l;
    }
}

