/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSDoubleStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.StatResult;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TPVData {
    private static TraceComponent tc = Tr.register(TPVData.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");
    public static final String MSG_BUNDLE = "com.ibm.ws.tpv.advisor.property.tpvadvisor";
    public static final String MSG_GROUP = "TivoliPerformanceAdvisor";
    public static final int ALL_DATA = -201;
    private static final String tpvQuery = "WebSphere:type=TivoliPerfEngine,*,node=";
    private static AdminService adminService = null;
    private static ObjectName tpvEngine = null;
    private static HashMap lookupCache = new HashMap();
    private StatResult[] cachedStatResults = null;
    private PerfDescriptor _pd = null;
    private TreeLookup _lut = null;
    private int _id = -201;
    private int _statType = -1;
    private String _node;
    private String _server;
    private String _userId;
    private String _key;
    private String _logName;

    private TPVData(PerfDescriptor perfDescriptor, int n, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>", new Object[]{perfDescriptor, new Integer(n), string, string2});
        }
        this._pd = perfDescriptor;
        this._id = n;
        this._node = perfDescriptor.getNodeName();
        this._server = perfDescriptor.getServerName();
        this._userId = string;
        this._logName = string2;
        String[] stringArray = this._pd.getDataDescriptor().getPath();
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length == 1) {
            stringBuffer.append("server,").append(stringArray[0]);
        } else if (stringArray.length > 1) {
            if (stringArray[0].equals("server")) {
                stringBuffer.append(stringArray[0]);
            } else {
                stringBuffer.append("server,").append(stringArray[0]);
            }
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(",").append(stringArray[i]);
            }
        }
        this._key = stringBuffer.toString();
        TPVData.init();
        this._lut = this.buildLut(this._userId, this._node, this._server, this._logName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    public static TPVData createData(PerfDescriptor perfDescriptor, int n, String string, String string2) {
        TPVData tPVData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createData", new Object[]{perfDescriptor, new Integer(n), string, string2});
        }
        if ((tPVData = new TPVData(perfDescriptor, n, string, string2)).getUID() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createData - no UID given, return null");
            }
            return null;
        }
        if (n == -201) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createData - return all data");
            }
            return tPVData;
        }
        if (tPVData.getValue() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createData - data value is null, return null");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createData");
        }
        return tPVData;
    }

    public static TPVData createData(PerfDescriptor perfDescriptor, String string, String string2) {
        return TPVData.createData(perfDescriptor, -201, string, string2);
    }

    private static void init() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "init");
            }
            if (adminService != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "init - already initialized, returning");
                }
                return;
            }
            adminService = AdminServiceFactory.getAdminService();
            try {
                String string = adminService.getNodeName();
                ObjectName objectName = new ObjectName(tpvQuery + string);
                Set set = adminService.queryNames(objectName, null);
                if (!set.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "init - TPV MBean found");
                    }
                    tpvEngine = (ObjectName)set.iterator().next();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "init - TPV MBean was not found");
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "init - caught MalformedObjectNameException");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    private static void monitor(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitor", new String[]{string, string2, string3});
        }
        ServerBean serverBean = new ServerBean(string2, string3);
        Object[] objectArray = new Object[]{string, serverBean};
        String[] stringArray = new String[]{"java.lang.String", "com.ibm.ws.tpv.engine.utils.ServerBean"};
        try {
            boolean bl = (Boolean)adminService.invoke(tpvEngine, "isServerMonitored", objectArray, stringArray);
            if (!bl) {
                UserPreferences userPreferences = new UserPreferences();
                userPreferences.setNodeName(string2);
                userPreferences.setServerName(string3);
                userPreferences.setUserId(string);
                userPreferences.setBufferSize(40);
                userPreferences.setRefreshRate(45);
                objectArray = new Object[]{userPreferences};
                stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
                Tr.debug(tc, "server: " + string3 + " is not monitored, invoking monitorServer()");
                adminService.invoke(tpvEngine, "monitorServer", objectArray, stringArray);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception while checking if server is monitored");
            }
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "monitor");
        }
    }

    private TreeLookup buildLut(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildLut", new String[]{string, string2, string3, string4});
        }
        if (adminService == null || tpvEngine == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "buildLut - not intialized, returning null");
            }
            return null;
        }
        String string5 = TPVData.createKey(string, string2, string3, string4);
        TreeLookup treeLookup = TPVData.getLut(string5);
        if (treeLookup != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "buildLut - returning cached Lut");
            }
            return treeLookup;
        }
        Object[] objectArray = new Object[1];
        StatRequest statRequest = new StatRequest(string2, string3, 0, false, false, null, this._userId);
        if (string4 != null) {
            statRequest.setLog(true);
            statRequest.setLogName(string4);
        }
        objectArray[0] = statRequest;
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.buffer.StatRequest"};
        TreeNodeData treeNodeData = null;
        try {
            treeNodeData = (TreeNodeData)adminService.invoke(tpvEngine, "getIdentifierTree", objectArray, stringArray);
            Tr.debug(tc, "tData.numChildren(): " + treeNodeData.getNumChildren());
            while (treeNodeData.getNumChildren() == 0) {
                Tr.debug(tc, "[TPVData] sleeping for 10 seconds...");
                Thread.sleep(10000L);
                Tr.debug(tc, "[TPVData] waking up...");
                treeNodeData = (TreeNodeData)adminService.invoke(tpvEngine, "getIdentifierTree", objectArray, stringArray);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "buildLug - caught exception while getting identifier tree");
            }
            exception.printStackTrace();
        }
        TreeLookup treeLookup2 = new TreeLookup(treeNodeData);
        TPVData.cacheLut(string5, treeLookup2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildLut");
        }
        return treeLookup2;
    }

    private static void cacheLut(String string, TreeLookup treeLookup) {
        if (lookupCache == null) {
            lookupCache = new HashMap();
        }
        lookupCache.put(string, treeLookup);
    }

    private static TreeLookup getLut(String string) {
        if (lookupCache == null) {
            return null;
        }
        return (TreeLookup)lookupCache.get(string);
    }

    private static String createKey(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(string).append("-");
        if (string4 != null) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append(string2).append("-").append(string3);
        }
        return stringBuffer.toString();
    }

    public void clear() {
        this.cachedStatResults = null;
        lookupCache = null;
    }

    public WSStatistic getValue() {
        return this.getCacheValue(0);
    }

    public int numItemsInCache() {
        StatResult[] statResultArray = this.getStatResults();
        if (statResultArray != null && statResultArray.length > 0) {
            return statResultArray[0].getLength();
        }
        return 0;
    }

    public ArrayList getChildren() {
        return this._lut.getChildren(this._key, this._id);
    }

    public WSStatistic getCacheValue(int n) {
        return this.getCacheValue(n, this._id);
    }

    public WSStatistic getCacheValue(int n, int n2) {
        return this.getCacheValue(n, n2, null);
    }

    public WSStatistic getCacheValue(int n, int n2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheValue");
        }
        if (n2 == -201) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCacheValue");
            }
            return null;
        }
        StatResult[] statResultArray = this.getStatResults();
        if (statResultArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCacheValue");
            }
            return null;
        }
        WSStats wSStats = statResultArray[0].getStat(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCacheValue -     stat " + wSStats);
            Tr.debug(tc, "getCacheValue -     id " + n2);
            Tr.debug(tc, "getCacheValue -     index " + n);
        }
        WSStats wSStats2 = wSStats;
        if (string != null) {
            wSStats2 = wSStats.getStats(string);
        }
        if (wSStats2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCacheValue - unable to find requested subStats, returning null");
            }
            return null;
        }
        WSStatistic wSStatistic = wSStats2.getStatistic(n2);
        if (this._statType == -1 && wSStatistic != null) {
            if (wSStatistic instanceof WSCountStatistic) {
                this._statType = 2;
            } else if (wSStatistic instanceof WSDoubleStatistic) {
                this._statType = 3;
            } else if (wSStatistic instanceof WSTimeStatistic) {
                this._statType = 4;
            } else if (wSStatistic instanceof WSAverageStatistic) {
                this._statType = 6;
            } else if (wSStatistic instanceof WSRangeStatistic) {
                this._statType = 7;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheValue");
        }
        return wSStatistic;
    }

    public int getType() {
        return this._statType;
    }

    public void getData() {
    }

    public void dump() {
    }

    public Integer getUID() {
        return this._lut.getUID(this._key);
    }

    private StatResult[] getStatResults() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatResults");
        }
        if (this._lut == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatResults - LUT is null, returning null");
            }
            return null;
        }
        if (this.cachedStatResults != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatResults - returning cached results");
            }
            return this.cachedStatResults;
        }
        Integer n = this._lut.getUID(this._key);
        int n2 = n;
        int[] nArray = new int[]{this._id};
        if (nArray[0] == -201) {
            nArray = null;
        }
        StatRequest statRequest = new StatRequest(this._node, this._server, n2, true, true, nArray, this._userId);
        if (this._logName != null) {
            statRequest.setLog(true);
            statRequest.setLogName(this._logName);
        }
        StatRequest[] statRequestArray = new StatRequest[]{statRequest};
        Object[] objectArray = new Object[]{statRequestArray};
        String[] stringArray = new String[]{"[Lcom.ibm.ws.tpv.engine.buffer.StatRequest;"};
        try {
            StatResult[] statResultArray = (StatResult[])adminService.invoke(tpvEngine, "getFromBuffer", objectArray, stringArray);
            this.cachedStatResults = statResultArray;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatResults");
            }
            return statResultArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatResults - returning null");
            }
            return null;
        }
    }

    private class TreeLookup {
        private HashMap map = new HashMap();

        public TreeLookup(TreeNodeData treeNodeData) {
            this.mapTree(0, treeNodeData, null);
            Tr.debug(tc, "\n\n[TreeLookup] dumping hashMap...");
        }

        public Integer getUID(String string) {
            return (Integer)this.map.get(string);
        }

        public ArrayList getChildren(String string, int n) {
            ArrayList<PerfDescriptor> arrayList = new ArrayList<PerfDescriptor>();
            String string2 = string + ",";
            Iterator iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3;
                String string4 = (String)iterator.next();
                if (!string4.startsWith(string2) || (string3 = string4.substring(string2.length())).indexOf(44) != -1) continue;
                arrayList.add(this.createPd(string4, n));
            }
            return arrayList;
        }

        public Set getKeys() {
            return this.map.keySet();
        }

        private PerfDescriptor createPd(String string, int n) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray = new String[stringTokenizer.countTokens() + 2];
            stringArray[0] = TPVData.this._node;
            stringArray[1] = TPVData.this._server;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2 + 2] = stringTokenizer.nextToken();
                ++n2;
            }
            PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(stringArray, n);
            perfDescriptorImpl.postInit();
            return perfDescriptorImpl;
        }

        private void listEntries() {
            Set set = this.map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Tr.debug(tc, (String)k + ": " + (Integer)this.map.get(k));
            }
        }

        private void mapTree(int n, TreeNodeData treeNodeData, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string == null ? "" : string + ",");
            stringBuffer.append(treeNodeData.getStatsName());
            int n2 = treeNodeData.getUID();
            Tr.debug(tc, "[TreeLookup] " + this.spacer(n) + "uid: " + n2 + "  name: " + treeNodeData.getStatsName() + "  path: " + stringBuffer.toString());
            this.map.put(stringBuffer.toString(), new Integer(n2));
            for (int i = 0; i < treeNodeData.getNumChildren(); ++i) {
                this.mapTree(n + 1, treeNodeData.getChild(i), stringBuffer.toString());
            }
        }

        private String spacer(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }
}

