/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.advisor.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSBoundaryStatistic;
import com.ibm.websphere.pmi.stat.WSBoundedRangeStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSDoubleStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.tpv.advisor.utils.AdvisorChartData;
import com.ibm.ws.tpv.engine.TPVConstants;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.StatResult;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.buffer.TreeUtil;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.exceptions.UserNotRegisteredException;
import com.ibm.ws.tpv.engine.filter.TPVFilter;
import java.util.ArrayList;
import java.util.Locale;

public class AdvisorChartDataProvider {
    private static TraceComponent tc = Tr.register(AdvisorChartDataProvider.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public static AdvisorChartData get(UserPreferences userPreferences, Locale locale) {
        StatResult[] statResultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", new Object[]{userPreferences});
        }
        if ((statResultArray = AdvisorChartDataProvider.getData(userPreferences)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get - no data returned from server");
            }
            return null;
        }
        AdvisorChartData advisorChartData = new AdvisorChartData();
        AdvisorChartDataProvider.setWebContainerThroughputData(advisorChartData, statResultArray[3]);
        AdvisorChartDataProvider.setEjbContainerThroughputData(advisorChartData, statResultArray[4]);
        AdvisorChartDataProvider.setThreadpoolData(advisorChartData, statResultArray[0]);
        AdvisorChartDataProvider.setDatasourceData(advisorChartData, statResultArray[2]);
        AdvisorChartDataProvider.setCpuData(advisorChartData, statResultArray[1], userPreferences);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", advisorChartData);
        }
        return advisorChartData;
    }

    private static void setCpuData(AdvisorChartData advisorChartData, StatResult statResult, UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCpuData");
        }
        if (statResult == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCpuData - null StatResult");
            }
            return;
        }
        WSStats wSStats = statResult.getStat(0);
        if (wSStats == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCpuData - null Stats");
            }
            return;
        }
        if (TPVEngine.getEngine().isND() && !userPreferences.getViewLog() && (wSStats = wSStats.getStats("systemModule")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCpuData - ND and null systemData");
            }
            return;
        }
        WSStatistic wSStatistic = wSStats.getStatistic(1);
        if (wSStatistic == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCpuData - null Statistic");
            }
            return;
        }
        advisorChartData.setCpuUsageAvailable(true);
        advisorChartData.setCpuUsageName(wSStatistic.getName());
        long l = (long)AdvisorChartDataProvider.getValue(wSStats.getStatistic(1));
        advisorChartData.setCpuUsageIdle(100L - l);
        advisorChartData.setCpuUsageUsed(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCpuData");
        }
    }

    private static void setThreadpoolData(AdvisorChartData advisorChartData, StatResult statResult) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreadpoolData");
        }
        if (statResult == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setThreadpoolData - null StatResult");
            }
            return;
        }
        WSStats wSStats = statResult.getStat(0);
        if (wSStats == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setThreadpoolData - null Stats");
            }
            return;
        }
        WSStats[] wSStatsArray = wSStats.getSubStats();
        if (wSStatsArray != null && wSStatsArray.length > 0) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            ArrayList<Long> arrayList4 = new ArrayList<Long>();
            for (n = 0; n < wSStatsArray.length; ++n) {
                if (wSStatsArray[n].numStatistics() == 0) continue;
                long l = AdvisorChartDataProvider.getThreadPoolSize(wSStatsArray[n]);
                long l2 = AdvisorChartDataProvider.getThreadPoolActive(wSStatsArray[n]);
                if (l2 < 0L) {
                    l2 = 0L;
                }
                long l3 = l - l2;
                arrayList.add(wSStatsArray[n].getName());
                arrayList2.add(wSStatsArray[n].getStatsType());
                arrayList3.add(new Long(l3));
                arrayList4.add(new Long(l2));
            }
            n = arrayList.size();
            if (n > 0) {
                String[] stringArray = new String[n];
                String[] stringArray2 = new String[n];
                long[] lArray = new long[n];
                long[] lArray2 = new long[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                    stringArray2[i] = (String)arrayList2.get(i);
                    lArray[i] = (Long)arrayList3.get(i);
                    lArray2[i] = (Long)arrayList4.get(i);
                }
                advisorChartData.setThreadPoolsAvailable(true);
                advisorChartData.setThreadPoolNames(stringArray);
                advisorChartData.setThreadPoolTypes(stringArray2);
                advisorChartData.setThreadPoolConnectionsIdle(lArray);
                advisorChartData.setThreadPoolConnectionsUsed(lArray2);
            } else {
                advisorChartData.setThreadPoolsAvailable(false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadpoolData");
        }
    }

    private static void setDatasourceData(AdvisorChartData advisorChartData, StatResult statResult) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDatasourceData");
        }
        if (statResult == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setDatasourceData - null StatResult");
            }
            return;
        }
        WSStats wSStats = statResult.getStat(0);
        if (wSStats == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setDatasourceData - null Stats");
            }
            return;
        }
        WSStats[] wSStatsArray = wSStats.getSubStats();
        if (wSStatsArray != null && wSStatsArray.length > 0) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            ArrayList<Long> arrayList4 = new ArrayList<Long>();
            for (n = 0; n < wSStatsArray.length; ++n) {
                WSStats[] wSStatsArray2 = wSStatsArray[n].getSubStats();
                if (wSStatsArray2 == null || wSStatsArray2.length <= 0) continue;
                for (int i = 0; i < wSStatsArray2.length; ++i) {
                    if (wSStatsArray2[i].numStatistics() == 0) continue;
                    long l = AdvisorChartDataProvider.getConnectionPoolSize(wSStatsArray2[i]);
                    long l2 = AdvisorChartDataProvider.getConnectionPoolPercentUsed(wSStatsArray2[i]);
                    long l3 = l2 * l / 100L;
                    if (l3 < 0L) {
                        l3 = 0L;
                    }
                    long l4 = l - l3;
                    arrayList.add(wSStatsArray2[i].getName());
                    arrayList2.add(wSStatsArray2[i].getStatsType());
                    arrayList3.add(new Long(l4));
                    arrayList4.add(new Long(l3));
                }
            }
            n = arrayList.size();
            if (n > 0) {
                String[] stringArray = new String[n];
                String[] stringArray2 = new String[n];
                long[] lArray = new long[n];
                long[] lArray2 = new long[n];
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = (String)arrayList2.get(i);
                    stringArray[i] = (String)arrayList.get(i);
                    lArray[i] = (Long)arrayList4.get(i);
                    lArray2[i] = (Long)arrayList3.get(i);
                }
                advisorChartData.setDataSourcesAvailable(true);
                advisorChartData.setDataSourceNames(stringArray);
                advisorChartData.setDataSourceTypes(stringArray2);
                advisorChartData.setDataSourceConnectionsIdle(lArray2);
                advisorChartData.setDataSourceConnectionsUsed(lArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDatasourceData");
        }
    }

    private static void setWebContainerThroughputData(AdvisorChartData advisorChartData, StatResult statResult) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWebContainerThroughputData");
        }
        if (statResult == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setWebContainerThroughputData - null StatResult");
            }
            return;
        }
        WSStats[] wSStatsArray = statResult.getStatsArray();
        if (wSStatsArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setWebContainerThroughputData - null Stats");
            }
            return;
        }
        if (wSStatsArray.length > 1) {
            WSStatistic wSStatistic = wSStatsArray[0].getStatistic(11);
            WSStatistic wSStatistic2 = wSStatsArray[wSStatsArray.length - 1].getStatistic(11);
            if (wSStatistic == null || wSStatistic2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setWebContainerThroughputData - null Statistic");
                }
                return;
            }
            double d = AdvisorChartDataProvider.reqsPerSecond(AdvisorChartDataProvider.getValue(wSStatistic), AdvisorChartDataProvider.getValue(wSStatistic2), wSStatistic.getLastSampleTime(), wSStatistic2.getLastSampleTime());
            advisorChartData.setWebContainerRequestsPerSecond(d);
            double d2 = 0.0;
            for (int i = 0; i < wSStatsArray.length; ++i) {
                d2 += AdvisorChartDataProvider.getValue(wSStatsArray[i].getStatistic(13));
            }
            advisorChartData.setWebContainerResponseTime(d2 /= (double)wSStatsArray.length);
            advisorChartData.setWebContainerAvailable(true);
        } else if (wSStatsArray[0].numStatistics() > 0) {
            advisorChartData.setWebContainerRequestsPerSecond(0.0);
            advisorChartData.setWebContainerResponseTime(0.0);
            advisorChartData.setWebContainerAvailable(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWebContainerThroughputData");
        }
    }

    private static void setEjbContainerThroughputData(AdvisorChartData advisorChartData, StatResult statResult) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWebContainerThroughputData");
        }
        if (statResult == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setWebContainerThroughputData - null StatResult");
            }
            return;
        }
        WSStats[] wSStatsArray = statResult.getStatsArray();
        if (wSStatsArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setWebContainerThroughputData - null Stats");
            }
            return;
        }
        if (wSStatsArray.length > 1) {
            WSStatistic wSStatistic = wSStatsArray[0].getStatistic(11);
            WSStatistic wSStatistic2 = wSStatsArray[wSStatsArray.length - 1].getStatistic(11);
            if (wSStatistic == null || wSStatistic2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setEjbThroughputData - null Statistic");
                }
                return;
            }
            double d = AdvisorChartDataProvider.reqsPerSecond(AdvisorChartDataProvider.getValue(wSStatistic), AdvisorChartDataProvider.getValue(wSStatistic2), wSStatistic.getLastSampleTime(), wSStatistic2.getLastSampleTime());
            advisorChartData.setEjbContainerRequestsPerSecond(d);
            double d2 = 0.0;
            for (int i = 0; i < wSStatsArray.length; ++i) {
                d2 += AdvisorChartDataProvider.getValue(wSStatsArray[i].getStatistic(12));
            }
            advisorChartData.setEjbContainerResponseTime(d2 /= (double)wSStatsArray.length);
            advisorChartData.setEjbContainerAvailable(true);
        } else if (wSStatsArray[0].numStatistics() > 0) {
            advisorChartData.setEjbContainerRequestsPerSecond(0.0);
            advisorChartData.setEjbContainerResponseTime(0.0);
            advisorChartData.setEjbContainerAvailable(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWebContainerThroughputData");
        }
    }

    private static double reqsPerSecond(double d, double d2, long l, long l2) {
        double d3 = d - d2;
        double d4 = (l - l2) / 1000L;
        if (d4 == 0.0) {
            return 0.0;
        }
        return d3 / d4;
    }

    private static StatResult[] getData(UserPreferences userPreferences) {
        int n;
        TPVFilter tPVFilter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getData", new Object[]{userPreferences});
        }
        if ((tPVFilter = TPVEngine.getEngine().getFilter()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getData - unable to get filter reference");
            }
            return null;
        }
        String string = userPreferences.getServerName();
        String string2 = userPreferences.getNodeName();
        StatRequest statRequest = new StatRequest(string2, string, 0, true, false, null, userPreferences.getUserId());
        if (userPreferences.getViewLog()) {
            statRequest.setLog(true);
            statRequest.setLogName(userPreferences.getLogFileName());
        }
        TreeNodeData treeNodeData = null;
        try {
            treeNodeData = tPVFilter.getTreeStructure(statRequest);
        }
        catch (NotFoundException notFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR!");
            }
            notFoundException.printStackTrace();
        }
        if (treeNodeData == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getData - unable to get TreeNodeData");
            }
            return null;
        }
        TreeUtil treeUtil = new TreeUtil(treeNodeData);
        StatRequest[] statRequestArray = new StatRequest[5];
        int n2 = treeUtil.getUID(TPVConstants.THREADPOOLS_PATH);
        if (n2 != -1) {
            statRequestArray[0] = new StatRequest(string2, string, n2, true, false, null, userPreferences.getUserId());
        }
        if (TPVEngine.getEngine().isND() && !userPreferences.getViewLog()) {
            statRequestArray[1] = new StatRequest(string2, string, 0, false, false, null, userPreferences.getUserId());
            statRequestArray[1].setLinkSystemData(true);
        } else {
            n2 = treeUtil.getUID(TPVConstants.CPU_USAGE_PATH);
            if (n2 != -1) {
                statRequestArray[1] = new StatRequest(string2, string, n2, false, false, null, userPreferences.getUserId());
            }
        }
        n2 = treeUtil.getUID(TPVConstants.DATA_SOURCES_PATH);
        if (n2 != -1) {
            statRequestArray[2] = new StatRequest(string2, string, n2, true, false, null, userPreferences.getUserId());
        }
        if ((n2 = treeUtil.getUID(TPVConstants.WEB_CONTAINER_PATH)) != -1) {
            statRequestArray[3] = new StatRequest(string2, string, n2, false, true, null, userPreferences.getUserId());
        }
        if ((n2 = treeUtil.getUID(TPVConstants.EJB_CONTAINER_PATH)) != -1) {
            statRequestArray[4] = new StatRequest(string2, string, n2, false, true, null, userPreferences.getUserId());
        }
        for (n = 0; n < statRequestArray.length; ++n) {
            if (statRequestArray[n] == null || !userPreferences.getViewLog()) continue;
            statRequestArray[n].setLog(true);
            statRequestArray[n].setLogName(userPreferences.getLogFileName());
        }
        if (tc.isDebugEnabled()) {
            for (n = 0; n < statRequestArray.length; ++n) {
                if (statRequestArray[n] != null) {
                    Tr.debug(tc, "getData - request " + n + ":" + statRequestArray[n].toString());
                    continue;
                }
                Tr.debug(tc, "getData - request " + n + ": null");
            }
        }
        StatResult[] statResultArray = null;
        try {
            statResultArray = tPVFilter.get(statRequestArray);
        }
        catch (NotFoundException notFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getData - caught NotFoundException while getting data from filter", notFoundException);
            }
            notFoundException.printStackTrace();
        }
        catch (UserNotRegisteredException userNotRegisteredException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getData - caught UserNotRegisteredException while getting data from filter", userNotRegisteredException);
            }
            userNotRegisteredException.printStackTrace();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getData - caught Exception while getting data from filter, message is: " + exception.getMessage(), exception);
            }
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getData", statRequest);
        }
        return statResultArray;
    }

    private static long getThreadPoolSize(WSStats wSStats) {
        WSBoundedRangeStatistic wSBoundedRangeStatistic = (WSBoundedRangeStatistic)wSStats.getStatistic(4);
        if (wSBoundedRangeStatistic == null) {
            return -1L;
        }
        long l = wSBoundedRangeStatistic.getCurrent();
        if (l <= 0L) {
            l = wSBoundedRangeStatistic.getUpperBound();
        }
        return l;
    }

    private static long getThreadPoolActive(WSStats wSStats) {
        WSBoundedRangeStatistic wSBoundedRangeStatistic = (WSBoundedRangeStatistic)wSStats.getStatistic(3);
        if (wSBoundedRangeStatistic == null) {
            return -1L;
        }
        return wSBoundedRangeStatistic.getCurrent();
    }

    private static long getConnectionPoolSize(WSStats wSStats) {
        WSBoundedRangeStatistic wSBoundedRangeStatistic = (WSBoundedRangeStatistic)wSStats.getStatistic(5);
        if (wSBoundedRangeStatistic == null) {
            return -1L;
        }
        long l = wSBoundedRangeStatistic.getCurrent();
        if (l <= 0L) {
            l = wSBoundedRangeStatistic.getUpperBound();
        }
        return l;
    }

    private static long getConnectionPoolPercentUsed(WSStats wSStats) {
        WSRangeStatistic wSRangeStatistic = (WSRangeStatistic)wSStats.getStatistic(9);
        if (wSRangeStatistic == null) {
            return -1L;
        }
        return wSRangeStatistic.getCurrent();
    }

    private static double getValue(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            return -1.0;
        }
        if (wSStatistic instanceof WSCountStatistic) {
            return ((WSCountStatistic)wSStatistic).getCount();
        }
        if (wSStatistic instanceof WSAverageStatistic) {
            return ((WSAverageStatistic)wSStatistic).getMean();
        }
        if (wSStatistic instanceof WSRangeStatistic) {
            return ((WSRangeStatistic)wSStatistic).getCurrent();
        }
        if (wSStatistic instanceof WSDoubleStatistic) {
            return ((WSDoubleStatistic)wSStatistic).getDouble();
        }
        if (wSStatistic instanceof WSBoundaryStatistic) {
            return ((WSBoundaryStatistic)wSStatistic).getUpperBound();
        }
        return 0.0;
    }
}

