/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.dataclasses;

import java.io.Serializable;

public class Buffer
implements Serializable {
    private static final long serialVersionUID = -4330977816336102086L;
    protected Object[] array;
    protected int first;
    protected int last;
    protected int count;
    protected int size;

    public Buffer() {
        this(20);
    }

    public Buffer(int n) {
        this.array = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.array[i] = null;
        }
        this.first = 0;
        this.last = -1;
        this.count = 0;
        this.size = n;
    }

    public int getCount() {
        return this.count;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void setSize(int n) {
        if (n == this.size) {
            return;
        }
        Object[] objectArray = new Object[n];
        if (this.count <= n) {
            for (int i = 0; i < this.count; ++i) {
                objectArray[this.count - 1 - i] = this.fastGet(i);
            }
            this.first = 0;
            this.last = this.count - 1;
        } else if (this.count > n) {
            for (int i = 0; i < n; ++i) {
                objectArray[n - 1 - i] = this.fastGet(i);
            }
            this.first = 0;
            this.last = n - 1;
            this.count = n;
        }
        this.array = objectArray;
        this.size = n;
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n >= this.count) {
            return null;
        }
        n = this.count - 1 - n;
        return this.array[(this.first + n) % this.size];
    }

    public Object fastGet(int n) {
        n = this.count - 1 - n;
        return this.array[(this.first + n) % this.size];
    }

    public synchronized void append(Object object) {
        if (this.count == this.size) {
            this.last = (this.last + 1) % this.size;
            this.first = (this.first + 1) % this.size;
        } else {
            ++this.count;
            ++this.last;
        }
        this.array[this.last] = object;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.count];
        for (int i = 0; i < this.count; ++i) {
            objectArray[i] = this.fastGet(i);
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.count) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.fastGet(i);
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                objectArray[i] = this.fastGet(i);
            }
        }
        return objectArray;
    }

    public synchronized void clear() {
        this.first = 0;
        this.last = -1;
        this.count = 0;
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
    }

    public void dump(String string) {
    }
}

