/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.dataclasses;

import java.util.BitSet;

public class GrowableIntArray {
    private int increment;
    private int capacity;
    private int[] array;
    private int count;
    private BitSet occupied;

    public GrowableIntArray() {
        this(5, 5);
    }

    public GrowableIntArray(int n, int n2) {
        this.capacity = n;
        this.increment = n2;
        this.array = new int[this.capacity];
        this.occupied = new BitSet(this.capacity);
        this.count = 0;
    }

    public boolean isOccupied(int n) {
        if (n > this.occupied.size()) {
            return false;
        }
        return this.occupied.get(n);
    }

    public void put(int n, int n2) {
        if (n >= this.capacity) {
            this.capacity = n + this.increment;
            int[] nArray = new int[this.capacity];
            System.arraycopy(this.array, 0, nArray, 0, this.array.length);
            this.array = nArray;
        }
        this.array[n] = n2;
        if (!this.occupied.get(n)) {
            ++this.count;
        }
        this.occupied.set(n);
    }

    public int get(int n) {
        if (this.occupied.get(n)) {
            return this.array[n];
        }
        return 0;
    }

    public void remove(int n) {
        if (n > this.capacity) {
            return;
        }
        this.array[n] = 0;
        if (this.occupied.get(n)) {
            --this.count;
        }
        this.occupied.clear(n);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getCount() {
        return this.count;
    }
}

