/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.dataclasses;

import java.util.BitSet;

public class GrowableObjectArray {
    private int increment;
    private int capacity;
    private Object[] array;
    private int count;
    private BitSet occupied;

    public GrowableObjectArray() {
        this(5, 5);
    }

    public GrowableObjectArray(int n, int n2) {
        this.capacity = n;
        this.increment = n2;
        this.array = new Object[this.capacity];
        this.occupied = new BitSet(this.capacity);
        this.count = 0;
    }

    public boolean isOccupied(int n) {
        if (n > this.occupied.size()) {
            return false;
        }
        return this.occupied.get(n);
    }

    public void put(int n, Object object) {
        if (n >= this.capacity) {
            this.capacity = n + this.increment;
            Object[] objectArray = new Object[this.capacity];
            System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
            this.array = objectArray;
        }
        this.array[n] = object;
        if (!this.occupied.get(n)) {
            ++this.count;
        }
        this.occupied.set(n);
    }

    public Object get(int n) {
        if (this.occupied.get(n)) {
            return this.array[n];
        }
        return null;
    }

    public void remove(int n) {
        if (n > this.capacity) {
            return;
        }
        this.array[n] = null;
        if (this.occupied.get(n)) {
            --this.count;
        }
        this.occupied.clear(n);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getCount() {
        return this.count;
    }
}

