/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.dataclasses;

import java.util.BitSet;

public class GrowableStringArray {
    private int increment;
    private int capacity;
    private String[] array;
    private int count;
    private BitSet occupied;

    public GrowableStringArray() {
        this(5, 5);
    }

    public GrowableStringArray(int n, int n2) {
        this.capacity = n;
        this.increment = n2;
        this.array = new String[this.capacity];
        this.occupied = new BitSet(this.capacity);
        this.count = 0;
    }

    public boolean isOccupied(int n) {
        if (n > this.occupied.size()) {
            return false;
        }
        return this.occupied.get(n);
    }

    public void put(int n, String string) {
        if (n >= this.capacity) {
            this.capacity = n + this.increment;
            String[] stringArray = new String[this.capacity];
            System.arraycopy(this.array, 0, stringArray, 0, this.array.length);
            this.array = stringArray;
        }
        this.array[n] = string;
        if (!this.occupied.get(n)) {
            ++this.count;
        }
        this.occupied.set(n);
    }

    public String get(int n) {
        if (this.occupied.get(n)) {
            return this.array[n];
        }
        return null;
    }

    public void remove(int n) {
        if (n > this.capacity) {
            return;
        }
        this.array[n] = null;
        if (this.occupied.get(n)) {
            --this.count;
        }
        this.occupied.clear(n);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getCount() {
        return this.count;
    }
}

