/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.tpv.advisor.utils.AdvisorChartData;
import com.ibm.ws.tpv.advisor.utils.AdvisorChartDataProvider;
import com.ibm.ws.tpv.engine.EngineActions;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.StatResult;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.exceptions.UserNotRegisteredException;
import com.ibm.ws.tpv.engine.filter.summary.Summary;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;

public class TPVCollaborator
extends RuntimeCollaborator
implements EngineActions,
Serializable {
    private static final long serialVersionUID = 2488808807465340952L;
    private static TraceComponent tc = Tr.register(TPVCollaborator.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");
    protected TPVEngine engine = TPVEngine.getEngine();

    public void monitorServer(UserPreferences userPreferences) throws Exception {
        this.engine.monitorServer(userPreferences);
    }

    public void setUserPreferences(UserPreferences userPreferences) throws Exception {
        this.engine.setUserPreferences(userPreferences);
    }

    public UserPreferences getUserPreferences(UserPreferences userPreferences) throws Exception {
        return this.engine.getUserPreferences(userPreferences);
    }

    public void disableServer(UserPreferences userPreferences) {
        this.engine.disableServer(userPreferences);
    }

    public ServerBean[] getMonitoredServers(String string) {
        return this.engine.getMonitoredServers(string);
    }

    public void restart() throws Exception {
        TPVEngine.restart();
    }

    public boolean isActive() {
        return this.engine.isActive();
    }

    public boolean isServerMonitored(String string, ServerBean serverBean) {
        return this.engine.isServerMonitored(string, serverBean);
    }

    public void register(UserPreferences userPreferences) throws FileNotFoundException, IOException, Exception {
        this.engine.getFilter().register(userPreferences);
    }

    public void cleanup(UserPreferences userPreferences) {
        this.engine.getFilter().cleanup(userPreferences);
    }

    public StatResult[] get(StatRequest[] statRequestArray) throws UserNotRegisteredException, NotFoundException, Exception {
        if (this.engine.getFilter() == null) {
            return null;
        }
        if (statRequestArray != null) {
            for (int i = 0; i < statRequestArray.length; ++i) {
                this.engine.logLastRequestTime(statRequestArray[i].getUserID());
            }
        }
        return this.engine.getFilter().get(statRequestArray);
    }

    public Summary getSummary(StatRequest statRequest) throws NotFoundException, Exception {
        if (this.engine.getFilter() == null) {
            return null;
        }
        this.engine.logLastRequestTime(statRequest.getUserID());
        return this.engine.getFilter().getSummary(statRequest);
    }

    public TreeNodeData getIdentifierTree(StatRequest statRequest) throws NotFoundException {
        return this.getTreeStructure(statRequest);
    }

    public TreeNodeData getTreeStructure(StatRequest statRequest) throws NotFoundException {
        this.engine.logLastRequestTime(statRequest.getUserID());
        return this.engine.getTreeStructure(statRequest);
    }

    public StatResult[] getFromBuffer(StatRequest[] statRequestArray) throws NotFoundException {
        if (this.engine.getBuffer() == null) {
            return null;
        }
        return this.engine.getBuffer().get(statRequestArray);
    }

    public void startLogging(UserPreferences userPreferences) {
        this.engine.startLogging(userPreferences);
    }

    public boolean isServerLogging(ServerBean serverBean) {
        return this.engine.isServerLogging(serverBean);
    }

    public void stopLogging(UserPreferences userPreferences) {
        this.engine.stopLogging(userPreferences);
    }

    public AdvisorChartData getAdvisorChartData(UserPreferences userPreferences, Locale locale) {
        return AdvisorChartDataProvider.get(userPreferences, locale);
    }

    public ServerBean getServerFromLog(String string, String string2) {
        return this.engine.getServerFromLog(string, string2);
    }
}

