/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.buffer.UserStatsBuffer;
import com.ibm.ws.tpv.engine.buffer.UserStatsBufferImpl;
import com.ibm.ws.tpv.engine.collector.CollectorImpl;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.filter.TPVFilter;
import com.ibm.ws.tpv.engine.logger.TPVLoggingImpl;
import com.ibm.ws.tpv.engine.user.Registry;
import com.ibm.ws.tpv.engine.user.RegistryImpl;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import com.ibm.ws.tpv.engine.utils.ServerPollingManager;
import com.ibm.ws.tpv.engine.utils.ServerUserBean;
import java.util.HashMap;
import java.util.Observer;

public class TPVEngine {
    private static TraceComponent tc = Tr.register(TPVEngine.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");
    public static final String MSG_BUNDLE = "com.ibm.ws.tpv.engine.property.tpvengine";
    public static final String MSG_GROUP = "TivoliPerformanceViewer";
    private static TPVEngine engine = null;
    private static Repository repository;
    protected boolean isND = false;
    protected String myCell;
    protected String myNode;
    protected String myName;
    protected RegistryImpl userRegistry = null;
    protected ServerPollingManager pollingManager = null;
    private CollectorImpl collector = null;
    private TPVFilter filter = null;
    private UserStatsBuffer userBuffer = null;
    private TPVLoggingImpl logger = null;
    private HashMap lastAccessTimes = null;

    private TPVEngine() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        this.myNode = adminService.getNodeName();
        this.isND = !"UnManagedProcess".equals(adminService.getProcessType());
        this.myCell = adminService.getCellName();
        this.myName = adminService.getProcessName();
    }

    public void shutdown() {
        Registry registry = this.getRegistryForShutdown();
        if (registry == null) {
            return;
        }
        String[] stringArray = registry.getAllRegisteredUsers();
        for (int i = 0; i < stringArray.length; ++i) {
            this.stopAllMonitoredServers(stringArray[i]);
        }
        this.pollingManager = null;
        this.userRegistry = null;
        this.userBuffer = null;
        this.collector = null;
    }

    public void init() {
        this.collector = new CollectorImpl();
        this.collector.init();
        this.userBuffer = new UserStatsBufferImpl();
        this.userRegistry = new RegistryImpl();
        this.pollingManager = new ServerPollingManager(this.userRegistry);
        if (this.filter == null) {
            this.filter = new TPVFilter();
        }
    }

    public boolean isShutdown() {
        return this.pollingManager == null || this.userRegistry == null || this.userBuffer == null || this.collector == null || this.filter == null;
    }

    public CollectorImpl getCollector() {
        if (this.collector == null) {
            this.init();
        }
        return this.collector;
    }

    public void monitorServer(UserPreferences userPreferences) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorServer");
        }
        this.monitorNodeAgent(userPreferences);
        this.getRegistry().addUserPreferences(userPreferences);
        ServerBean serverBean = new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName());
        String string = this.getLoggingUser(serverBean);
        if (string != null && userPreferences.getUserId().equals(string)) {
            this.logger.setStopMonitoring(serverBean, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "monitorServer");
        }
    }

    private void monitorNodeAgent(UserPreferences userPreferences) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorNodeAgent", userPreferences);
        }
        if (!this.isND) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "monitorNodeAgent - not ND");
            }
            return;
        }
        ServerUserBean serverUserBean = new ServerUserBean(userPreferences.getNodeName(), "nodeagent", userPreferences.getUserId());
        UserPreferences userPreferences2 = this.getRegistry().getUserPreferences(serverUserBean);
        if (userPreferences2 == null) {
            userPreferences2 = userPreferences.copy();
            userPreferences2.setServerName("nodeagent");
            this.getRegistry().addUserPreferences(userPreferences2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "monitorNodeAgent - started monitoring node agent");
            }
        } else if (userPreferences2.getRefreshRate() > userPreferences.getRefreshRate()) {
            userPreferences2.setRefreshRate(userPreferences.getRefreshRate());
            this.getRegistry().updateUserPreferences(userPreferences2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "monitorNodeAgent - updated node agent refresh rate");
            }
        }
        if ((string = this.getLoggingUser(serverUserBean)) != null && userPreferences.getUserId().equals(string)) {
            this.logger.setStopMonitoring(serverUserBean, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "monitorNodeAgent");
        }
    }

    public ServerBean[] getMonitoredServers(String string) {
        return this.getRegistry().getMonitoredServers(string);
    }

    public boolean isServerMonitored(String string, ServerBean serverBean) {
        ServerBean[] serverBeanArray = this.getRegistry().getMonitoredServers(string);
        if (serverBeanArray == null) {
            return false;
        }
        for (int i = 0; i < serverBeanArray.length; ++i) {
            if (!serverBeanArray[i].equals(serverBean)) continue;
            return true;
        }
        return false;
    }

    public void disableServer(UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableServer");
        }
        if (userPreferences.getUserId() == null && userPreferences.getServerName() != null) {
            ServerUserBean serverUserBean;
            UserPreferences[] userPreferencesArray;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "disableServer - disable server for all users");
            }
            if ((userPreferencesArray = this.userRegistry.getAllPrefsForServer(serverUserBean = new ServerUserBean(userPreferences.getNodeName(), userPreferences.getServerName(), null))) == null || userPreferencesArray.length == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "disableServer - no one monitoring server");
                }
                return;
            }
            String string = this.getLoggingUser(serverUserBean);
            for (int i = 0; i < userPreferencesArray.length; ++i) {
                String string2 = userPreferencesArray[i].getUserId();
                if (string != null && string.equals(string2)) {
                    this.logger.stopLogging(userPreferencesArray[i]);
                }
                serverUserBean.setUserId(string2);
                this.userRegistry.removeUserPreferences(serverUserBean);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disableServer");
            }
            return;
        }
        if (userPreferences.getNodeName() != null && userPreferences.getServerName() != null || userPreferences.getViewLog() && userPreferences.getLogFileName() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "disableServer - disable specific server/log for given user");
            }
            this.cleanupServer(userPreferences);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disableServer");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "disableServer - disable all servers/logs for given user");
            }
            userPreferences.setNodeName(null);
            ServerBean[] serverBeanArray = this.userBuffer.getServers(userPreferences);
            for (int i = 0; i < serverBeanArray.length; ++i) {
                if (serverBeanArray[i].getNode().equals(userPreferences.getUserId())) {
                    userPreferences.setViewLog(true);
                    userPreferences.setLogFileName(serverBeanArray[i].getServer());
                } else {
                    userPreferences.setViewLog(false);
                    userPreferences.setNodeName(serverBeanArray[i].getNode());
                    userPreferences.setServerName(serverBeanArray[i].getServer());
                }
                this.cleanupServer(userPreferences);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disableServer");
            }
        }
    }

    private void cleanupServer(UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupServer");
        }
        if (userPreferences.getViewLog()) {
            this.filter.cleanup(userPreferences);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanupServer - log file: " + userPreferences.getLogFileName());
            }
            return;
        }
        ServerUserBean serverUserBean = new ServerUserBean(userPreferences.getNodeName(), userPreferences.getServerName(), userPreferences.getUserId());
        String string = this.getLoggingUser(serverUserBean);
        if (string != null && serverUserBean.getUserId().equals(string)) {
            this.logger.setStopMonitoring(serverUserBean, true);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanupServer - server being logged, delay cleanup: " + userPreferences.getServerName());
            }
        } else {
            this.getRegistry().removeUserPreferences(serverUserBean);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanupServer - server cleaned up: " + userPreferences.getServerName());
            }
        }
    }

    private void stopAllMonitoredServers(String string) {
        ServerBean[] serverBeanArray = this.getRegistry().getMonitoredServers(string);
        ServerUserBean serverUserBean = new ServerUserBean(null, null, string);
        for (int i = 0; i < serverBeanArray.length; ++i) {
            serverUserBean.setNode(serverBeanArray[i].getNode());
            serverUserBean.setServer(serverBeanArray[i].getServer());
            this.getRegistry().removeUserPreferences(serverUserBean);
        }
    }

    public static TPVEngine getEngine() {
        if (engine == null) {
            engine = new TPVEngine();
        }
        return engine;
    }

    public void setUserPreferences(UserPreferences userPreferences) throws Exception {
        if (userPreferences != null && UserPreferences.isValid(userPreferences.getUserId())) {
            if (userPreferences.getViewLog()) {
                this.getBuffer().setBufferSize(userPreferences);
            } else if (!this.getRegistry().addUserPreferences(userPreferences)) {
                this.getRegistry().updateUserPreferences(userPreferences);
            }
        } else {
            throw new NotFoundException("Requested preferences for invalid server or username");
        }
    }

    public Registry getRegistry() {
        if (this.userRegistry == null) {
            this.init();
        }
        return this.userRegistry;
    }

    private Registry getRegistryForShutdown() {
        return this.userRegistry;
    }

    public ServerPollingManager getServerPollingManager() {
        if (this.pollingManager == null) {
            this.init();
        }
        return this.pollingManager;
    }

    public UserPreferences getUserPreferences(UserPreferences userPreferences) throws Exception {
        UserPreferences userPreferences2 = null;
        if (!(userPreferences != null && UserPreferences.isValid(userPreferences.getNodeName()) && UserPreferences.isValid(userPreferences.getServerName()) && UserPreferences.isValid(userPreferences.getUserId()))) {
            throw new NotFoundException("Requested preferences for invalid server or username");
        }
        ServerUserBean serverUserBean = new ServerUserBean(userPreferences.getNodeName(), userPreferences.getServerName(), userPreferences.getUserId());
        userPreferences2 = this.getRegistry().getUserPreferences(serverUserBean);
        return userPreferences2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Engine:");
        stringBuffer.append("\n");
        String[] stringArray = this.getRegistry().getAllRegisteredUsers();
        for (int i = 0; i < stringArray.length; ++i) {
            ServerBean[] serverBeanArray = this.getRegistry().getMonitoredServers(stringArray[i]);
            ServerUserBean serverUserBean = new ServerUserBean(null, null, stringArray[i]);
            for (int j = 0; j < serverBeanArray.length; ++j) {
                serverUserBean.setNode(serverBeanArray[j].getNode());
                serverUserBean.setServer(serverBeanArray[j].getServer());
                UserPreferences userPreferences = this.getRegistry().getUserPreferences(serverUserBean);
                stringBuffer.append(userPreferences);
            }
        }
        return stringBuffer.toString();
    }

    public static void restart() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restart");
        }
        TPVEngine.getEngine().resetEngine();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restart");
        }
    }

    public UserStatsBuffer getBuffer() {
        if (this.userBuffer == null) {
            this.init();
        }
        return this.userBuffer;
    }

    public TPVFilter getFilter() {
        if (this.filter == null) {
            this.init();
        }
        return this.filter;
    }

    protected void resetEngine() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetEngine");
        }
        this.shutdown();
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetEngine");
        }
    }

    public void addBufferUpdateListener(Observer observer, UserPreferences userPreferences) {
        this.getServerPollingManager().registerForUpdates(userPreferences, observer);
    }

    public void removeBufferUpdateListener(Observer observer, UserPreferences userPreferences) {
        this.getServerPollingManager().unregisterForUpdates(userPreferences, observer);
    }

    public boolean isActive() {
        String[] stringArray = this.getRegistry().getAllRegisteredUsers();
        return stringArray.length > 0;
    }

    public boolean isND() {
        return this.isND;
    }

    public int getBufferLength(UserPreferences userPreferences) {
        block3: {
            if (this.userBuffer != null) {
                try {
                    return this.userBuffer.getBufferSize(userPreferences);
                }
                catch (NotFoundException notFoundException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Returning persisted buffer size; could not find active buffer data for server " + userPreferences.getServerName());
                }
            }
        }
        return 40;
    }

    public TreeNodeData getTreeStructure(StatRequest statRequest) throws NotFoundException {
        TreeNodeData treeNodeData = null;
        if (engine.getFilter() != null) {
            treeNodeData = engine.getFilter().getTreeStructure(statRequest);
        }
        return treeNodeData;
    }

    public void startLogging(UserPreferences userPreferences) {
        if (this.logger == null) {
            this.logger = new TPVLoggingImpl();
        }
        this.logger.startLogging(userPreferences);
    }

    public boolean isServerLogging(ServerBean serverBean) {
        return this.logger == null ? false : this.logger.isServerLogging(serverBean);
    }

    public String getLoggingUser(ServerBean serverBean) {
        return this.logger == null ? null : this.logger.whoIsLogging(serverBean);
    }

    public void stopLogging(UserPreferences userPreferences) {
        if (this.logger != null) {
            this.logger.stopLogging(userPreferences);
        }
    }

    public ServerBean getServerFromLog(String string, String string2) {
        if (this.filter != null) {
            return this.filter.getServerFromLog(string, string2);
        }
        return null;
    }

    protected void logLastRequestTime(String string) {
        if (this.lastAccessTimes == null) {
            this.lastAccessTimes = new HashMap();
        }
        Long l = new Long(System.currentTimeMillis());
        this.lastAccessTimes.put(string, l);
    }

    public long getLastAccessTime(String string) {
        if (this.lastAccessTimes == null) {
            return -1L;
        }
        Long l = (Long)this.lastAccessTimes.get(string);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public static void setRepository(Repository repository2) {
        repository = repository2;
    }

    public static Repository getRepository() {
        return repository;
    }
}

