/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.runtime.component.TPVServiceImpl;
import com.ibm.ws.tpv.advisor.AdvisorCollaborator;
import com.ibm.ws.tpv.advisor.utils.AdvisorChartData;
import com.ibm.ws.tpv.engine.CollaboratorProxy;
import com.ibm.ws.tpv.engine.TPVCollaborator;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.StatResult;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.filter.summary.Summary;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TPVProxyEngine
implements CollaboratorProxy {
    private static TraceComponent tc = Tr.register(TPVProxyEngine.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");
    private static TPVProxyEngine engine = null;
    private HashMap nodeMBeans = null;
    private HashMap adminClients = null;
    private HashMap mbsdTrees = null;
    private AdminService as = null;
    private boolean isDmgr = false;
    private boolean mbeanStarted = false;
    private ArrayList navList = null;
    private ConfigService configService;
    private HashMap userLogging = null;
    private HashMap tpaChartData = new HashMap();

    private TPVProxyEngine() {
        this.as = AdminServiceFactory.getAdminService();
        if ("DeploymentManager".equals(this.as.getProcessType())) {
            this.isDmgr = true;
        }
        this.configService = ConfigServiceFactory.getConfigService();
    }

    public static TPVProxyEngine getEngine() {
        if (engine == null) {
            engine = new TPVProxyEngine();
        }
        return engine;
    }

    public boolean isActive() {
        return this.nodeMBeans != null && this.nodeMBeans.size() > 0;
    }

    public boolean isActive(String string) throws JMException, ConnectorException {
        return (Boolean)this.invoke("isActive", string);
    }

    public boolean isServerMonitored(String string, ServerBean serverBean) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{string, serverBean};
        String[] stringArray = new String[]{"java.lang.String", "com.ibm.ws.tpv.engine.utils.ServerBean"};
        Boolean bl = (Boolean)this.invoke("isServerMonitored", serverBean.getNode(), objectArray, stringArray);
        return bl;
    }

    public ServerBean[] getMonitoredServers(String string, String string2) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{string2};
        String[] stringArray = new String[]{"java.lang.String"};
        ServerBean[] serverBeanArray = (ServerBean[])this.invoke("getMonitoredServers", string, objectArray, stringArray);
        return serverBeanArray;
    }

    public void monitorServer(UserPreferences userPreferences) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{userPreferences};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        this.invoke("monitorServer", userPreferences.getNodeName(), objectArray, stringArray);
    }

    public void setUserPreferences(UserPreferences userPreferences) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{userPreferences};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        this.invoke("setUserPreferences", userPreferences.getNodeName(), objectArray, stringArray);
    }

    public UserPreferences getUserPreferences(UserPreferences userPreferences) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{userPreferences};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        return (UserPreferences)this.invoke("getUserPreferences", userPreferences.getNodeName(), objectArray, stringArray);
    }

    public void disableServer(UserPreferences userPreferences) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{userPreferences};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        this.invoke("disableServer", userPreferences.getNodeName(), objectArray, stringArray);
    }

    public void restart(String string) throws Exception {
        this.invoke("collectFromNewServer", string);
    }

    public void register(UserPreferences userPreferences) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{userPreferences};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        this.invoke("register", userPreferences.getNodeName(), objectArray, stringArray);
    }

    public StatResult[] get(StatRequest[] statRequestArray) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{statRequestArray};
        String[] stringArray = new String[]{"[Lcom.ibm.ws.tpv.engine.buffer.StatRequest;"};
        try {
            if (statRequestArray == null || statRequestArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "there are zero requests");
                }
                return new StatResult[0];
            }
            StatResult[] statResultArray = (StatResult[])this.invoke("get", statRequestArray[0].getNode(), objectArray, stringArray);
            return statResultArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = arrayIndexOutOfBoundsException.toString();
            throw new JMException(string);
        }
    }

    public Summary getSummary(StatRequest statRequest) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{statRequest};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.buffer.StatRequest"};
        return (Summary)this.invoke("getSummary", statRequest.getNode(), objectArray, stringArray);
    }

    public TreeNodeData getIdentifierTree(StatRequest statRequest, boolean bl) throws ConnectorException, JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdentifierTree");
        }
        String string = statRequest.getNode() + "/" + statRequest.getServer();
        TreeNodeData treeNodeData = null;
        if (this.mbsdTrees != null && !bl && (treeNodeData = (TreeNodeData)this.mbsdTrees.get(string)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getIdentifierTree: found from cache");
            }
            return treeNodeData;
        }
        Object[] objectArray = new Object[]{statRequest};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.buffer.StatRequest"};
        treeNodeData = (TreeNodeData)this.invoke("getIdentifierTree", statRequest.getNode(), objectArray, stringArray);
        if (treeNodeData.getNumChildren() != 0) {
            if (this.mbsdTrees == null) {
                this.mbsdTrees = new HashMap();
            }
            this.mbsdTrees.put(statRequest.getNode() + "/" + statRequest.getServer(), treeNodeData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentifierTree: found from server");
        }
        return treeNodeData;
    }

    protected void setAttribute(String string, Object object, String string2) throws JMException, ConnectorException {
        if (this.isDmgr) {
            this.remoteSetAttribute(string, object, string2);
        } else {
            this.localSetAttribute(string, object, string2);
        }
    }

    public void startLogging(String string, UserPreferences userPreferences) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{userPreferences};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        this.invoke("startLogging", string, objectArray, stringArray);
        if (this.userLogging == null) {
            this.userLogging = new HashMap();
        }
        ServerBean serverBean = new ServerBean(string, userPreferences.getServerName());
        long l = System.currentTimeMillis() + userPreferences.getLoggingDuration() * 1000L;
        UserLogging userLogging = new UserLogging(userPreferences, l);
        this.userLogging.put(serverBean, userLogging);
    }

    public boolean isServerLogging(String string, String string2) {
        if (this.userLogging == null) {
            return false;
        }
        ServerBean serverBean = new ServerBean(string, string2);
        UserLogging userLogging = (UserLogging)this.userLogging.get(serverBean);
        if (userLogging == null) {
            return false;
        }
        if (userLogging.stopTime < System.currentTimeMillis()) {
            this.userLogging.remove(userLogging);
            return false;
        }
        if (this.isDmgr) {
            try {
                Object[] objectArray = new Object[]{serverBean};
                String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.utils.ServerBean"};
                boolean bl = (Boolean)this.invoke("isServerLogging", string, objectArray, stringArray);
                if (!bl) {
                    this.userLogging.remove(userLogging);
                }
                return bl;
            }
            catch (ConnectorException connectorException) {
                connectorException.printStackTrace();
                return false;
            }
            catch (JMException jMException) {
                jMException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public UserPreferences getLoggingUser(String string, String string2) {
        if (this.userLogging == null) {
            return null;
        }
        ServerBean serverBean = new ServerBean(string, string2);
        UserLogging userLogging = (UserLogging)this.userLogging.get(serverBean);
        return userLogging == null ? null : userLogging.prefs;
    }

    public void stopLogging(String string, UserPreferences userPreferences) throws JMException, ConnectorException {
        Object[] objectArray = new Object[]{userPreferences};
        String[] stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences"};
        this.invoke("stopLogging", string, objectArray, stringArray);
        if (this.userLogging == null) {
            return;
        }
        ServerBean serverBean = new ServerBean(string, userPreferences.getServerName());
        this.userLogging.remove(serverBean);
    }

    protected void localSetAttribute(String string, Object object, String string2) throws JMException {
        ObjectName objectName = this.findTPVMBean(string2);
        Attribute attribute = new Attribute(string, object);
        this.as.setAttribute(objectName, attribute);
    }

    protected void remoteSetAttribute(String string, Object object, String string2) throws JMException, ConnectorException {
        ObjectName objectName = this.findTPVMBean(string2);
        Attribute attribute = new Attribute(string, object);
        this.as.setAttribute(objectName, attribute);
    }

    protected Object getAttribute(String string, String string2) throws JMException, ConnectorException {
        if (this.isDmgr) {
            return this.remoteGetAttribute(string, string2);
        }
        return this.localGetAttribute(string, string2);
    }

    protected Object invoke(String string, String string2) throws ConnectorException, JMException {
        return this.invoke(string, string2, null, null);
    }

    protected Object invoke(String string, String string2, Object[] objectArray, String[] stringArray) throws JMException, ConnectorException {
        if (this.isDmgr) {
            return this.remoteInvoke(string, string2, objectArray, stringArray);
        }
        return this.localInvoke(string, string2, objectArray, stringArray);
    }

    protected Object localGetAttribute(String string, String string2) throws JMException {
        return this.as.getAttribute(this.findTPVMBean(string2), string);
    }

    protected Object localInvoke(String string, String string2, Object[] objectArray, String[] stringArray) throws JMException {
        ObjectName objectName = this.findTPVMBean(string2);
        return this.as.invoke(objectName, string, objectArray, stringArray);
    }

    protected Object remoteGetAttribute(String string, String string2) throws JMException, ConnectorException {
        ObjectName objectName = this.findTPVMBean(string2);
        return this.as.getAttribute(objectName, string);
    }

    protected Object remoteInvoke(String string, String string2, Object[] objectArray, String[] stringArray) throws JMException, ConnectorException {
        ObjectName objectName = this.findTPVMBean(string2);
        Tr.debug(tc, "Using MBean: " + objectName.toString());
        return this.as.invoke(objectName, string, objectArray, stringArray);
    }

    protected ObjectName findTPVMBean(String string) throws InstanceNotFoundException {
        ObjectName objectName = null;
        if (this.nodeMBeans == null) {
            this.nodeMBeans = new HashMap();
        }
        if ((objectName = (ObjectName)this.nodeMBeans.get(string)) != null) {
            return objectName;
        }
        objectName = this.lookupTPVMBean(string);
        if (objectName != null) {
            this.nodeMBeans.put(string, objectName);
        }
        return objectName;
    }

    public ObjectName lookupTPVMBean(String string) throws InstanceNotFoundException {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:type=TivoliPerfEngine,*,node=" + string);
            Set set = this.as.queryNames(objectName, null);
            if (set == null || set.size() != 1) {
                if (set.size() > 1) {
                    Tr.debug(tc, "The following TPV MBeans were found:");
                    ObjectName[] objectNameArray = new ObjectName[set.size()];
                    set.toArray(objectNameArray);
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        Tr.debug(tc, objectNameArray[i].toString());
                    }
                }
                throw new InstanceNotFoundException("TPV MBean not found on node " + string);
            }
            return (ObjectName)set.iterator().next();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
            throw new InstanceNotFoundException(malformedObjectNameException.toString());
        }
    }

    protected AdminClient getAdminClient(String string) throws ConnectorException, JMException {
        AdminClient adminClient = null;
        if (this.adminClients == null) {
            this.adminClients = new HashMap();
        } else {
            adminClient = (AdminClient)this.adminClients.get(string);
        }
        if (adminClient == null) {
            ObjectName objectName = new ObjectName("WebSphere:type=JMXConnector,process=nodeagent,node=" + string);
            Set set = this.as.queryNames(objectName, null);
            if (set != null && set.size() > 0) {
                ObjectName objectName2 = (ObjectName)set.iterator().next();
                Properties properties = (Properties)this.as.invoke(objectName2, "getProperties", null, null);
                return AdminClientFactory.createAdminClient(properties);
            }
            throw new ConnectorException("Could not create AdminClient to node " + string);
        }
        return adminClient;
    }

    public static String getPmiNLSValue(String string, String string2, Locale locale) {
        if (string2 == null || string == null) {
            return string;
        }
        return StatsConfigHelper.getTranslatedStatsName(string, string2, locale);
    }

    public Document getNewDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return documentBuilder.newDocument();
    }

    public ObjectName[] listNodes() throws ConfigServiceException, ConnectorException {
        ObjectName objectName = null;
        Object var2_2 = null;
        objectName = ConfigServiceHelper.createObjectName(null, "Node", null);
        return this.configService.queryConfigObjects(null, null, objectName, null);
    }

    public ObjectName[] listServers(ObjectName objectName) throws ConfigServiceException, ConnectorException {
        ObjectName objectName2 = null;
        Object var3_3 = null;
        objectName2 = ConfigServiceHelper.createObjectName(null, "Server", null);
        return this.configService.queryConfigObjects(null, objectName, objectName2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AdvisorChartData getAdvisorChartData(UserPreferences userPreferences, Locale locale) {
        String[] stringArray;
        Object[] objectArray;
        long l;
        String string;
        AdvisorData advisorData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdvisorChartData");
        }
        if ((advisorData = (AdvisorData)this.tpaChartData.get(string = userPreferences.getNodeName() + "#" + userPreferences.getServerName() + "#" + userPreferences.getUserId())) == null) {
            advisorData = new AdvisorData();
            this.tpaChartData.put(string, advisorData);
        }
        if ((l = (long)userPreferences.getRefreshRate()) <= 0L) {
            l = 30L;
        }
        long l2 = advisorData.timestamp + l * 500L;
        if (advisorData.data == null || l2 < System.currentTimeMillis()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refreshing data from tpv.engine");
            }
            objectArray = new Object[]{userPreferences, locale};
            stringArray = new String[]{"com.ibm.ws.tpv.engine.UserPreferences", "java.util.Locale"};
            try {
                advisorData.data = (AdvisorChartData)this.invoke("getAdvisorChartData", userPreferences.getNodeName(), objectArray, stringArray);
                advisorData.timestamp = System.currentTimeMillis();
                advisorData.timeout = advisorData.timestamp + l * 500L;
            }
            catch (ConnectorException connectorException) {
                connectorException.printStackTrace();
            }
            catch (JMException jMException) {
                jMException.printStackTrace();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning cached data");
        }
        objectArray = this.tpaChartData;
        synchronized (this.tpaChartData) {
            stringArray = this.tpaChartData.keySet().iterator();
            long l3 = System.currentTimeMillis();
            while (stringArray.hasNext()) {
                AdvisorData advisorData2 = (AdvisorData)this.tpaChartData.get(stringArray.next());
                if (advisorData2.timeout >= l3) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing from advisor data cache");
                }
                stringArray.remove();
            }
            // ** MonitorExit[var9_7] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdvisorChartData");
            }
            return advisorData.data;
        }
    }

    public void checkTpvMBean() {
        block9: {
            if (this.isDmgr && !this.mbeanStarted) {
                ObjectName objectName;
                block8: {
                    objectName = null;
                    try {
                        objectName = this.lookupTPVMBean(this.as.getProcessName());
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug(tc, "checkTpvMBean - didn't find TPV MBean in dmgr");
                    }
                }
                if (objectName != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkTpvMBean - found TPV MBean in dmgr");
                    }
                    this.mbeanStarted = true;
                    return;
                }
                try {
                    MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
                    mBeanFactory.activateMBean("TivoliPerfEngine", new TPVCollaborator(), "TPVEngineMBean", null);
                    mBeanFactory.activateMBean("TivoliPerfAdvisor", new AdvisorCollaborator(TPVServiceImpl.getRepository()), "TPVAdvisorMBean", null);
                    this.mbeanStarted = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkTpvMBean - started TPV MBean in dmgr");
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "checkTpvMBean - unable to start TPV MBean", exception);
                }
            }
        }
    }

    public ServerBean getServerFromLog(String string, String string2, String string3) throws ConnectorException, JMException {
        Object[] objectArray = new Object[]{string2, string3};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        ServerBean serverBean = (ServerBean)this.invoke("getServerFromLog", string, objectArray, stringArray);
        return serverBean;
    }

    class UserLogging {
        long stopTime;
        UserPreferences prefs;

        UserLogging(UserPreferences userPreferences, long l) {
            this.prefs = userPreferences;
            this.stopTime = l;
        }
    }

    class AdvisorData {
        AdvisorChartData data;
        long timestamp;
        long timeout;

        AdvisorData() {
        }
    }
}

