/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.buffer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.stat.StatsCreator;
import com.ibm.ws.tpv.dataclasses.GrowableObjectArray;
import com.ibm.ws.tpv.engine.buffer.BufferTable;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;

public class BufferMapper {
    private BufferMapperNode root;
    private BufferTable buffTable;
    private UidTracker uid;
    private GrowableObjectArray nodes;
    private HashSet modifiedUsers;
    private static TraceComponent tc = Tr.register(BufferMapper.class, "com.ibm.ws.tpv.buffer", null);

    public BufferMapper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>");
        }
        this.modifiedUsers = new HashSet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    private void init() {
        this.uid = new UidTracker();
        this.buffTable = new BufferTable();
        this.nodes = new GrowableObjectArray(50, 5);
    }

    public void init(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{string, new Integer(n)});
        }
        if (this.buffTable == null) {
            this.init();
        }
        this.buffTable.init(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public boolean dispose(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose");
        }
        if (this.buffTable.dispose(string)) {
            if (this.root != null) {
                this.root.remove();
            }
            this.root = null;
            this.uid = null;
            this.nodes = null;
            this.buffTable = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "dispose - all users disposed", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose - only this user disposed", new Boolean(false));
        }
        return false;
    }

    public synchronized void put(String string, WSStats wSStats) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put", wSStats.getName());
        }
        if (this.root == null) {
            this.root = new BufferMapperNode(this.uid.get(), null);
            this.nodes.put(this.root.getUID(), this.root);
        }
        this.put(string, this.root, wSStats);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put");
        }
    }

    private void put(String string, BufferMapperNode bufferMapperNode, WSStats wSStats) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put", wSStats.getName());
        }
        if (bl = this.buffTable.store(string, bufferMapperNode.getUID(), wSStats)) {
            this.modifiedUsers.add(string);
        }
        BufferMapperNode bufferMapperNode2 = null;
        WSStats[] wSStatsArray = wSStats.listSubStats();
        if (wSStatsArray != null && wSStatsArray.length > 0) {
            BufferMapperNodeSearchWrapper bufferMapperNodeSearchWrapper = new BufferMapperNodeSearchWrapper();
            bufferMapperNodeSearchWrapper.init(bufferMapperNode.children);
            for (int i = 0; i < wSStatsArray.length; ++i) {
                int n = bufferMapperNodeSearchWrapper.find(wSStatsArray[i].getName());
                if (n == -1) {
                    bufferMapperNode2 = new BufferMapperNode(this.uid.get(), bufferMapperNode);
                    bufferMapperNode.addChild(bufferMapperNode2);
                    this.nodes.put(bufferMapperNode2.getUID(), bufferMapperNode2);
                    this.modifiedUsers.add(string);
                } else {
                    bufferMapperNode2 = (BufferMapperNode)bufferMapperNode.children.get(n);
                }
                this.put(string, bufferMapperNode2, wSStatsArray[i]);
            }
            int[] nArray = bufferMapperNodeSearchWrapper.remainder();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= bufferMapperNode.children.size()) continue;
                    bufferMapperNode2 = (BufferMapperNode)bufferMapperNode.children.get(nArray[i]);
                    this.buffTable.setInactive(string, bufferMapperNode2.getUID());
                    if (!this.buffTable.isRemoveable(bufferMapperNode2.getUID())) continue;
                    bufferMapperNode.children.remove(nArray[i]);
                    bufferMapperNode2.remove();
                }
            }
            bufferMapperNodeSearchWrapper = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put", wSStats.getName());
        }
    }

    public boolean isModified(String string) {
        return this.modifiedUsers.remove(string);
    }

    public int getParentUID(int n) throws NotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentUID", new Integer(n));
        }
        int n2 = -1;
        BufferMapperNode bufferMapperNode = (BufferMapperNode)this.nodes.get(n);
        if (bufferMapperNode == null) {
            throw new NotFoundException("The UID specified was not found.", "UID = " + n);
        }
        if ((bufferMapperNode = bufferMapperNode.getParent()) == null) {
            throw new NotFoundException("The UID specified had no parent.", "UID = " + n);
        }
        n2 = bufferMapperNode.getUID();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentUID", new Integer(n2));
        }
        return n2;
    }

    public WSStats get(String string, int n, int[] nArray, boolean bl, int n2) {
        Object object;
        int n3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", new Object[]{string, new Integer(n), nArray, new Boolean(bl), new Integer(n2)});
        }
        String string2 = this.buffTable.getName(n);
        int n4 = this.buffTable.getType(n);
        int n5 = this.buffTable.getLevel(string, n);
        long l = this.buffTable.getTime(string, n, n2);
        String string3 = this.buffTable.getStatsType(n);
        ArrayList arrayList = this.buffTable.getStatistics(string, n, nArray, n2);
        ArrayList<WSStats> arrayList2 = null;
        if (bl && (n3 = ((BufferMapperNode)(object = (BufferMapperNode)this.nodes.get(n))).getNumChildren()) > 0) {
            arrayList2 = new ArrayList<WSStats>(n3);
            for (int i = 0; i < ((BufferMapperNode)object).getNumChildren(); ++i) {
                BufferMapperNode bufferMapperNode = (BufferMapperNode)((BufferMapperNode)object).children.get(i);
                if (n2 >= this.buffTable.getCount(string, bufferMapperNode.getUID())) continue;
                WSStats wSStats = this.get(string, bufferMapperNode.getUID(), null, true, n2);
                arrayList2.add(i, wSStats);
            }
        }
        object = StatsCreator.create(string3, string2, n4, n5, l, arrayList, arrayList2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", object.getName());
        }
        return object;
    }

    public WSStats[] getAll(String string, int n, int[] nArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", new Object[]{string, new Integer(n), nArray, new Boolean(bl)});
        }
        int n2 = this.buffTable.getCount(string, n);
        WSStats[] wSStatsArray = null;
        if (n2 > 0) {
            wSStatsArray = new WSStats[n2];
            for (int i = 0; i < n2; ++i) {
                wSStatsArray[i] = this.get(string, n, nArray, bl, i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll");
        }
        return wSStatsArray;
    }

    public void setSize(String string, int n) {
        this.buffTable.setSize(string, n);
    }

    public int getSize(String string) {
        return this.buffTable.getSize(string);
    }

    public BufferTable getBufferTable() {
        return this.buffTable;
    }

    private Stack getPath(int n) {
        BufferMapperNode bufferMapperNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPath", new Integer(n));
        }
        if ((bufferMapperNode = (BufferMapperNode)this.nodes.get(n)) == null) {
            return null;
        }
        Stack<String> stack = new Stack<String>();
        while (bufferMapperNode != null) {
            stack.push(bufferMapperNode.getName());
            bufferMapperNode = bufferMapperNode.getParent();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPath");
        }
        return stack;
    }

    public TreeNodeData getTreeStructure(String string) {
        if (this.root == null) {
            return new TreeNodeData(-2, "The tree is not yet available, please try again in 30 seconds.", "INVALID");
        }
        return this.root.toTreeNodeData(string);
    }

    public synchronized TreeNodeData[] getTreeArray(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTreeArray", string);
        }
        ArrayList<TreeNodeData> arrayList = new ArrayList<TreeNodeData>();
        for (int i = 0; i < this.nodes.getCapacity(); ++i) {
            BufferMapperNode bufferMapperNode;
            if (!this.nodes.isOccupied(i) || !this.buffTable.isActive(string, (bufferMapperNode = (BufferMapperNode)this.nodes.get(i)).getUID())) continue;
            arrayList.add(new TreeNodeData(bufferMapperNode.getUID(), bufferMapperNode.getName(), this.buffTable.getStatsType(bufferMapperNode.getUID())));
        }
        TreeNodeData[] treeNodeDataArray = new TreeNodeData[arrayList.size()];
        arrayList.toArray(treeNodeDataArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTreeArray");
        }
        return treeNodeDataArray;
    }

    public void dump(String string) {
        if (this.root != null) {
            this.root.dump(string, "");
        }
    }

    private class UidTracker {
        private int UIDCounter = 0;
        private Stack freeUIDs = new Stack();

        public int get() {
            if (this.freeUIDs.size() > 0) {
                return (Integer)this.freeUIDs.pop();
            }
            if (this.UIDCounter == Integer.MAX_VALUE) {
                return Integer.MIN_VALUE;
            }
            return this.UIDCounter++;
        }

        public void ret(int n) {
            this.freeUIDs.push(new Integer(n));
        }

        public boolean isError(int n) {
            return n == Integer.MIN_VALUE;
        }
    }

    public class BufferMapperNodeSearchWrapper {
        private LinkedList list = new LinkedList();
        private boolean inSearch = false;

        public boolean init(ArrayList arrayList) {
            if (this.inSearch) {
                return false;
            }
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    BufferMapperNode bufferMapperNode = (BufferMapperNode)arrayList.get(i);
                    this.list.add(new Object[]{bufferMapperNode.getName(), new Integer(i)});
                }
            }
            this.inSearch = true;
            return true;
        }

        public int find(String string) {
            int n = 0;
            ListIterator listIterator = this.list.listIterator();
            Integer n2 = null;
            while (listIterator.hasNext()) {
                ++n;
                Object[] objectArray = (Object[])listIterator.next();
                if (!string.equals((String)objectArray[0])) continue;
                listIterator.remove();
                n2 = (Integer)objectArray[1];
                break;
            }
            if (n2 == null) {
                return -1;
            }
            return n2;
        }

        public int[] remainder() {
            if (!this.inSearch) {
                return null;
            }
            int n = this.list.size();
            if (n == 0) {
                return null;
            }
            int[] nArray = new int[n];
            int n2 = 0;
            ListIterator listIterator = this.list.listIterator();
            while (listIterator.hasNext()) {
                Object[] objectArray = (Object[])listIterator.next();
                nArray[n2++] = (Integer)objectArray[1];
            }
            this.list.clear();
            this.inSearch = false;
            return nArray;
        }
    }

    private class BufferMapperNode {
        private int UID;
        protected ArrayList children;
        private BufferMapperNode parent;

        public BufferMapperNode(int n, BufferMapperNode bufferMapperNode) {
            this.UID = n;
            this.parent = bufferMapperNode;
        }

        public int getUID() {
            return this.UID;
        }

        public void addChild(BufferMapperNode bufferMapperNode) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(bufferMapperNode);
        }

        public void trim() {
            if (this.children == null) {
                return;
            }
            this.children.trimToSize();
            for (int i = 0; i < this.children.size(); ++i) {
                ((BufferMapperNode)this.children.get(i)).trim();
            }
        }

        public int getNumChildren() {
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        public BufferMapperNode getChild(String string) {
            if (this.children == null) {
                return null;
            }
            BufferMapperNode bufferMapperNode = null;
            for (int i = 0; i < this.children.size(); ++i) {
                bufferMapperNode = (BufferMapperNode)this.children.get(i);
                if (!bufferMapperNode.getName().equals(string)) continue;
                return bufferMapperNode;
            }
            return null;
        }

        public String getName() {
            return BufferMapper.this.buffTable.getName(this.UID);
        }

        public BufferMapperNode getParent() {
            return this.parent;
        }

        public int getUID(Stack stack) {
            if (stack.empty()) {
                return this.UID;
            }
            String string = (String)stack.pop();
            BufferMapperNode bufferMapperNode = this.getChild(string);
            if (bufferMapperNode == null) {
                return -1;
            }
            return bufferMapperNode.getUID(stack);
        }

        public TreeNodeData toTreeNodeData(String string) {
            TreeNodeData treeNodeData = new TreeNodeData(this.UID, this.getName(), BufferMapper.this.buffTable.getStatsType(this.UID));
            treeNodeData.setLevel(BufferMapper.this.buffTable.getNumStatistics(string, this.UID));
            int n = this.getNumChildren();
            if (n > 0) {
                ArrayList<TreeNodeData> arrayList = new ArrayList<TreeNodeData>();
                for (int i = 0; i < n; ++i) {
                    BufferMapperNode bufferMapperNode = (BufferMapperNode)this.children.get(i);
                    if (!BufferMapper.this.buffTable.isActive(string, bufferMapperNode.getUID())) continue;
                    arrayList.add(bufferMapperNode.toTreeNodeData(string));
                }
                treeNodeData.setChildren(arrayList);
            }
            return treeNodeData;
        }

        public void remove() {
            BufferMapper.this.nodes.remove(this.UID);
            BufferMapper.this.buffTable.remove(this.UID);
            BufferMapper.this.uid.ret(this.UID);
            Tr.debug(tc, "BufferMapper.removed(" + this.UID + ")");
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    BufferMapperNode bufferMapperNode = (BufferMapperNode)this.children.get(i);
                    bufferMapperNode.remove();
                }
                this.children.clear();
                this.children = null;
            }
        }

        public void dump(String string, String string2) {
            int n;
            Tr.debug(tc, string2 + " [ " + this.getName() + " | " + BufferMapper.this.buffTable.getType(this.UID) + " | " + BufferMapper.this.buffTable.getNumStatistics(string, this.UID) + " | " + BufferMapper.this.buffTable.getLevel(string, this.UID) + " ] " + BufferMapper.this.buffTable.getCount(string, this.UID) + " { ");
            for (n = 0; n < BufferMapper.this.buffTable.getCount(string, this.UID); ++n) {
                Tr.debug(tc, string2 + "\t------------------");
                ArrayList arrayList = BufferMapper.this.buffTable.getStatistics(string, this.UID, null, n);
                if (arrayList == null) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Tr.debug(tc, string2 + "\t" + arrayList.get(i).toString());
                }
            }
            if (this.children != null && this.children.size() > 0) {
                for (n = 0; n < this.children.size(); ++n) {
                    ((BufferMapperNode)this.children.get(n)).dump(string, string2 + "\t");
                }
            }
            Tr.debug(tc, string2 + "}");
        }
    }
}

