/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.buffer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.tpv.dataclasses.Buffer;
import com.ibm.ws.tpv.dataclasses.GrowableIntArray;
import com.ibm.ws.tpv.dataclasses.GrowableObjectArray;
import com.ibm.ws.tpv.dataclasses.GrowableStringArray;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;

public class BufferTable {
    private GrowableStringArray names;
    private GrowableStringArray statsType;
    private GrowableIntArray types;
    private HashMap users;
    private BitSet occupied;
    private static TraceComponent tc = Tr.register(BufferTable.class, "com.ibm.ws.tpv.buffer", null);

    public BufferTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>");
        }
        this.statsType = new GrowableStringArray();
        this.names = new GrowableStringArray();
        this.types = new GrowableIntArray();
        this.users = new HashMap();
        this.occupied = new BitSet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    public void init(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{string, new Integer(n)});
        }
        UserData userData = new UserData(n);
        this.users.put(string, userData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public boolean dispose(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose", string);
        }
        UserData userData = (UserData)this.users.remove(string);
        userData.active = null;
        userData.levels = null;
        userData.statistics = null;
        userData.timeStamp = null;
        if (this.users.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "dispose - all users disposed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose - only this user disposed");
        }
        return false;
    }

    public synchronized boolean store(String string, int n, WSStats wSStats) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "store", new Object[]{string, new Integer(n), wSStats.getName()});
        }
        UserData userData = (UserData)this.users.get(string);
        boolean bl = false;
        if (!this.occupied.get(n)) {
            this.occupied.set(n);
            this.statsType.put(n, wSStats.getStatsType());
            if (n == 0) {
                this.statsType.put(n, "pmi");
            }
            this.names.put(n, wSStats.getName());
            this.types.put(n, wSStats.getType());
            userData.active.set(n);
            userData.levels.put(n, wSStats.getLevel());
        } else if (!userData.active.get(n)) {
            userData.active.set(n);
            userData.levels.put(n, wSStats.getLevel());
            bl = true;
        } else if (wSStats.getLevel() != userData.levels.get(n)) {
            userData.levels.put(n, wSStats.getLevel());
            bl = true;
        } else if (wSStats.numStatistics() != ((Buffer)userData.statistics.get(0)).getCount()) {
            bl = true;
        }
        this.storeTimeStamp(string, n, wSStats.getTime());
        WSStatistic[] wSStatisticArray = wSStats.listStatistics();
        if (wSStatisticArray == null) {
            wSStatisticArray = new WSStatistic[]{};
        }
        this.storeStatistics(string, n, wSStatisticArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "store", new Boolean(bl));
        }
        return bl;
    }

    private void storeStatistics(String string, int n, WSStatistic[] wSStatisticArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeStatistics", new Object[]{string, new Integer(n), wSStatisticArray});
        }
        UserData userData = (UserData)this.users.get(string);
        Buffer buffer = (Buffer)userData.statistics.get(n);
        if (buffer == null) {
            buffer = new Buffer(userData.size);
            userData.statistics.put(n, buffer);
        }
        buffer.append(wSStatisticArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeStatistics");
        }
    }

    private void storeTimeStamp(String string, int n, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeTimeStamp", new Object[]{string, new Integer(n), new Long(l)});
        }
        UserData userData = (UserData)this.users.get(string);
        Buffer buffer = (Buffer)userData.timeStamp.get(n);
        if (buffer == null) {
            buffer = new Buffer(userData.size);
            userData.timeStamp.put(n, buffer);
        }
        buffer.append(new Long(l));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeTimeStamp");
        }
    }

    public boolean isRemoveable(int n) {
        Iterator iterator = this.users.keySet().iterator();
        while (iterator.hasNext()) {
            UserData userData = (UserData)this.users.get(iterator.next());
            if (!userData.active.get(n)) continue;
            return false;
        }
        return true;
    }

    public void remove(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", new Integer(n));
        }
        this.names.remove(n);
        this.types.remove(n);
        this.occupied.clear(n);
        Iterator iterator = this.users.keySet().iterator();
        while (iterator.hasNext()) {
            UserData userData = (UserData)this.users.get(iterator.next());
            userData.levels.remove(n);
            userData.statistics.remove(n);
            userData.timeStamp.remove(n);
            userData.active.clear(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
    }

    public void setSize(String string, int n) {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSize", new Object[]{string, new Integer(n)});
        }
        UserData userData = (UserData)this.users.get(string);
        userData.size = n;
        for (n2 = 0; n2 < userData.statistics.getCapacity(); ++n2) {
            if (!userData.statistics.isOccupied(n2)) continue;
            ((Buffer)userData.statistics.get(n2)).setSize(n);
        }
        for (n2 = 0; n2 < userData.timeStamp.getCapacity(); ++n2) {
            if (!userData.timeStamp.isOccupied(n2)) continue;
            ((Buffer)userData.timeStamp.get(n2)).setSize(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSize");
        }
    }

    public int getSize(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSize", string);
        }
        UserData userData = (UserData)this.users.get(string);
        int n = userData.size;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSize", new Integer(n));
        }
        return userData.size;
    }

    public boolean isActive(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isActive", new Object[]{string, new Integer(n)});
        }
        boolean bl = false;
        UserData userData = (UserData)this.users.get(string);
        if (userData != null) {
            bl = userData.active.get(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isActive", new Boolean(bl));
        }
        return bl;
    }

    public void setInactive(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInactive", new Object[]{string, new Integer(n)});
        }
        UserData userData = (UserData)this.users.get(string);
        userData.active.clear(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInactive");
        }
    }

    public String getStatsType(int n) {
        return this.statsType.get(n);
    }

    public String getName(int n) {
        return this.names.get(n);
    }

    public int getLevel(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLevel", new Object[]{string, new Integer(n)});
        }
        UserData userData = (UserData)this.users.get(string);
        int n2 = userData.levels.get(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLevel", new Integer(n2));
        }
        return n2;
    }

    public int getNumStatistics(String string, int n) {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLevel", new Object[]{string, new Integer(n)});
        }
        UserData userData = (UserData)this.users.get(string);
        Buffer buffer = (Buffer)userData.statistics.get(n);
        WSStatistic[] wSStatisticArray = (WSStatistic[])buffer.get(0);
        int n3 = n2 = wSStatisticArray == null ? 0 : wSStatisticArray.length;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLevel", new Integer(n2));
        }
        return n2;
    }

    public int getType(int n) {
        return this.types.get(n);
    }

    public long getTime(String string, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeStamp", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        long l = -1L;
        UserData userData = (UserData)this.users.get(string);
        Buffer buffer = (Buffer)userData.timeStamp.get(n);
        if (buffer != null) {
            l = (Long)buffer.get(n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeStamp", new Long(l));
        }
        return l;
    }

    public int getCount(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCount", new Object[]{string, new Integer(n)});
        }
        int n2 = -1;
        UserData userData = (UserData)this.users.get(string);
        Buffer buffer = (Buffer)userData.statistics.get(n);
        if (buffer != null) {
            n2 = buffer.getCount();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCount", new Integer(n2));
        }
        return n2;
    }

    public ArrayList getStatistics(String string, int n, int[] nArray, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatistics", new Object[]{string, new Integer(n), nArray, new Integer(n2)});
        }
        UserData userData = (UserData)this.users.get(string);
        Buffer buffer = (Buffer)userData.statistics.get(n);
        if (buffer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatistics - no statistics found");
            }
            return null;
        }
        WSStatistic[] wSStatisticArray = (WSStatistic[])buffer.get(n2);
        if (wSStatisticArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatistics - no statistics found");
            }
            return null;
        }
        if (nArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatistics - all statistics requested");
            }
            ArrayList<WSStatistic> arrayList = new ArrayList<WSStatistic>(wSStatisticArray.length);
            for (int i = 0; i < wSStatisticArray.length; ++i) {
                arrayList.add(wSStatisticArray[i]);
            }
            return arrayList.size() == 0 ? null : arrayList;
        }
        ArrayList<WSStatistic> arrayList = new ArrayList<WSStatistic>();
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < wSStatisticArray.length && !bl; ++j) {
                if (wSStatisticArray[j].getId() != nArray[i]) continue;
                arrayList.add(wSStatisticArray[j]);
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatistics - specific statistics requested");
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    private class UserData {
        protected int size;
        protected BitSet active;
        protected GrowableIntArray levels;
        protected GrowableObjectArray timeStamp;
        protected GrowableObjectArray statistics;

        protected UserData(int n) {
            this.size = n;
            this.active = new BitSet();
            this.levels = new GrowableIntArray();
            this.timeStamp = new GrowableObjectArray();
            this.statistics = new GrowableObjectArray();
        }
    }
}

