/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.buffer;

import java.util.HashMap;
import java.util.Iterator;

public class BufferUpdateManager {
    private HashMap users = new HashMap();

    public void register(Long l) {
        this.users.put(l, new ServerList());
    }

    public void unregister(Long l) {
        this.users.remove(l);
    }

    public synchronized void serverUpdated(String string) {
        Iterator iterator = this.users.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ServerList serverList = (ServerList)this.users.get(k);
            serverList.addServer(string);
        }
    }

    public String[] listUpdatedServers(Long l) {
        ServerList serverList = (ServerList)this.users.get(l);
        return serverList.updatedServers();
    }

    public boolean isServerUpdated(Long l, String string) {
        ServerList serverList = (ServerList)this.users.get(l);
        return serverList.isServerUpdated(string);
    }

    private class ServerList {
        private ServerNode root = null;

        public void addServer(String string) {
            if (this.root == null) {
                this.root = new ServerNode(string);
            } else {
                this.root.addServer(string);
            }
        }

        public boolean isServerUpdated(String string) {
            if (this.root == null) {
                return false;
            }
            if (this.root.name.equals(string)) {
                this.root = this.root.next;
                return true;
            }
            ServerNode serverNode = this.root;
            ServerNode serverNode2 = this.root.next;
            while (serverNode2 != null) {
                if (serverNode2.name.equals(string)) {
                    serverNode.next = serverNode2.next;
                    return true;
                }
                serverNode = serverNode2;
                serverNode2 = serverNode2.next;
            }
            return false;
        }

        public String[] updatedServers() {
            if (this.root == null) {
                return null;
            }
            String[] stringArray = this.root.toArray(0);
            this.root = null;
            return stringArray;
        }

        private class ServerNode {
            public String name;
            public ServerNode next;

            public ServerNode(String string) {
                this.name = string;
                this.next = null;
            }

            public void addServer(String string) {
                if (this.name.equals(string)) {
                    return;
                }
                if (this.next == null) {
                    this.next = new ServerNode(string);
                }
                this.next.addServer(string);
            }

            public String[] toArray(int n) {
                String[] stringArray = this.next == null ? new String[n] : this.next.toArray(++n);
                stringArray[n - 1] = this.name;
                this.next = null;
                return stringArray;
            }
        }
    }
}

