/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.buffer;

import java.io.Serializable;

public class StatRequest
implements Serializable {
    private static final long serialVersionUID = 4438150060822255453L;
    private static final byte NOFLAGS = 0;
    private static final byte ALL = 1;
    private static final byte REALTIME = 2;
    private static final byte LOG = 4;
    private static final byte LNKSYSDATA = 8;
    private static final byte RECURSIVE = 16;
    protected String node;
    protected String server;
    protected String logName;
    protected int uid;
    protected byte type_mode;
    protected byte view;
    protected byte logPlayMode;
    protected int[] dataIds;
    protected byte flags = 0;
    protected String userID;

    public StatRequest(String string, String string2, int n, boolean bl, boolean bl2) {
        this(string, string2, n, bl, bl2, null);
    }

    public StatRequest(String string, String string2, int n, boolean bl, boolean bl2, int[] nArray) {
        this(string, string2, n, bl, bl2, nArray, null);
    }

    public StatRequest(String string, String string2, int n, boolean bl, boolean bl2, int[] nArray, String string3) {
        this.setNode(string);
        this.setServer(string2);
        this.setUID(n);
        this.setAll(bl2);
        this.setRecursive(bl);
        this.setDataIds(nArray);
        this.setLinkSystemData(false);
        this.setUserID(string3);
        this.setView((byte)0);
    }

    public void setNode(String string) {
        this.node = string;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setUID(int n) {
        this.uid = n;
    }

    public void setType(byte by) {
        this.type_mode = (byte)(this.type_mode & 0xF);
        this.type_mode = (byte)(this.type_mode | by);
    }

    public void setMode(byte by) {
        this.type_mode = (byte)(this.type_mode & 0xFFFFFFF0);
        this.type_mode = (byte)(this.type_mode | by);
    }

    public void setView(byte by) {
        this.view = by;
    }

    public void setLogPlayMode(byte by) {
        this.logPlayMode = by;
    }

    public void setRealtime(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public void setAll(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public void setLog(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public void setLinkSystemData(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    public void setRecursive(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    public void setDataIds(int[] nArray) {
        if (nArray == null) {
            this.dataIds = null;
        } else {
            this.dataIds = new int[nArray.length];
            System.arraycopy(nArray, 0, this.dataIds, 0, this.dataIds.length);
        }
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public String getNode() {
        return this.node;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getServer() {
        return this.server;
    }

    public int getUID() {
        return this.uid;
    }

    public byte getType() {
        return (byte)(this.type_mode & 0xFFFFFFF0);
    }

    public byte getMode() {
        return (byte)(this.type_mode & 0xF);
    }

    public byte getView() {
        return this.view;
    }

    public byte getLogPlayMode() {
        return this.logPlayMode;
    }

    public boolean getRealtime() {
        return (2 & this.flags) == 2;
    }

    public boolean getAll() {
        return (1 & this.flags) == 1;
    }

    public boolean getLog() {
        return (4 & this.flags) == 4;
    }

    public boolean getLinkSystemData() {
        return (8 & this.flags) == 8;
    }

    public boolean getRecursive() {
        return (0x10 & this.flags) == 16;
    }

    public int[] getDataIds() {
        return this.dataIds;
    }

    public String getLogName() {
        return this.logName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StatRequest: node=").append(this.node).append(" server=").append(this.server).append(" uid=").append(this.uid).append(" all=").append(this.getAll()).append(" log=").append(this.getLog()).append(" logName=").append(this.logName).append(" recursive=").append(this.getRecursive()).append(" realtime=").append(this.getRealtime()).append(" dataIds={");
        if (this.dataIds != null) {
            for (int i = 0; i < this.dataIds.length; ++i) {
                stringBuffer.append(this.dataIds[i]).append(", ");
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

