/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.buffer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.buffer.UserStatsBuffer;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import java.util.Stack;

public class StatsMapper {
    private UserPreferences up;
    private UserStatsBuffer buff;
    private WSStats serverStats;
    private static TraceComponent tc = Tr.register(StatsMapper.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public StatsMapper(UserPreferences userPreferences, UserStatsBuffer userStatsBuffer, WSStats wSStats) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", userPreferences);
        }
        this.up = userPreferences;
        this.buff = userStatsBuffer;
        this.serverStats = wSStats;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSStats getStats(int n) throws NotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStats", new Integer(n));
        }
        Stack<Integer> stack = new Stack<Integer>();
        int n2 = n;
        while (n2 != 0) {
            stack.push(new Integer(n2));
            n2 = this.buff.getParentUID(this.up, n2);
        }
        WSStats wSStats = this.serverStats;
        TreeNodeData treeNodeData = this.buff.getTreeStructure(this.up);
        while (stack.size() > 0) {
            n2 = (Integer)stack.pop();
            if ((wSStats = wSStats.getStats((treeNodeData = this.getChild(treeNodeData, n2)).getStatsName())) != null) continue;
            throw new NotFoundException("The Stats for name " + treeNodeData.getStatsName() + " was not found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStats", wSStats.getName());
        }
        return wSStats;
    }

    private TreeNodeData getChild(TreeNodeData treeNodeData, int n) {
        for (int i = 0; i < treeNodeData.getNumChildren(); ++i) {
            TreeNodeData treeNodeData2 = treeNodeData.getChild(i);
            if (treeNodeData2.getUID() != n) continue;
            return treeNodeData2;
        }
        return null;
    }
}

