/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.buffer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.stat.StatsCreator;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.BufferMapper;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.StatResult;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.buffer.UserStatsBuffer;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.exceptions.ServerNotFoundException;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import com.ibm.wsspi.pmi.stat.SPIStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UserStatsBufferImpl
implements UserStatsBuffer {
    private static TraceComponent tc = Tr.register(UserStatsBufferImpl.class, "com.ibm.ws.tpv.buffer", null);
    private HashMap servers;
    private int cachedNAgentSysDataUID = -1;

    public UserStatsBufferImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.servers = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void init(UserPreferences userPreferences) {
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", userPreferences);
        }
        ServerBean serverBean = UserStatsBufferImpl.getServerBean(userPreferences);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init - using ServerBean:", serverBean);
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean)) == null) {
            bufferMapper = new BufferMapper();
            this.servers.put(serverBean, bufferMapper);
        }
        bufferMapper.init(userPreferences.getUserId(), userPreferences.getBufferSize());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void setBufferSize(UserPreferences userPreferences) {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBufferSize", userPreferences);
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setBufferSize - node/server not being monitored");
            }
            return;
        }
        bufferMapper.setSize(userPreferences.getUserId(), userPreferences.getBufferSize());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBufferSize");
        }
    }

    public void dispose(UserPreferences userPreferences) {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose", userPreferences);
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "dispose - node/server not being monitored");
            }
            return;
        }
        if (bufferMapper.dispose(userPreferences.getUserId())) {
            bufferMapper = null;
            this.servers.remove(serverBean);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose");
        }
    }

    public void putServerStats(UserPreferences userPreferences, WSStats wSStats) throws NotFoundException {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putServerStats", wSStats.getName());
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "putServerStats, calling init(up) for server " + serverBean.toString());
            }
            this.init(userPreferences);
            bufferMapper = (BufferMapper)this.servers.get(serverBean);
            if (bufferMapper == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "putServerStats, throw ServerNotFoundException " + serverBean.toString());
                }
                throw new ServerNotFoundException("The following servers was not found: ", serverBean.toString());
            }
        }
        bufferMapper.put(userPreferences.getUserId(), wSStats);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putServerStats");
        }
    }

    public int getParentUID(UserPreferences userPreferences, int n) throws NotFoundException {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentUID", new Object[]{userPreferences, new Integer(n)});
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            throw new ServerNotFoundException("The following servers was not found: ", serverBean.toString());
        }
        int n2 = bufferMapper.getParentUID(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentUID", new Integer(n2));
        }
        return n2;
    }

    public StatResult get(StatRequest statRequest) throws NotFoundException {
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", statRequest);
        }
        if (statRequest == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get - null StatRequest passed in");
            }
            return null;
        }
        ServerBean serverBean = UserStatsBufferImpl.getServerBean(statRequest);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get - using ServerBean:", serverBean);
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean)) == null) {
            throw new ServerNotFoundException("The following servers was not found: " + serverBean.toString());
        }
        int n = statRequest.getUID();
        StatResult statResult = new StatResult();
        WSStats[] wSStatsArray = null;
        if (statRequest.getAll()) {
            wSStatsArray = bufferMapper.getAll(statRequest.getUserID(), n, statRequest.getDataIds(), statRequest.getRecursive());
        } else {
            WSStats wSStats = bufferMapper.get(statRequest.getUserID(), n, statRequest.getDataIds(), statRequest.getRecursive(), 0);
            wSStatsArray = new WSStats[]{wSStats};
        }
        if (statRequest.getLinkSystemData()) {
            this.linkSystemData(statRequest.getUserID(), statRequest.getNode(), wSStatsArray, statRequest.getAll());
        }
        statResult.setStats(wSStatsArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", statResult);
        }
        return statResult;
    }

    private void linkSystemData(String string, String string2, WSStats[] wSStatsArray, boolean bl) {
        ServerBean serverBean = new ServerBean(string2, "nodeagent");
        BufferMapper bufferMapper = (BufferMapper)this.servers.get(serverBean);
        if (bufferMapper == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not logging the nodeAgent, SystemData cannot be linked");
            }
            return;
        }
        if (this.cachedNAgentSysDataUID == -1) {
            this.cachedNAgentSysDataUID = this.findNodeAgentSystemDataUID(string, bufferMapper);
        }
        if (this.cachedNAgentSysDataUID == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to find the SystemData module for the nodeAgent");
            }
            return;
        }
        WSStats[] wSStatsArray2 = bl ? bufferMapper.getAll(string, this.cachedNAgentSysDataUID, null, true) : new WSStats[]{bufferMapper.get(string, this.cachedNAgentSysDataUID, null, true, 0)};
        for (int i = 0; i < wSStatsArray.length; ++i) {
            StatsCreator.addSubStatsToParent((SPIStats)wSStatsArray[i], (SPIStats)wSStatsArray2[i]);
        }
    }

    private int findNodeAgentSystemDataUID(String string, BufferMapper bufferMapper) {
        TreeNodeData treeNodeData = bufferMapper.getTreeStructure(string);
        int n = -1;
        for (int i = 0; i < treeNodeData.getNumChildren(); ++i) {
            TreeNodeData treeNodeData2 = treeNodeData.getChild(i);
            if (!treeNodeData2.getStatsName().equals("systemModule")) continue;
            n = treeNodeData2.getUID();
        }
        return n;
    }

    public StatResult[] get(StatRequest[] statRequestArray) throws NotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get");
        }
        StatResult[] statResultArray = new StatResult[statRequestArray.length];
        for (int i = 0; i < statRequestArray.length; ++i) {
            statResultArray[i] = this.get(statRequestArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get");
        }
        return statResultArray;
    }

    public int count(UserPreferences userPreferences, int n) throws NotFoundException {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "count", new Object[]{userPreferences, new Integer(n)});
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            throw new ServerNotFoundException("The following servers was not found: ", serverBean.toString());
        }
        int n2 = bufferMapper.getBufferTable().getCount(userPreferences.getUserId(), n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "count", new Integer(n2));
        }
        return n2;
    }

    public int getBufferSize(UserPreferences userPreferences) throws NotFoundException {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBufferSize", userPreferences);
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            throw new ServerNotFoundException("The following servers was not found: ", serverBean.toString());
        }
        int n = bufferMapper.getBufferTable().getSize(userPreferences.getUserId());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBufferSize", new Integer(n));
        }
        return n;
    }

    public ServerBean[] getServers(UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServers", userPreferences);
        }
        ArrayList<ServerBean> arrayList = new ArrayList<ServerBean>();
        String string = userPreferences.getNodeName();
        Iterator iterator = this.servers.keySet().iterator();
        while (iterator.hasNext()) {
            BufferMapper bufferMapper;
            ServerBean serverBean = (ServerBean)iterator.next();
            if (string != null && !string.equals(serverBean.getNode()) || !(bufferMapper = (BufferMapper)this.servers.get(serverBean)).getBufferTable().isActive(userPreferences.getUserId(), 0)) continue;
            arrayList.add(serverBean);
        }
        ServerBean[] serverBeanArray = new ServerBean[arrayList.size()];
        arrayList.toArray(serverBeanArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServers");
        }
        return serverBeanArray;
    }

    public TreeNodeData getTreeStructure(UserPreferences userPreferences) throws NotFoundException {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTreeStructure", userPreferences);
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            throw new ServerNotFoundException("The following server was not found: ", serverBean.toString());
        }
        TreeNodeData treeNodeData = bufferMapper.getTreeStructure(userPreferences.getUserId());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTreeStructure");
        }
        return treeNodeData;
    }

    public TreeNodeData[] getTreeArray(UserPreferences userPreferences) throws NotFoundException {
        ServerBean serverBean;
        BufferMapper bufferMapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTreeArray", userPreferences);
        }
        if ((bufferMapper = (BufferMapper)this.servers.get(serverBean = UserStatsBufferImpl.getServerBean(userPreferences))) == null) {
            throw new ServerNotFoundException("The following server was not found: ", serverBean.toString());
        }
        TreeNodeData[] treeNodeDataArray = bufferMapper.getTreeArray(userPreferences.getUserId());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTreeArray");
        }
        return treeNodeDataArray;
    }

    public boolean isServerUpdated(String string, ServerBean serverBean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerUpdated", new Object[]{string, serverBean});
        }
        boolean bl = false;
        BufferMapper bufferMapper = (BufferMapper)this.servers.get(serverBean);
        if (bufferMapper != null) {
            bl = bufferMapper.isModified(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerUpdated", new Boolean(bl));
        }
        return bl;
    }

    public ServerBean[] listUpdatedServers(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listUpdatedServers", string);
        }
        ArrayList<ServerBean> arrayList = new ArrayList<ServerBean>();
        Iterator iterator = this.servers.keySet().iterator();
        while (iterator.hasNext()) {
            ServerBean serverBean = (ServerBean)iterator.next();
            BufferMapper bufferMapper = (BufferMapper)this.servers.get(serverBean);
            if (!bufferMapper.isModified(string)) continue;
            arrayList.add(serverBean);
        }
        ServerBean[] serverBeanArray = new ServerBean[arrayList.size()];
        arrayList.toArray(serverBeanArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listUpdatedServers");
        }
        return serverBeanArray;
    }

    private static ServerBean getServerBean(UserPreferences userPreferences) {
        ServerBean serverBean = userPreferences.getViewLog() ? new ServerBean(userPreferences.getUserId(), userPreferences.getLogFileName()) : new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName());
        return serverBean;
    }

    private static ServerBean getServerBean(StatRequest statRequest) {
        ServerBean serverBean = statRequest.getLog() ? new ServerBean(statRequest.getUserID(), statRequest.getLogName()) : new ServerBean(statRequest.getNode(), statRequest.getServer());
        return serverBean;
    }
}

