/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.collector;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.tpv.engine.exceptions.ServerNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class PerfInvokerBase {
    private HashMap nodes = new HashMap(5);
    private AdminService adminService;
    private AdminClient adminClient;
    private static final TraceComponent tc = Tr.register(PerfInvokerBase.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public boolean init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.adminService = AdminServiceFactory.getAdminService();
        String string = this.adminService.getProcessType();
        if (string.equals("NodeAgent")) {
            try {
                this.adminClient = this.adminService.getDeploymentManagerAdminClient();
            }
            catch (AdminException adminException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "init - caught AdminException while getting Deployment Manager AdminClient", adminException);
                }
                adminException.printStackTrace();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "init - running in nodeagent, unable to get Deployment Manager AdminClient");
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init - running in a nodeagent");
            }
        } else if (string.equals("UnManagedProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init - running in a standalone server");
            }
        } else if (string.equals("DeploymentManager")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init - running in the deployment manager detected");
            }
        } else {
            if (string.equals("ManagedProcess")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "init - managed server detected, not supported");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "init - server type not detected, not supported");
            }
            return false;
        }
        this.refreshServerInfo();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
        return true;
    }

    public String getType() {
        return this.adminService.getProcessType();
    }

    public String[] listNodes() {
        String[] stringArray = new String[this.nodes.size()];
        int n = 0;
        Iterator iterator = this.nodes.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public String[] listServers(String string) {
        HashMap hashMap = (HashMap)this.nodes.get(string);
        if (hashMap == null) {
            return new String[0];
        }
        String[] stringArray = new String[hashMap.size()];
        int n = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public boolean isPmiEnabled(String string, String string2) {
        HashMap hashMap = (HashMap)this.nodes.get(string);
        if (hashMap == null) {
            return false;
        }
        return hashMap.containsKey(string2);
    }

    public synchronized void refreshServerInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshServerInfo");
        }
        this.nodes.clear();
        ObjectName[] objectNameArray = this.queryMBean("Perf", null);
        if (objectNameArray != null) {
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string = objectNameArray[i].getKeyProperty("process");
                String string2 = objectNameArray[i].getKeyProperty("node");
                HashMap<String, ObjectName> hashMap = (HashMap<String, ObjectName>)this.nodes.get(string2);
                if (hashMap == null) {
                    hashMap = new HashMap<String, ObjectName>(5);
                    this.nodes.put(string2, hashMap);
                }
                hashMap.put(string, objectNameArray[i]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "refreshServerInfo: put server=" + string + ", perfs[i]=" + objectNameArray[i].toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "refreshServerInfo - no ObjectNames returned from queryMBean call");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshServerInfo");
        }
    }

    protected Object invoke(String string, String string2, String string3, Object[] objectArray, String[] stringArray) throws ServerNotFoundException {
        return this.invoke(string, string2, string3, objectArray, stringArray, true);
    }

    private Object invoke(String string, String string2, String string3, Object[] objectArray, String[] stringArray, boolean bl) throws ServerNotFoundException {
        Object object;
        block21: {
            HashMap hashMap;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invoke", new Object[]{string, string2, string3});
            }
            if ((hashMap = (HashMap)this.nodes.get(string)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "invoke: did not find node " + string);
                }
                throw new ServerNotFoundException("Did not find node " + string);
            }
            ObjectName objectName = (ObjectName)hashMap.get(string2);
            if (objectName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "invoke: did not find server " + string2);
                }
                throw new ServerNotFoundException("Did not find server " + string2);
            }
            object = null;
            boolean bl2 = false;
            try {
                if (this.adminClient != null) {
                    object = this.adminClient.invoke(objectName, string3, objectArray, stringArray);
                } else if (this.adminService != null) {
                    object = this.adminService.invoke(objectName, string3, objectArray, stringArray);
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke - caught InstanceNotFoundException", instanceNotFoundException);
                }
                instanceNotFoundException.printStackTrace();
                bl2 = true;
            }
            catch (MBeanException mBeanException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke - caught MBeanException", mBeanException);
                }
                mBeanException.printStackTrace();
                bl2 = true;
            }
            catch (ReflectionException reflectionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke - caught ReflectionException", reflectionException);
                }
                reflectionException.printStackTrace();
            }
            catch (ConnectorException connectorException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke - caught ConnectorException", connectorException);
                }
                connectorException.printStackTrace();
                bl2 = true;
            }
            if (bl && bl2) {
                this.refreshServerInfo();
                try {
                    object = this.invoke(string, string2, string3, objectArray, stringArray, false);
                }
                catch (ServerNotFoundException serverNotFoundException) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "invoke - caught ServerNotFoundException while retrying invoke");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return object;
    }

    private ObjectName[] queryMBean(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBean", new String[]{string, string2});
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append("type=");
            stringBuffer.append(string);
        }
        if (string2 != null) {
            stringBuffer.append(stringBuffer.length() > 0 ? "," : "");
            stringBuffer.append("name=");
            stringBuffer.append(string2);
        }
        stringBuffer.append(stringBuffer.length() > 0 ? "," : "");
        stringBuffer.append("*");
        Set set = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:" + stringBuffer.toString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "queryMBean - caught MalformedObjectNameException", malformedObjectNameException);
            }
            malformedObjectNameException.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "queryMBean - caught MalformedObjectNameException, returning null");
            }
            return null;
        }
        try {
            if (this.adminClient != null) {
                set = this.adminClient.queryNames(objectName, null);
            } else if (this.adminService != null) {
                set = this.adminService.queryNames(objectName, null);
            }
        }
        catch (ConnectorException connectorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "queryMBean - caught ConnectorException", connectorException);
            }
            connectorException.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "queryMBean - caught ConnectorException, returning null");
            }
            return null;
        }
        Object[] objectArray = set.toArray();
        ObjectName[] objectNameArray = new ObjectName[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectNameArray[i] = (ObjectName)objectArray[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBean");
        }
        return objectNameArray;
    }
}

