/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSBoundedRangeStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.pmi.stat.StatsCreator;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.tpv.engine.TPVConstants;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.StatResult;
import com.ibm.ws.tpv.engine.buffer.StatsMapper;
import com.ibm.ws.tpv.engine.buffer.TreeNodeData;
import com.ibm.ws.tpv.engine.buffer.UserStatsBuffer;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.exceptions.UserNotRegisteredException;
import com.ibm.ws.tpv.engine.filter.Settings;
import com.ibm.ws.tpv.engine.filter.summary.ConnectionPoolSummary;
import com.ibm.ws.tpv.engine.filter.summary.EJBSummary;
import com.ibm.ws.tpv.engine.filter.summary.EJBSummaryObj;
import com.ibm.ws.tpv.engine.filter.summary.ServletSummary;
import com.ibm.ws.tpv.engine.filter.summary.ServletSummaryObj;
import com.ibm.ws.tpv.engine.filter.summary.Summary;
import com.ibm.ws.tpv.engine.filter.summary.ThreadPoolSummary;
import com.ibm.ws.tpv.engine.parser.ParsingController;
import com.ibm.ws.tpv.engine.parser.StatsLogParser;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import com.ibm.wsspi.pmi.stat.SPIStats;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TPVFilter
implements TPVConstants {
    private static TPVEngine engine = null;
    private HashMap uidMap;
    private static final TraceComponent tc = Tr.register(TPVFilter.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public TPVFilter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        engine = TPVEngine.getEngine();
        this.uidMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void register(UserPreferences userPreferences) throws FileNotFoundException, IOException, Exception {
        block17: {
            Object object;
            String string;
            Settings settings;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "register", userPreferences);
            }
            if ((settings = (Settings)this.uidMap.get(string = userPreferences.getViewLog() ? TPVFilter.generateKey(userPreferences.getUserId(), userPreferences.getLogFileName()) : TPVFilter.generateKey(userPreferences.getUserId(), userPreferences.getNodeName(), userPreferences.getServerName()))) == null) {
                settings = new Settings(userPreferences);
                this.uidMap.put(string, settings);
            } else {
                object = settings.getUserPreferences();
                if (((UserPreferences)object).equals(userPreferences)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "register - already registered with same UserPreferences, returning");
                    }
                    return;
                }
            }
            if (userPreferences.getViewLog()) {
                object = null;
                try {
                    object = ParsingController.parse(userPreferences.getLogFileName());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.exit(tc, "register - caught Exception while creating parser for log file " + userPreferences.getLogFileName(), exception);
                    }
                    this.cleanup(userPreferences);
                    throw exception;
                }
                settings.setParser((StatsLogParser)object);
                UserStatsBuffer userStatsBuffer = engine.getBuffer();
                userStatsBuffer.init(userPreferences);
                try {
                    WSStats wSStats = object.next();
                    if (wSStats != null) {
                        userStatsBuffer.putServerStats(userPreferences, wSStats);
                    }
                }
                catch (NotFoundException notFoundException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "register - caught NotFoundException while loading log into buffer", notFoundException);
                    }
                    notFoundException.printStackTrace();
                }
                catch (Exception exception) {
                    if (exception instanceof FileNotFoundException) {
                        if (tc.isDebugEnabled()) {
                            Tr.exit(tc, "register - caught FileNotFoundException, rethrowing", exception);
                        }
                        this.cleanup(userPreferences);
                        throw (FileNotFoundException)exception;
                    }
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "register - caught Exception while loading log into buffer, message is: " + exception.getMessage(), exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register");
        }
    }

    public ServerBean getServerFromLog(String string, String string2) {
        String string3;
        Settings settings;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerFromLog", new Object[]{string, string2});
        }
        if ((settings = (Settings)this.uidMap.get(string3 = TPVFilter.generateKey(string, string2))) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerFromLog - Could not find settings, returning null");
            }
            return null;
        }
        StatsLogParser statsLogParser = settings.getParser();
        if (statsLogParser == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerFromLog - Could not find parser, returning null");
            }
            return null;
        }
        ServerBean serverBean = new ServerBean(statsLogParser.getNodeName(), statsLogParser.getServerName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerFromLog", serverBean);
        }
        return serverBean;
    }

    public void cleanup(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cleanup - not yet implemented!", string);
        }
        Iterator iterator = this.uidMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!TPVFilter.getUserId(string2).equals(string)) continue;
            Settings settings = (Settings)this.uidMap.get(string2);
            this.cleanup(settings);
        }
    }

    private static String getUserId(String string) {
        int n = string.indexOf("#");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public void cleanup(UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup - UserPreferences", userPreferences);
        }
        if (userPreferences != null) {
            StatsLogParser statsLogParser;
            String string = userPreferences.getViewLog() ? TPVFilter.generateKey(userPreferences.getUserId(), userPreferences.getLogFileName()) : TPVFilter.generateKey(userPreferences.getUserId(), userPreferences.getNodeName(), userPreferences.getServerName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleanup - dispose buffer");
            }
            engine.getBuffer().dispose(userPreferences);
            Settings settings = (Settings)this.uidMap.remove(string);
            if (settings != null && userPreferences.getViewLog() && (statsLogParser = settings.getParser()) != null) {
                statsLogParser.dispose();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup - UserPreferences");
        }
    }

    private void cleanup(Settings settings) {
        UserPreferences userPreferences;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup - UserSettings");
        }
        if (settings != null && (userPreferences = settings.getUserPreferences()) != null && userPreferences.getViewLog()) {
            engine.getBuffer().dispose(userPreferences);
            settings.getParser().dispose();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup - UserSettings");
        }
    }

    public StatResult[] get(StatRequest[] statRequestArray) throws UserNotRegisteredException, NotFoundException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", statRequestArray);
        }
        if (statRequestArray == null || statRequestArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get - null or empty StatRequest[] passed in, returning null");
            }
            return null;
        }
        StatResult[] statResultArray = new StatResult[statRequestArray.length];
        for (int i = 0; i < statRequestArray.length; ++i) {
            statResultArray[i] = this.get(statRequestArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get - returning StatResult[]");
        }
        return statResultArray;
    }

    public StatResult get(StatRequest statRequest) throws UserNotRegisteredException, NotFoundException, Exception {
        WSStats wSStats;
        StatResult statResult;
        WSStats[] wSStatsArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", statRequest);
        }
        if (statRequest == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get - null StatRequest passed in, returning null");
            }
            return null;
        }
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        String string = null;
        StatResult statResult2 = new StatResult();
        string = statRequest.getLog() ? TPVFilter.generateKey(statRequest.getUserID(), statRequest.getLogName()) : TPVFilter.generateKey(statRequest.getUserID(), statRequest.getNode(), statRequest.getServer());
        Settings settings = (Settings)this.uidMap.get(string);
        if (settings == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get - Settings obj not found, throwing UserNotRegisteredException");
            }
            throw new UserNotRegisteredException(statRequest.getUserID(), statRequest);
        }
        UserPreferences userPreferences = settings.getUserPreferences();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get - using UserPreferences: " + userPreferences);
        }
        byte by = statRequest.getView();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get - view set to: " + by);
        }
        if (statRequest.getLog() && this.advanceLogfileBuffer(statRequest, settings)) {
            statResult2.setEndOfFile(true);
        }
        if ((wSStatsArray = (statResult = userStatsBuffer.get(statRequest)).getStatsArray()) == null || wSStatsArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get - no Stats found, returning empty StatResult");
            }
            return statResult;
        }
        if (by == 2) {
            if (wSStatsArray != null && wSStatsArray.length != 0) {
                settings.setClearTime(wSStatsArray[0].getTime());
            }
        } else if (by == 1) {
            if (settings.isReset()) {
                settings.setReset(false);
                settings.setResetStatsMap(null);
            } else {
                wSStats = TPVFilter.getResetStats(statRequest);
                if (wSStats != null) {
                    settings.setReset(true);
                    StatsMapper statsMapper = new StatsMapper(userPreferences, userStatsBuffer, wSStats);
                    settings.setResetStatsMap(statsMapper);
                }
            }
        }
        if (settings.getClearTime() > 0L) {
            wSStatsArray = TPVFilter.doClear(wSStatsArray, settings.getClearTime());
        }
        if (settings.isReset()) {
            block27: {
                wSStats = null;
                try {
                    wSStats = settings.getResetStatsMap().getStats(statRequest.getUID());
                }
                catch (NotFoundException notFoundException) {
                    if (!tc.isDebugEnabled()) break block27;
                    Tr.debug(tc, "get - caught NotFoundException while getting baseline Stats", notFoundException);
                }
            }
            if (wSStats != null) {
                wSStatsArray = TPVFilter.doClear(wSStatsArray, wSStats.getTime());
                TPVFilter.doReset(wSStats, wSStatsArray, statRequest.getUID());
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "get - baseLine was null, can't reset");
            }
        }
        if (statRequest.getLog()) {
            statResult2.setEndOfFile(settings.getParser().isEOF());
        }
        if (statRequest.getMode() != 0) {
            wSStatsArray = TPVFilter.doModeTransformation(statRequest.getMode(), wSStatsArray);
        }
        statResult2.setStats(wSStatsArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get");
        }
        return statResult2;
    }

    protected boolean advanceLogfileBuffer(StatRequest statRequest, Settings settings) throws NotFoundException, Exception {
        int n;
        if (!statRequest.getLog()) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        switch (statRequest.getLogPlayMode()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = -1;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 10;
                break;
            }
            case 5: {
                n2 = 0;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "advanceLogFileBuffer - advLogCnt=" + n2 + ", log play mode=" + statRequest.getLogPlayMode() + ", sr.getView=" + statRequest.getView());
        }
        if (statRequest.getView() == 2 || statRequest.getView() == 1) {
            n2 = 0;
        }
        UserPreferences userPreferences = settings.getUserPreferences();
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        StatsLogParser statsLogParser = settings.getParser();
        if (n2 == -1) {
            try {
                statsLogParser.reset();
                userStatsBuffer.dispose(userPreferences);
                userStatsBuffer.init(userPreferences);
                settings.setClearTime(-1L);
                settings.setReset(false);
                settings.setResetStatsMap(null);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "advanceLogFileBuffer - caught Exception while resetting parser", exception);
                }
                exception.printStackTrace();
            }
            n2 = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "get - reset log file");
            }
        }
        for (n = 0; n < n2; ++n) {
            WSStats wSStats = statsLogParser.next();
            if (wSStats == null) {
                bl = true;
                break;
            }
            userStatsBuffer.putServerStats(userPreferences, wSStats);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "advanceLogFileBuffer - should have advanced buffer by " + n2 + " actual was " + n);
        }
        return bl;
    }

    protected static WSStats[] doClear(WSStats[] wSStatsArray, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doClear", new Long(l));
        }
        if (wSStatsArray == null || wSStatsArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doClear - statsArr == null");
            }
            return wSStatsArray;
        }
        if (wSStatsArray[wSStatsArray.length - 1].getTime() >= l) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doClear - all Stats newer");
            }
            return wSStatsArray;
        }
        ArrayList<WSStats> arrayList = new ArrayList<WSStats>();
        for (int i = 0; i < wSStatsArray.length; ++i) {
            if (wSStatsArray[i].getTime() < l) continue;
            arrayList.add(wSStatsArray[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "doClear - " + arrayList.size() + " of " + wSStatsArray.length + " Stats are newer");
        }
        WSStats[] wSStatsArray2 = new WSStats[arrayList.size()];
        arrayList.toArray(wSStatsArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doClear");
        }
        return wSStatsArray2;
    }

    protected static WSStats getResetStats(StatRequest statRequest) {
        WSStats[] wSStatsArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResetStats");
        }
        StatRequest statRequest2 = new StatRequest(statRequest.getNode(), statRequest.getServer(), 0, true, true);
        statRequest2.setUserID(statRequest.getUserID());
        if (statRequest.getLog()) {
            statRequest2.setLog(true);
            statRequest2.setLogName(statRequest.getLogName());
        }
        StatResult statResult = null;
        try {
            statResult = engine.getBuffer().get(statRequest2);
        }
        catch (NotFoundException notFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getResetStats - caught NotFoundException while getting reset Stats", notFoundException);
            }
            notFoundException.printStackTrace();
        }
        WSStats wSStats = null;
        if (statResult != null && (wSStatsArray = statResult.getStatsArray()) != null && wSStatsArray.length != 0) {
            wSStats = wSStatsArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResetStats");
        }
        return wSStats;
    }

    private static WSStats[] doModeTransformation(byte by, WSStats[] wSStatsArray) {
        WSStats[] wSStatsArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doModeTransformation", new Byte(by));
        }
        if (wSStatsArray.length == 1) {
            Tr.debug(tc, "Creating additional identical stat for comparison");
            wSStatsArray2 = new WSStats[]{wSStatsArray[0], wSStatsArray[0]};
            wSStatsArray = wSStatsArray2;
            Tr.debug(tc, "Stats new length is : " + wSStatsArray.length);
        }
        wSStatsArray2 = new WSStats[wSStatsArray.length - 1];
        for (int i = wSStatsArray2.length - 1; i >= 0; --i) {
            wSStatsArray2[i] = TPVFilter.modeTransform(by, wSStatsArray[i + 1], wSStatsArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doModeTransformation");
        }
        return wSStatsArray2;
    }

    private static WSStats modeTransform(byte by, WSStats wSStats, WSStats wSStats2) {
        Object object;
        Object object2;
        StatsImpl statsImpl = StatsCreator.create(wSStats2.getStatsType(), wSStats2.getName(), wSStats2.getType(), wSStats2.getLevel(), wSStats2.getTime());
        WSStatistic[] wSStatisticArray = wSStats2.getStatistics();
        if (wSStatisticArray != null && wSStatisticArray.length > 0) {
            object2 = new ArrayList(wSStatisticArray.length);
            for (int i = 0; i < wSStatisticArray.length; ++i) {
                WSStatistic wSStatistic = wSStatisticArray[i];
                if (by == 2) {
                    object = wSStatistic.rateOfChange(wSStats.getStatistic(wSStatistic.getId()));
                    if (object == null) {
                        object = wSStatistic.copy();
                        object.resetOnClient((WSStatistic)object);
                    }
                    ((ArrayList)object2).add(object);
                    continue;
                }
                if (by != 1) continue;
                ((ArrayList)object2).add(wSStatistic.delta(wSStats.getStatistic(wSStatistic.getId())));
            }
            statsImpl.setStatistics((ArrayList)object2);
        }
        if ((object2 = wSStats2.getSubStats()) != null & ((WSStats[])object2).length > 0) {
            ArrayList<WSStats> arrayList = new ArrayList<WSStats>(((WSStats[])object2).length);
            for (int i = 0; i < ((WSStats[])object2).length; ++i) {
                object = object2[i];
                arrayList.add(TPVFilter.modeTransform(by, (WSStats)object, wSStats.getStats(object.getName())));
            }
            statsImpl.setSubStats(arrayList);
        }
        return statsImpl;
    }

    private static void doReset(WSStats wSStats, WSStats[] wSStatsArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReset", new Integer(n));
        }
        if (wSStatsArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doReset - null passed in, returning");
            }
            return;
        }
        for (int i = 0; i < wSStatsArray.length; ++i) {
            TPVFilter.reset(wSStats, wSStatsArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReset");
        }
    }

    private static void reset(WSStats wSStats, WSStats wSStats2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        WSStatistic[] wSStatisticArray = wSStats2.getStatistics();
        ArrayList<WSStatistic> arrayList = new ArrayList<WSStatistic>(wSStatisticArray.length);
        for (int i = 0; i < wSStatisticArray.length; ++i) {
            WSStatistic wSStatistic;
            WSStatistic wSStatistic2 = wSStats.getStatistic(wSStatisticArray[i].getId());
            if (wSStatistic2 != null) {
                wSStatistic = wSStatisticArray[i].copy();
                wSStatistic.resetOnClient(wSStatistic2);
                wSStatistic.update(wSStatisticArray[i]);
                wSStatistic.setDataInfo(wSStatisticArray[i].getDataInfo());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reset - no base statistic");
                }
                wSStatistic = wSStatisticArray[i];
            }
            arrayList.add(wSStatistic);
        }
        ((SPIStats)wSStats2).setStatistics(arrayList);
        WSStats[] wSStatsArray = wSStats2.getSubStats();
        for (int i = 0; i < wSStatsArray.length; ++i) {
            WSStats wSStats3 = wSStats.getStats(wSStatsArray[i].getName());
            if (wSStats3 == null) continue;
            TPVFilter.reset(wSStats3, wSStatsArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    private int getUID(TreeNodeData[] treeNodeDataArray, String string) {
        for (int i = 0; i < treeNodeDataArray.length; ++i) {
            if (!treeNodeDataArray[i].getStatsName().endsWith(string)) continue;
            return treeNodeDataArray[i].getUID();
        }
        return -1;
    }

    public Summary getSummary(StatRequest statRequest) throws NotFoundException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSummary");
        }
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        String string = null;
        string = statRequest.getLog() ? TPVFilter.generateKey(statRequest.getUserID(), statRequest.getLogName()) : TPVFilter.generateKey(statRequest.getUserID(), statRequest.getNode(), statRequest.getServer());
        Settings settings = (Settings)this.uidMap.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSummary - settingsKey: " + string);
        }
        if (settings == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getSummary - user is no longer registered");
            }
            throw new UserNotRegisteredException(statRequest.getUserID(), statRequest);
        }
        UserPreferences userPreferences = settings.getUserPreferences();
        Summary summary = null;
        TreeNodeData treeNodeData = userStatsBuffer.getTreeStructure(userPreferences);
        boolean bl = this.advanceLogfileBuffer(statRequest, settings);
        if (statRequest.getType() == 16) {
            summary = this.getServletSummary(userPreferences, treeNodeData);
        } else if (statRequest.getType() == 0) {
            summary = this.getEjbSummary(userPreferences, treeNodeData);
        } else if (statRequest.getType() == 48) {
            summary = this.getThreadPoolSummary(userPreferences, treeNodeData);
        } else if (statRequest.getType() == 64) {
            summary = this.getConnectionPoolSummary(userPreferences, treeNodeData);
        }
        if (summary != null) {
            summary.setEOF(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSummary");
        }
        return summary;
    }

    private ConnectionPoolSummary getConnectionPoolSummary(UserPreferences userPreferences, TreeNodeData treeNodeData) throws NotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionPoolSummary", userPreferences);
        }
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        TreeNodeData treeNodeData2 = null;
        for (int i = 0; i < treeNodeData.getNumChildren(); ++i) {
            TreeNodeData treeNodeData3 = treeNodeData.getChild(i);
            if (!treeNodeData3.getStatsName().equals("connectionPoolModule")) continue;
            treeNodeData2 = treeNodeData3;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "getConnectionPoolSummary - found JDBC Connection Pool module" + treeNodeData2);
            break;
        }
        if (treeNodeData2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getConnectionPoolSummary - did not find JDBC Connection Pool module");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionPoolSummary - no JDBC Connection Pool module, returning null");
            }
            return null;
        }
        ConnectionPoolSummary connectionPoolSummary = new ConnectionPoolSummary(null);
        StatRequest statRequest = new StatRequest(userPreferences.getNodeName(), userPreferences.getServerName(), 0, false, true, null, userPreferences.getUserId());
        long[] lArray = new long[]{};
        for (int i = 0; i < treeNodeData2.getNumChildren(); ++i) {
            StatResult statResult;
            statRequest.setUID(treeNodeData2.getChild(i).getUID());
            if (userPreferences.getViewLog()) {
                statRequest.setLog(true);
                statRequest.setLogName(userPreferences.getLogFileName());
            }
            if ((statResult = userStatsBuffer.get(statRequest)) == null || statResult.getLength() == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getConnectionPoolSummary - no data from buffer, return null");
                continue;
            }
            int n = statResult.getLength();
            if (n > lArray.length) {
                lArray = statResult.getTimeArray();
            }
            float[] fArray = new float[statResult.getLength()];
            for (int j = 0; j < statResult.getLength(); ++j) {
                WSStats wSStats = statResult.getStat(j);
                if (wSStats == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getConnectionPoolSummary - null Stats");
                    }
                    fArray[j] = -1.0f;
                    continue;
                }
                WSStatistic wSStatistic = wSStats.getStatistic(5);
                WSStatistic wSStatistic2 = wSStats.getStatistic(3);
                WSStatistic wSStatistic3 = wSStats.getStatistic(4);
                if (wSStatistic == null || wSStatistic2 == null || wSStatistic3 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getConnectionPoolSummary - a needed Statistic was null");
                    }
                    fArray[j] = -1.0f;
                    continue;
                }
                long l = ((WSBoundedRangeStatistic)wSStatistic).getCurrent();
                long l2 = ((WSCountStatistic)wSStatistic2).getCount();
                long l3 = ((WSCountStatistic)wSStatistic3).getCount();
                fArray[j] = l == 0L || l2 == 0L ? 0.0f : (l < 0L || l2 < 0L || l3 < 0L ? -1.0f : (float)(l2 - l3) / (float)l * 100.0f);
            }
            connectionPoolSummary.addConnection(statResult.getStat(0).getName(), statResult.getStat(0).getStatsType(), fArray);
        }
        connectionPoolSummary.setTime(lArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPoolSummary");
        }
        return connectionPoolSummary;
    }

    private ThreadPoolSummary getThreadPoolSummary(UserPreferences userPreferences, TreeNodeData treeNodeData) throws NotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPoolSummary", userPreferences);
        }
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        TreeNodeData treeNodeData2 = null;
        for (int i = 0; i < treeNodeData.getNumChildren(); ++i) {
            TreeNodeData treeNodeData3 = treeNodeData.getChild(i);
            if (!treeNodeData3.getStatsName().equals("threadPoolModule")) continue;
            treeNodeData2 = treeNodeData3;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "getThreadPoolSummary - found Threadpool module" + treeNodeData2);
            break;
        }
        if (treeNodeData2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getThreadPoolSummary - did not find Threadpool module");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getThreadPoolSummary - no Threadpool module, returning null");
            }
            return null;
        }
        ThreadPoolSummary threadPoolSummary = new ThreadPoolSummary(null);
        StatRequest statRequest = new StatRequest(userPreferences.getNodeName(), userPreferences.getServerName(), 0, false, true, null, userPreferences.getUserId());
        long[] lArray = new long[]{};
        for (int i = 0; i < treeNodeData2.getNumChildren(); ++i) {
            StatResult statResult;
            statRequest.setUID(treeNodeData2.getChild(i).getUID());
            if (userPreferences.getViewLog()) {
                statRequest.setLog(true);
                statRequest.setLogName(userPreferences.getLogFileName());
            }
            if ((statResult = userStatsBuffer.get(statRequest)) == null || statResult.getLength() == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getThreadPoolSummary - no data from buffer, return null");
                continue;
            }
            int n = statResult.getLength();
            if (n > lArray.length) {
                lArray = statResult.getTimeArray();
            }
            float[] fArray = new float[statResult.getLength()];
            for (int j = 0; j < statResult.getLength(); ++j) {
                WSStats wSStats = statResult.getStat(j);
                if (wSStats == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getThreadPoolSummary - null Stats");
                    }
                    fArray[j] = -1.0f;
                    continue;
                }
                WSStatistic wSStatistic = wSStats.getStatistic(4);
                WSStatistic wSStatistic2 = wSStats.getStatistic(3);
                if (wSStatistic == null || wSStatistic2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getThreadPoolSummary - a needed Statistic was null");
                    }
                    fArray[j] = -1.0f;
                    continue;
                }
                long l = ((WSBoundedRangeStatistic)wSStatistic).getCurrent();
                long l2 = ((WSBoundedRangeStatistic)wSStatistic2).getCurrent();
                fArray[j] = l == 0L || l2 == 0L ? 0.0f : (l < 0L || l2 < 0L ? -1.0f : (float)l2 / (float)l * 100.0f);
            }
            threadPoolSummary.addThreadPool(statResult.getStat(0).getName(), statResult.getStat(0).getStatsType(), fArray);
        }
        threadPoolSummary.setTime(lArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPoolSummary");
        }
        return threadPoolSummary;
    }

    private EJBSummary getEjbSummary(UserPreferences userPreferences, TreeNodeData treeNodeData) throws NotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEjbSummary", userPreferences);
        }
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        TreeNodeData treeNodeData2 = null;
        for (int i = 0; i < treeNodeData.getNumChildren(); ++i) {
            TreeNodeData treeNodeData3 = treeNodeData.getChild(i);
            if (!treeNodeData3.getStatsName().equals("beanModule")) continue;
            treeNodeData2 = treeNodeData3;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "getEjbSummary - found ejb module" + treeNodeData2);
            break;
        }
        if (treeNodeData2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getEjbSummary - did not find ejb module");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getEjbSummary - no ejb module, returning null");
            }
            return null;
        }
        EJBSummary eJBSummary = new EJBSummary();
        StatRequest statRequest = new StatRequest(userPreferences.getNodeName(), userPreferences.getServerName(), 0, true, false, null, userPreferences.getUserId());
        if (userPreferences.getViewLog()) {
            statRequest.setLog(true);
            statRequest.setLogName(userPreferences.getLogFileName());
        }
        for (int i = 0; i < treeNodeData2.getNumChildren(); ++i) {
            TreeNodeData treeNodeData4 = treeNodeData2.getChild(i);
            for (int j = 0; j < treeNodeData4.getNumChildren(); ++j) {
                TreeNodeData treeNodeData5 = treeNodeData4.getChild(j);
                for (int k = 0; k < treeNodeData5.getNumChildren(); ++k) {
                    TreeNodeData treeNodeData6 = treeNodeData5.getChild(k);
                    statRequest.setUID(treeNodeData6.getUID());
                    StatResult statResult = userStatsBuffer.get(statRequest);
                    if (statResult == null || statResult.getStat(0) == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "getEjbSummary - no data for EJB " + treeNodeData6.getStatsName());
                        continue;
                    }
                    WSStats wSStats = statResult.getStat(0);
                    WSCountStatistic wSCountStatistic = (WSCountStatistic)wSStats.getStatistic(11);
                    WSTimeStatistic wSTimeStatistic = (WSTimeStatistic)wSStats.getStatistic(12);
                    long l = wSCountStatistic == null ? -1L : wSCountStatistic.getCount();
                    float f = wSTimeStatistic == null ? -1.0f : (float)wSTimeStatistic.getMean();
                    EJBSummaryObj eJBSummaryObj = new EJBSummaryObj(treeNodeData4.getStatsName(), wSStats.getName(), wSStats.getTime(), l, f);
                    eJBSummary.addEjbSummaryObject(eJBSummaryObj);
                    WSStats wSStats2 = wSStats.getStats("beanModule.methods");
                    if (wSStats2 == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "getEjbSummary - no method level stats");
                        continue;
                    }
                    WSStats[] wSStatsArray = wSStats2.getSubStats();
                    if (wSStatsArray == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "getEjbSummary - no method level stats");
                        continue;
                    }
                    for (int i2 = 0; i2 < wSStatsArray.length; ++i2) {
                        wSCountStatistic = (WSCountStatistic)wSStatsArray[i2].getStatistic(51);
                        wSTimeStatistic = (WSTimeStatistic)wSStatsArray[i2].getStatistic(52);
                        l = wSCountStatistic == null ? -1L : wSCountStatistic.getCount();
                        f = wSTimeStatistic == null ? -1.0f : (float)wSTimeStatistic.getMean();
                        eJBSummaryObj.addMethod(wSStatsArray[i2].getName(), l, f);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEjbSummary");
        }
        return eJBSummary;
    }

    private ServletSummary getServletSummary(UserPreferences userPreferences, TreeNodeData treeNodeData) throws NotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServletSummary", userPreferences);
        }
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        TreeNodeData treeNodeData2 = null;
        for (int i = 0; i < treeNodeData.getNumChildren(); ++i) {
            TreeNodeData treeNodeData3 = treeNodeData.getChild(i);
            if (!treeNodeData3.getStatsName().equals("webAppModule")) continue;
            treeNodeData2 = treeNodeData3;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "getServletSummary - found webApp module" + treeNodeData2);
            break;
        }
        if (treeNodeData2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServletSummary - did not find webApp module");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServletSummary - no webApp module, returning null");
            }
            return null;
        }
        ServletSummary servletSummary = new ServletSummary();
        StatRequest statRequest = new StatRequest(userPreferences.getNodeName(), userPreferences.getServerName(), 0, true, false, null, userPreferences.getUserId());
        if (userPreferences.getViewLog()) {
            statRequest.setLog(true);
            statRequest.setLogName(userPreferences.getLogFileName());
        }
        for (int i = 0; i < treeNodeData2.getNumChildren(); ++i) {
            TreeNodeData treeNodeData4 = treeNodeData2.getChild(i);
            TreeNodeData treeNodeData5 = null;
            for (int j = 0; j < treeNodeData4.getNumChildren(); ++j) {
                if (!treeNodeData4.getChild(j).getStatsName().equals("webAppModule.servlets")) continue;
                treeNodeData5 = treeNodeData4.getChild(j);
            }
            if (treeNodeData5 == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getServletSummary - no servlet information for webApp " + treeNodeData4.getStatsName());
                continue;
            }
            statRequest.setUID(treeNodeData5.getUID());
            StatResult statResult = userStatsBuffer.get(statRequest);
            if (statResult == null || statResult.getLength() == 0 || statResult.getStat(0).getSubStats() == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getServletSummary - no servlet information for webApp " + treeNodeData4.getStatsName());
                continue;
            }
            WSStats[] wSStatsArray = statResult.getStat(0).getSubStats();
            for (int j = 0; j < wSStatsArray.length; ++j) {
                WSCountStatistic wSCountStatistic = (WSCountStatistic)wSStatsArray[j].getStatistic(11);
                WSTimeStatistic wSTimeStatistic = (WSTimeStatistic)wSStatsArray[j].getStatistic(13);
                long l = wSCountStatistic == null ? -1L : wSCountStatistic.getCount();
                float f = wSTimeStatistic == null ? -1.0f : (float)wSTimeStatistic.getMean();
                ServletSummaryObj servletSummaryObj = new ServletSummaryObj(treeNodeData4.getStatsName(), wSStatsArray[j].getName(), wSStatsArray[j].getTime(), l, f);
                servletSummary.addServletSummaryObject(servletSummaryObj);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServletSummary");
        }
        return servletSummary;
    }

    public TreeNodeData getTreeStructure(StatRequest statRequest) throws NotFoundException {
        UserPreferences userPreferences;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTreeStructure", statRequest);
        }
        TreeNodeData treeNodeData = null;
        UserStatsBuffer userStatsBuffer = engine.getBuffer();
        String string = null;
        string = statRequest.getLog() ? TPVFilter.generateKey(statRequest.getUserID(), statRequest.getLogName()) : TPVFilter.generateKey(statRequest.getUserID(), statRequest.getNode(), statRequest.getServer());
        Settings settings = (Settings)this.uidMap.get(string);
        if (settings != null) {
            userPreferences = settings.getUserPreferences();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTreeStructure - unable to find settings for StatRequest: " + statRequest);
            }
            userPreferences = new UserPreferences();
            userPreferences.setNodeName(statRequest.getNode());
            userPreferences.setServerName(statRequest.getServer());
            userPreferences.setUserId(statRequest.getUserID());
            if (statRequest.getLog()) {
                userPreferences.setViewLog(true);
                userPreferences.setLogFileName(statRequest.getLogName());
            }
        }
        treeNodeData = userStatsBuffer.getTreeStructure(userPreferences);
        if (treeNodeData.getNumChildren() == 0) {
            Tr.debug(tc, treeNodeData.getStatsName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTreeStructure");
        }
        return treeNodeData;
    }

    private static String generateKey(String string, String string2, String string3) {
        return string + "#" + string2 + "#" + string3;
    }

    private static String generateKey(String string, String string2) {
        return string + "#" + string2;
    }
}

