/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.logger;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.logger.TPVLogging;
import com.ibm.ws.tpv.engine.logger.WriteBinaryStatLog;
import com.ibm.ws.tpv.engine.logger.WriteStatLog;
import com.ibm.ws.tpv.engine.logger.WriteXMLStatLog;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import java.util.HashMap;
import java.util.Iterator;

public class TPVLoggingImpl
implements TPVLogging {
    private HashMap logs;
    protected static final TraceComponent tc = Tr.register(TPVLoggingImpl.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public TPVLoggingImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.logs = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public boolean startLogging(UserPreferences userPreferences) {
        ServerBean serverBean;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startLogging", userPreferences);
        }
        if (this.logs.containsKey(serverBean = new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName()))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startLogging - server already being logged");
            }
            return false;
        }
        String string = userPreferences.getLogFileName();
        String string2 = userPreferences.getTpvLogFormat();
        WriteStatLog writeStatLog = null;
        try {
            writeStatLog = string.endsWith(".tpv") || string.endsWith(".bin") ? new WriteBinaryStatLog(userPreferences, this) : (string2.equalsIgnoreCase("bin") || string2.equalsIgnoreCase("tpv") ? new WriteBinaryStatLog(userPreferences, this) : new WriteXMLStatLog(userPreferences, this));
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startLogging - caught Exception while creating logger", exception);
            }
            exception.printStackTrace();
        }
        if (writeStatLog != null) {
            this.logs.put(serverBean, writeStatLog);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startLogging", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startLogging", new Boolean(false));
        }
        return false;
    }

    public boolean stopLogging(UserPreferences userPreferences) {
        ServerBean serverBean;
        WriteStatLog writeStatLog;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopLogging", userPreferences);
        }
        if ((writeStatLog = (WriteStatLog)this.logs.remove(serverBean = new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName()))) != null) {
            writeStatLog.stopLogging();
        }
        if (writeStatLog != null && userPreferences.getUserId().equals(writeStatLog.getLoggersUserId()) && writeStatLog.isStopMonitoring()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stop monitoring due to logging ending");
            }
            TPVEngine.getEngine().disableServer(userPreferences);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopLogging");
        }
        return true;
    }

    public ServerBean[] getLoggingServers() {
        ServerBean[] serverBeanArray = new ServerBean[this.logs.size()];
        int n = 0;
        Iterator iterator = this.logs.keySet().iterator();
        while (iterator.hasNext()) {
            serverBeanArray[n++] = (ServerBean)iterator.next();
        }
        return serverBeanArray;
    }

    public boolean isServerLogging(ServerBean serverBean) {
        return this.logs.containsKey(serverBean);
    }

    public String whoIsLogging(ServerBean serverBean) {
        WriteStatLog writeStatLog = (WriteStatLog)this.logs.get(serverBean);
        if (writeStatLog != null) {
            return writeStatLog.getLoggersUserId();
        }
        return null;
    }

    public void setStopMonitoring(ServerBean serverBean, boolean bl) {
        WriteStatLog writeStatLog = (WriteStatLog)this.logs.get(serverBean);
        if (writeStatLog != null) {
            writeStatLog.setStopMonitoring(bl);
        }
    }
}

