/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.logger;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.logger.TPVLoggingImpl;
import com.ibm.ws.tpv.engine.logger.WriteStatLog;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class WriteBinaryStatLog
extends WriteStatLog {
    public static final String TYPE = "BIN";
    private ObjectOutputStream ooStream;
    private int writeCount = 0;

    public WriteBinaryStatLog(UserPreferences userPreferences, TPVLoggingImpl tPVLoggingImpl) throws NotFoundException, Exception {
        super(userPreferences, tPVLoggingImpl);
    }

    protected void initOutputStream(String string) throws Exception {
        try {
            this.ooStream = new ObjectOutputStream(new FileOutputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "<init> - Caught FileNotFoundException while creating log file, rethrowing");
            }
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "<init> - Caught IOException while creating log file, rethrowing");
            }
            throw iOException;
        }
    }

    protected void printFileHeader() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printFileHeader");
        }
        try {
            this.ooStream.writeObject(this.up.getNodeName());
            this.ooStream.writeObject(this.up.getServerName());
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "printFileHeader - caught IOException while writing file header info");
            }
            iOException.printStackTrace(System.err);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "printFileHeader");
        }
    }

    protected void printStatsData(WSStats wSStats) {
        block3: {
            try {
                this.ooStream.writeObject("STATS");
                this.ooStream.writeObject(wSStats);
                ++this.writeCount;
                if (this.writeCount > 100) {
                    this.writeCount = 0;
                    this.ooStream.reset();
                }
                this.ooStream.flush();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "printStatsData - caught IOException while writing Stats", iOException);
            }
        }
    }

    protected void closeFile() {
        block2: {
            try {
                this.ooStream.reset();
                this.ooStream.flush();
                this.ooStream.close();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "closeFile - caught IOException while closing file", iOException);
            }
        }
    }

    protected String getFileExtension() {
        return ".tpv";
    }

    protected String getType() {
        return TYPE;
    }

    public void writeConfig(String string, HashMap hashMap) {
        block2: {
            try {
                this.ooStream.writeObject("CONFIG");
                this.ooStream.writeObject(string);
                this.ooStream.writeObject(hashMap);
                this.ooStream.reset();
                this.ooStream.flush();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "printStatsData - caught IOException while writing Stats", iOException);
            }
        }
    }
}

