/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.logger;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.performance.tuning.calc.AbstractCalcWriter;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.buffer.StatRequest;
import com.ibm.ws.tpv.engine.buffer.StatResult;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.logger.TPVLoggingImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class WriteStatLog
extends AbstractCalcWriter
implements Observer {
    private static final int SEC_TO_MS = 1000;
    private static String tpvLogDir;
    private static String pathSep;
    private static File fTpvDir;
    protected TPVEngine engine;
    protected UserPreferences up;
    protected StatRequest request;
    protected int bufferSize;
    protected int numEntries;
    protected long loggingStart;
    protected long loggingStop;
    protected File currentLogFile;
    protected String currentLogFileName;
    protected int currentLogFileNumber;
    protected TPVLoggingImpl logController;
    protected boolean stopMonitoring = false;
    protected static final TraceComponent tc;

    public WriteStatLog(UserPreferences userPreferences, TPVLoggingImpl tPVLoggingImpl) throws NotFoundException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.logController = tPVLoggingImpl;
        this.up = userPreferences.copy();
        this.engine = TPVEngine.getEngine();
        String string = this.up.getLogFileName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            this.up.setLogFileName(string.substring(0, n));
        }
        this.loggingStart = System.currentTimeMillis();
        this.loggingStop = this.loggingStart + this.up.getLoggingDuration() * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "logging start time " + new Date(this.loggingStart).toString());
            Tr.debug(tc, "loggingDuration - (seconds)" + this.up.getLoggingDuration());
            Tr.debug(tc, "logging stop time  " + new Date(this.loggingStop).toString());
        }
        this.request = new StatRequest(this.up.getNodeName(), this.up.getServerName(), 0, true, false);
        this.request.setUserID(this.up.getUserId());
        String string2 = this.engine.getCollector().getType();
        if (string2.equals("NodeAgent") && !this.up.getServerName().equalsIgnoreCase("nodeagent")) {
            this.request.setLinkSystemData(true);
        }
        try {
            this.bufferSize = this.engine.getBuffer().getBufferSize(this.up);
        }
        catch (NotFoundException notFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "<init> - Caught NotFoundException while trying to get the buffer, rethrowing");
            }
            throw notFoundException;
        }
        this.currentLogFileNumber = 1;
        this.openLogFile(this.createFileName(this.currentLogFileNumber));
        String string3 = this.up.getServerName();
        if (!string3.equalsIgnoreCase("nodeAgent")) {
            this.writeConfig(this.up.getNodeName(), this.up.getServerName(), TPVEngine.getRepository());
        }
        this.engine.addBufferUpdateListener(this, this.up);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    protected String createFileName(int n) {
        String string;
        String string2;
        block12: {
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "createFileName", n + "");
                }
                try {
                    if (!fTpvDir.isDirectory()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "createFileName - TPV Log Directory invalid - attempt to re-create");
                        }
                        tpvLogDir = null;
                        WriteStatLog.tpvLogDirCreate();
                    }
                }
                catch (SecurityException securityException) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "createFileName - SecurityException on fTpvDir.isDirectory()", securityException);
                }
            }
            string2 = tpvLogDir != null ? tpvLogDir : "";
            string = this.up.getLogFileName();
            if (string.indexOf(47) > -1 || string.indexOf(92) > -1) {
                string = string.replace('\\', '/');
                int n2 = (string = string.replace('/', File.separatorChar)).lastIndexOf(File.separatorChar);
                if (n2 > -1) {
                    string2 = string.substring(0, n2);
                    string = string.substring(n2 + 1);
                    File file = new File(string2);
                    try {
                        if (!file.exists() && !file.mkdirs() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "createFileName - unable to create specified directory: " + string2);
                        }
                    }
                    catch (SecurityException securityException) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "createFileName - SecurityException on f.exists() or f.mkdirs()", securityException);
                    }
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string2).append(pathSep);
        stringBuffer.append(string).append("_").append(this.up.getServerName()).append("_").append(this.loggingStart).append("_").append(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFileName - fileName: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected void openLogFile(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openLogFile", string);
        }
        this.currentLogFileName = string;
        String string2 = string + this.getFileExtension();
        this.initOutputStream(string2);
        this.currentLogFile = new File(string2);
        this.numEntries = 0;
        this.printFileHeader();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openLogFile");
        }
    }

    protected void writeToLog(WSStats wSStats) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "writeToLog");
            }
            this.printStatsData(wSStats);
            ++this.numEntries;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, System.currentTimeMillis() + " > " + this.loggingStop);
            }
            if (System.currentTimeMillis() > this.loggingStop) {
                this.logController.stopLogging(this.up);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeToLog - logging duration complete, stopping");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.currentLogFile.length() + ">" + this.up.getLogFileSize());
            }
            if (this.currentLogFile.length() > this.up.getLogFileSize()) {
                int n;
                File file;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writeToLog - log has reached max size, zip and rotate");
                }
                this.closeFile();
                this.zipCurrentFile();
                if (this.currentLogFileNumber >= this.up.getNumLogFiles() && (file = new File(this.createFileName(n = this.currentLogFileNumber - this.up.getNumLogFiles() + 1) + ".zip")).exists()) {
                    file.delete();
                }
                try {
                    this.openLogFile(this.createFileName(++this.currentLogFileNumber));
                    this.writeConfig(this.up.getNodeName(), this.up.getServerName(), TPVEngine.getRepository());
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "writeToLog - caught Exception while trying to open " + this.currentLogFileName, exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeToLog");
        }
    }

    protected void zipCurrentFile() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "zipCurrentFile");
            }
            String string = this.currentLogFileName + ".zip";
            String string2 = this.currentLogFileName + this.getFileExtension();
            try {
                int n;
                ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2), 2048);
                zipOutputStream.putNextEntry(new ZipEntry(WriteStatLog.trimPath(string2)));
                byte[] byArray = new byte[2048];
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.close();
                bufferedInputStream.close();
                this.currentLogFile.delete();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "zipCurrentFile - caught Exception while trying to zip up the log file", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zipCurrentFile");
        }
    }

    public void stopLogging() {
        this.engine.removeBufferUpdateListener(this, this.up);
        this.closeFile();
        this.zipCurrentFile();
    }

    public void update(Observable observable, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update");
        }
        WSStats wSStats = null;
        StatResult statResult = null;
        try {
            statResult = this.engine.getBuffer().get(this.request);
            wSStats = statResult.getStat(0);
        }
        catch (NotFoundException notFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "update - caught NotFoundException while getting latest Stats", notFoundException);
            }
            notFoundException.printStackTrace();
        }
        if (wSStats != null) {
            this.writeToLog(wSStats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    public String getLoggersUserId() {
        return this.up.getUserId();
    }

    public boolean isStopMonitoring() {
        return this.stopMonitoring;
    }

    public void setStopMonitoring(boolean bl) {
        this.stopMonitoring = bl;
    }

    protected abstract void initOutputStream(String var1) throws Exception;

    protected abstract void printFileHeader();

    protected abstract void printStatsData(WSStats var1);

    protected abstract void closeFile();

    protected abstract String getFileExtension();

    protected abstract String getType();

    private static String trimPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trimPath", string);
        }
        String string2 = null;
        int n = string.lastIndexOf(pathSep);
        string2 = n == -1 ? string : string.substring(n + 1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trimPath", string2);
        }
        return string2;
    }

    private static void tpvLogDirCreate() {
        block12: {
            pathSep = System.getProperty("file.separator");
            String string = System.getProperty("server.root");
            String string2 = string + pathSep + "logs" + pathSep + "tpv";
            fTpvDir = new File(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tpvLogDirCreate - tpvDir: " + string2);
            }
            try {
                if (fTpvDir.exists()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tpvLogDirCreate - tpvDir exists");
                    }
                    tpvLogDir = string2;
                    break block12;
                }
                try {
                    if (fTpvDir.mkdirs()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "tpvLogDirCreate - created directories");
                        }
                        tpvLogDir = string2;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tpvLogDirCreate - does not exist and couldn't create");
                    }
                }
                catch (SecurityException securityException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tpvLogDirCreate - SecurityException on fTpvDir.mkdirs()", securityException);
                    }
                }
            }
            catch (SecurityException securityException) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "tpvLogDirCreate - SecurityException on fTpvDir.exists()", securityException);
            }
        }
    }

    static {
        tc = Tr.register(WriteStatLog.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");
        WriteStatLog.tpvLogDirCreate();
    }
}

