/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.logger;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.logger.TPVLoggingImpl;
import com.ibm.ws.tpv.engine.logger.WriteStatLog;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

public class WriteXMLStatLog
extends WriteStatLog {
    public static final String TYPE = "XML";
    private PrintWriter pwOut;

    public WriteXMLStatLog(UserPreferences userPreferences, TPVLoggingImpl tPVLoggingImpl) throws NotFoundException, Exception {
        super(userPreferences, tPVLoggingImpl);
    }

    protected void initOutputStream(String string) throws Exception {
        try {
            this.pwOut = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(string)), "UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "<init> - Caught FileNotFoundException while creating log file, rethrowing");
            }
            throw fileNotFoundException;
        }
    }

    protected void printFileHeader() {
        this.pwOut.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<TPVLog version=\"6.0\">\n");
        this.pwOut.print("<Server name=\"" + this.up.getServerName() + "\"></Server>\n");
        this.pwOut.print("<Node name=\"" + this.up.getNodeName() + "\"></Node>\n");
        this.pwOut.print("<StartTime time=\"" + System.currentTimeMillis() + "\"></StartTime>\n");
        this.pwOut.flush();
    }

    protected void printStatsData(WSStats wSStats) {
        this.pwOut.print("   <Snapshot time=\"" + System.currentTimeMillis() + "\">\n");
        this.pwOut.print(wSStats.toXML());
        this.pwOut.print("   </Snapshot>\n");
        this.pwOut.flush();
    }

    protected void closeFile() {
        this.pwOut.print("<NumOfEntries total=\"" + this.numEntries + "\"></NumOfEntries>");
        this.pwOut.print("<EndTime time=\"" + System.currentTimeMillis() + "\"></EndTime>");
        this.pwOut.print("\n</TPVLog>");
        this.pwOut.flush();
        this.pwOut.close();
        this.pwOut = null;
    }

    protected String getFileExtension() {
        return ".xml";
    }

    protected String getType() {
        return TYPE;
    }

    public void writeConfig(String string, HashMap hashMap) {
        this.pwOut.println("<configInfo id=\"" + string + "\">");
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = hashMap.get(string2);
            if (v == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "writeConfig - got null value for key " + string2 + " for calc " + string);
                continue;
            }
            String string3 = v.getClass().getName();
            this.pwOut.println("    <configParam key=\"" + string2 + "\" cls=\"" + string3 + "\" val=\"" + v.toString() + "\"/>");
        }
        this.pwOut.println("</configInfo>");
        this.pwOut.flush();
    }
}

