/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.parser;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.tpv.engine.parser.StatsLogParser;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;

public class BinaryStatsLogParser
implements StatsLogParser {
    private ObjectInputStream oiStream;
    private String node;
    private String server;
    private String fileName;
    private boolean EOF;
    protected static final TraceComponent tc = Tr.register(BinaryStatsLogParser.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public BinaryStatsLogParser(String string) throws FileNotFoundException, IOException {
        this.fileName = string;
        this.reset();
    }

    public Exception getException() {
        return null;
    }

    public synchronized WSStats next() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "next");
        }
        if (this.EOF) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "next - already at EOF");
            }
            return null;
        }
        WSStats wSStats = null;
        try {
            wSStats = (WSStats)this.oiStream.readObject();
            String string = (String)this.oiStream.readObject();
            while (string.equals("CONFIG")) {
                String string2 = (String)this.oiStream.readObject();
                HashMap hashMap = (HashMap)this.oiStream.readObject();
                CalcCreator.storePersistedCalcConfigMap(this.fileName, string2, hashMap);
                string = (String)this.oiStream.readObject();
            }
        }
        catch (EOFException eOFException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "next - EOFException, reached end of file");
            }
            this.EOF = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "next - ClassNotFoundException while reading from log file", classNotFoundException);
            }
            throw new Exception("binaryFileCorruptError", classNotFoundException);
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "next - IOException while reading from log file", iOException);
            }
            iOException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "next");
        }
        return wSStats;
    }

    public void reset() throws FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.EOF = false;
        this.dispose();
        this.oiStream = new ObjectInputStream(new FileInputStream(this.fileName));
        try {
            this.node = (String)this.oiStream.readObject();
            this.server = (String)this.oiStream.readObject();
            String string = (String)this.oiStream.readObject();
            while (string.equals("CONFIG")) {
                String string2 = (String)this.oiStream.readObject();
                HashMap hashMap = (HashMap)this.oiStream.readObject();
                CalcCreator.storePersistedCalcConfigMap(this.fileName, string2, hashMap);
                string = (String)this.oiStream.readObject();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init - ClassNotFoundException while reading from log file", classNotFoundException);
            }
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init - IOException while reading from log file", iOException);
            }
            iOException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
    }

    public void dispose() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "dispose");
            }
            try {
                if (this.oiStream != null) {
                    this.oiStream.close();
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "dispose - Caught IOException while closing objectInputStream");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose");
        }
    }

    public String getNodeName() {
        return this.node;
    }

    public String getServerName() {
        return this.server;
    }

    public boolean isEOF() {
        return this.EOF;
    }
}

