/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.parser;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.tpv.engine.parser.BinaryStatsLogParser;
import com.ibm.ws.tpv.engine.parser.StatsLogParser;
import com.ibm.ws.tpv.engine.parser.XMLStatsLogParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ParsingController {
    protected static TraceComponent tc = Tr.register(ParsingController.class, "TivoliPerformanceViewer", null);

    public static StatsLogParser parse(String string) throws FileNotFoundException, IOException, Exception {
        Object object;
        String string2;
        String string3;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", string);
        }
        if (!(file = new File(string)).exists()) {
            throw new FileNotFoundException(string);
        }
        String string4 = ParsingController.getFileExtension(string);
        if (string4 == null || !string4.equals(".tpv") && !string4.equals(".xml") && !string4.equals(".zip")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - got invalid file extension, throwing exception: " + string4);
            }
            throw new Exception("invalid file extension: " + string4);
        }
        String string5 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string5);
        if (n != -1) {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parse -  pathName: " + string3 + " fileName: " + string2 + " fileExt: " + string4);
        }
        if (".zip".equals(string4)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - unzipping file...");
            }
            if (((String[])(object = ParsingController.extractLogFromZip(string3, string2))).length > 1) {
                throw new Exception("More than one log file in the zip file");
            }
            string2 = object[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - done unzipping...");
            }
        }
        string4 = ParsingController.getFileExtension(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parse - again: pathName: " + string3 + " fileName: " + string2 + " fileExt: " + string4);
        }
        object = null;
        if (string4.equalsIgnoreCase(".tpv")) {
            object = new BinaryStatsLogParser(string3 + string2);
        } else if (string4.equalsIgnoreCase(".xml")) {
            object = new XMLStatsLogParser(string3 + string2);
        }
        if (object.getException() != null) {
            throw object.getException();
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parser is null");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parser is NOT null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
        return object;
    }

    private static String[] extractLogFromZip(String string, String string2) throws FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractLogFromZip", new String[]{string, string2});
        }
        byte[] byArray = new byte[1024];
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipFile zipFile = new ZipFile(string + string2);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string + zipEntry.getName()));
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            arrayList.add(zipEntry.getName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String getFileExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n);
        }
        return string2;
    }
}

