/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.parser;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.pmi.stat.StatisticCreator;
import com.ibm.ws.pmi.stat.StatsCreator;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.tpv.engine.parser.StatsLogParser;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;
import com.ibm.wsspi.pmi.stat.SPIBoundaryStatistic;
import com.ibm.wsspi.pmi.stat.SPIBoundedRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIDoubleStatistic;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPIStats;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLStatsLogParser
extends DefaultHandler
implements StatsLogParser {
    protected static final String ROOT = "TPVLog";
    protected static final String VERSION = "version";
    protected static final String NODENAME = "Node";
    protected static final String SERVERNAME = "Server";
    protected static final String LOGSTARTTIME = "StartTime";
    protected static final String LOGENDTIME = "EndTime";
    protected static final String NUMENTRIES = "NumOfEntries";
    protected static final String NUMTOTAL = "total";
    protected static final String TREE = "Tree";
    protected static final String SNAP = "Snapshot";
    protected static final String TIME = "time";
    protected static final String STATS = "Stats";
    protected static final String IL = "il";
    protected static final String NAME = "name";
    protected static final String TYPE = "type";
    protected static final String STATSTYPE = "statType";
    protected static final String STATISTIC = "Statistic";
    protected static final String UNIT = "unit";
    protected static final String STARTTIME = "sT";
    protected static final String LASTSAMPLETIME = "lST";
    protected static final String DESCRIPTION = "description";
    protected static final String ID = "id";
    protected static final String BOUNDARYSTATISTIC = "BS";
    protected static final String LOWERBOUND = "lB";
    protected static final String UPPERBOUND = "uB";
    protected static final String RANGESTATISTIC = "RS";
    protected static final String LOWWATERMARK = "lWM";
    protected static final String HIGHWATERMARK = "hWM";
    protected static final String CURRENT = "cur";
    protected static final String INTEGRAL = "int";
    protected static final String BOUNDEDRANGESTATISTIC = "BRS";
    protected static final String COUNTSTATISTIC = "CS";
    protected static final String COUNT = "ct";
    protected static final String TIMESTATISTIC = "TS";
    protected static final String DOUBLESTATISTIC = "DS";
    protected static final String AVERAGESTATISTIC = "AS";
    protected static final String MIN = "min";
    protected static final String MAX = "max";
    protected static final String TOTAL = "tot";
    protected static final String SUMOFSQUARES = "sOS";
    protected static final String TYPE_SPMIROOT = "PMIROOT";
    protected static final String TYPE_SNODE = "NODE";
    protected static final String TYPE_SSERVER = "SERVER";
    protected static final String TYPE_SMODULE = "MODULE";
    protected static final String TYPE_SSUBMODULE = "SUBMODULE";
    protected static final String TYPE_SINSTANCE = "INSTANCE";
    protected static final String TYPE_SSUBINSTANCE = "SUBINSTANCE";
    protected static final String TYPE_SCOLLECTION = "COLLECTION";
    protected static final String CFG_ELEM_INFO = "configInfo";
    protected static final String CFG_ATTR_ID = "id";
    protected static final String CFG_ELEM_PARAM = "configParam";
    protected static final String CFG_ATTR_KEY = "key";
    protected static final String CFG_ATTR_CLASS = "cls";
    protected static final String CFG_ATTR_VALUE = "val";
    private static final TraceComponent tc = Tr.register(XMLStatsLogParser.class, "TivoliPerformanceViewer", null);
    private Thread currentThread;
    private SAXParser parser;
    private parserThread pThread;
    private boolean parsing;
    private String file;
    private String logVersion;
    private String nodeName;
    private String serverName;
    private long startTime;
    private long endTime;
    private int numEntries;
    private boolean EOF;
    private WSStats nextStats;
    private WSStats stats;
    private Stack statsStack;
    private long statsTime;
    private HashMap configMap;
    private String calcClass;
    private Exception exception = null;
    public boolean init = true;

    public XMLStatsLogParser(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", string);
        }
        this.file = string;
        this.statsStack = new Stack();
        this.reset();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public synchronized void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.EOF = false;
        this.init = true;
        this.exception = null;
        this.currentThread = Thread.currentThread();
        if (this.pThread != null) {
            this.dispose();
        }
        this.parser = new SAXParser();
        this.parser.setContentHandler((ContentHandler)this);
        this.parsing = true;
        this.pThread = new parserThread();
        this.pThread.start();
        while (this.parsing) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "reset - caught InterruptedException: " + interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public synchronized WSStats next() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "next");
        }
        this.resumeParsing();
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.EOF) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "next - EOF reached, return null");
            }
            return null;
        }
        this.stats = this.nextStats;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "next");
        }
        return this.stats;
    }

    public synchronized void dispose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose");
        }
        this.pThread.stop = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dispose - told thread to stop, waking it now...");
        }
        this.notifyAll();
        this.pThread = null;
        this.parser = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose");
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isEOF() {
        return this.EOF;
    }

    protected synchronized void resumeExecution() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeExecution");
        }
        this.parsing = false;
        this.notifyAll();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resumeExecution - notified execution thread, making parsing thread wait");
        }
        while (!this.parsing && !this.EOF) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "pauseParsing - caught InterruptedException: " + interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeExecution");
        }
    }

    protected synchronized void resumeParsing() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeParsing");
        }
        if (this.EOF) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeParsing - EOF");
            }
            return;
        }
        this.parsing = true;
        this.notifyAll();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resumeParsing - notified parsing thread");
        }
        while (this.parsing) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "reset - caught InterruptedException: " + interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeParsing");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        if (ROOT.equals(string3)) {
            this.logVersion = XMLStatsLogParser.validate(attributes2.getValue(VERSION));
        } else if (NODENAME.equals(string3)) {
            this.nodeName = XMLStatsLogParser.validate(attributes2.getValue(NAME));
        } else if (SERVERNAME.equals(string3)) {
            this.serverName = XMLStatsLogParser.validate(attributes2.getValue(NAME));
        } else if (LOGSTARTTIME.equals(string3)) {
            this.startTime = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(TIME)));
        } else if (LOGENDTIME.equals(string3)) {
            this.endTime = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(TIME)));
        } else if (NUMENTRIES.equals(string3)) {
            this.numEntries = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue(NUMTOTAL)));
        } else if (CFG_ELEM_INFO.equals(string3)) {
            this.configMap = new HashMap();
            this.calcClass = XMLStatsLogParser.validate(attributes2.getValue("id"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startElement - begin parsing ConfigMap for calc " + this.calcClass);
            }
        } else if (CFG_ELEM_PARAM.equals(string3)) {
            String string4 = XMLStatsLogParser.validate(attributes2.getValue(CFG_ATTR_KEY));
            String string5 = XMLStatsLogParser.validate(attributes2.getValue(CFG_ATTR_CLASS));
            String string6 = XMLStatsLogParser.validate(attributes2.getValue(CFG_ATTR_VALUE));
            Object object = null;
            if (string5.equals("java.lang.String")) {
                object = string6;
            } else if (string5.equals("java.lang.Integer")) {
                object = new Integer(string6);
            } else if (string5.equals("java.lang.Double")) {
                object = new Double(string6);
            } else if (string5.equals("java.lang.Long")) {
                object = new Long(string6);
            } else if (string5.equals("java.lang.Boolean")) {
                object = new Boolean(string6);
            } else if (string5.equals("java.lang.Byte")) {
                object = new Byte(string6);
            } else if (string5.equals("java.lang.Character")) {
                object = new Character(string6.charAt(0));
            } else if (string5.equals("java.lang.Float")) {
                object = new Float(string6);
            } else if (string5.equals("java.lang.Short")) {
                object = new Short(string6);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startElement - encountered unknown class type: " + string5);
            }
            if (this.configMap == null) {
                Tr.debug(tc, "startElement - encoutered configParam element before configInfo element!");
                throw new SAXException("xmlFileCorruptError");
            }
            this.configMap.put(string4, object);
        } else if (SNAP.equals(string3)) {
            if (this.init) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "startElement - done with info, pausing");
                }
                this.init = false;
                this.resumeExecution();
                parserThread parserThread2 = (parserThread)Thread.currentThread();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "startElement - just woke up, checking if I should stop...");
                }
                if (parserThread2.stop) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "startElement - I should stop, throwing SAXException to exit");
                    }
                    throw new SAXException("STOP");
                }
            }
            this.statsStack.clear();
            this.statsTime = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(TIME)));
        } else if (STATS.equals(string3)) {
            String string7 = XMLStatsLogParser.validate(attributes2.getValue(STATSTYPE));
            String string8 = XMLStatsLogParser.validate(attributes2.getValue(NAME));
            String string9 = XMLStatsLogParser.validate(attributes2.getValue(TYPE));
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue(IL)));
            int n2 = 0;
            if (string9.equals(TYPE_SPMIROOT)) {
                n2 = 10;
            } else if (string9.equals(TYPE_SNODE)) {
                n2 = 11;
            } else if (string9.equals(TYPE_SSERVER)) {
                n2 = 12;
            } else if (string9.equals(TYPE_SMODULE)) {
                n2 = 13;
            } else if (string9.equals(TYPE_SSUBMODULE)) {
                n2 = 15;
            } else if (string9.equals(TYPE_SINSTANCE)) {
                n2 = 14;
            } else if (string9.equals(TYPE_SSUBINSTANCE)) {
                n2 = 16;
            } else if (string9.equals(TYPE_SCOLLECTION)) {
                n2 = 17;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startElement - parsing Stats and got invalid int type: " + n2);
            }
            StatsImpl statsImpl = StatsCreator.create(string7, string8, n2, n, this.statsTime);
            if (!this.statsStack.empty()) {
                StatsCreator.addSubStatsToParent((SPIStats)this.statsStack.peek(), statsImpl);
            }
            this.statsStack.push(statsImpl);
        } else if (STATISTIC.equals(string3)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startElement - encountered generic type Statistic, which is unsupported");
            }
        } else if (BOUNDARYSTATISTIC.equals(string3)) {
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue("id")));
            long l = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(STARTTIME)));
            long l2 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LASTSAMPLETIME)));
            long l3 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LOWERBOUND)));
            long l4 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(UPPERBOUND)));
            SPIBoundaryStatistic sPIBoundaryStatistic = StatisticCreator.createBoundaryStatistic(n);
            sPIBoundaryStatistic.set(l3, l4, l, l2);
            StatsCreator.addStatisticsToParent((SPIStats)this.statsStack.peek(), sPIBoundaryStatistic);
        } else if (RANGESTATISTIC.equals(string3)) {
            long l = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LOWWATERMARK)));
            long l5 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(HIGHWATERMARK)));
            long l6 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(CURRENT)));
            long l7 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(STARTTIME)));
            long l8 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LASTSAMPLETIME)));
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue("id")));
            double d = Double.parseDouble(XMLStatsLogParser.validate(attributes2.getValue(INTEGRAL)));
            SPIRangeStatistic sPIRangeStatistic = StatisticCreator.createRangeStatistic(n);
            sPIRangeStatistic.set(l, l5, l6, d, l7, l8);
            StatsCreator.addStatisticsToParent((SPIStats)this.statsStack.peek(), sPIRangeStatistic);
        } else if (BOUNDEDRANGESTATISTIC.equals(string3)) {
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue("id")));
            long l = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(STARTTIME)));
            long l9 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LASTSAMPLETIME)));
            long l10 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LOWERBOUND)));
            long l11 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(UPPERBOUND)));
            long l12 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LOWWATERMARK)));
            long l13 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(HIGHWATERMARK)));
            long l14 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(CURRENT)));
            double d = Double.parseDouble(XMLStatsLogParser.validate(attributes2.getValue(INTEGRAL)));
            SPIBoundedRangeStatistic sPIBoundedRangeStatistic = StatisticCreator.createBoundedRangeStatistic(n);
            sPIBoundedRangeStatistic.set(l10, l11, l12, l13, l14, d, l, l9);
            StatsCreator.addStatisticsToParent((SPIStats)this.statsStack.peek(), sPIBoundedRangeStatistic);
        } else if (COUNTSTATISTIC.equals(string3)) {
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue("id")));
            long l = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(STARTTIME)));
            long l15 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LASTSAMPLETIME)));
            long l16 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(COUNT)));
            SPICountStatistic sPICountStatistic = StatisticCreator.createCountStatistic(n);
            sPICountStatistic.set(l16, l, l15);
            StatsCreator.addStatisticsToParent((SPIStats)this.statsStack.peek(), sPICountStatistic);
        } else if (TIMESTATISTIC.equals(string3)) {
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue("id")));
            long l = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(STARTTIME)));
            long l17 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LASTSAMPLETIME)));
            long l18 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(COUNT)));
            long l19 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(MIN)));
            long l20 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(MAX)));
            long l21 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(TOTAL)));
            double d = Double.parseDouble(XMLStatsLogParser.validate(attributes2.getValue(SUMOFSQUARES)));
            SPITimeStatistic sPITimeStatistic = StatisticCreator.createTimeStatistic(n);
            sPITimeStatistic.set(l18, l19, l20, l21, d, l, l17);
            StatsCreator.addStatisticsToParent((SPIStats)this.statsStack.peek(), sPITimeStatistic);
        } else if (DOUBLESTATISTIC.equals(string3)) {
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue("id")));
            long l = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(STARTTIME)));
            long l22 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LASTSAMPLETIME)));
            double d = Double.parseDouble(XMLStatsLogParser.validate(attributes2.getValue(COUNT)));
            SPIDoubleStatistic sPIDoubleStatistic = StatisticCreator.createDoubleStatistic(n);
            sPIDoubleStatistic.set(d, l, l22);
            StatsCreator.addStatisticsToParent((SPIStats)this.statsStack.peek(), sPIDoubleStatistic);
        } else if (AVERAGESTATISTIC.equals(string3)) {
            int n = Integer.parseInt(XMLStatsLogParser.validate(attributes2.getValue("id")));
            long l = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(STARTTIME)));
            long l23 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(LASTSAMPLETIME)));
            long l24 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(COUNT)));
            long l25 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(MIN)));
            long l26 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(MAX)));
            long l27 = Long.parseLong(XMLStatsLogParser.validate(attributes2.getValue(TOTAL)));
            double d = Double.parseDouble(XMLStatsLogParser.validate(attributes2.getValue(SUMOFSQUARES)));
            SPIAverageStatistic sPIAverageStatistic = StatisticCreator.createAverageStatistic(n);
            sPIAverageStatistic.set(l24, l25, l26, l27, d, l, l23);
            StatsCreator.addStatisticsToParent((SPIStats)this.statsStack.peek(), sPIAverageStatistic);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startElement - encountered unkown element: " + string3);
            }
            throw new SAXException();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (ROOT.equals(string3)) {
            this.EOF = true;
            this.resumeExecution();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endElement - EOF");
            }
        } else if (SNAP.equals(string3)) {
            if (!this.statsStack.empty() && tc.isDebugEnabled()) {
                Tr.debug(tc, "endElement - Encountered Snapshop end tag but Stats stack not empty");
            }
            this.resumeExecution();
            parserThread parserThread2 = (parserThread)Thread.currentThread();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endElement - just woke up, checking if I should stop...");
            }
            if (parserThread2.stop) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "endElement - I should stop, throwing SAXException to exit");
                }
                throw new SAXException("STOP");
            }
        } else if (CFG_ELEM_INFO.equals(string3)) {
            CalcCreator.storePersistedCalcConfigMap(this.file, this.calcClass, this.configMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endElement - finished parsing ConfigMap for calc " + this.calcClass);
            }
            this.configMap = null;
            this.calcClass = null;
        } else if (STATS.equals(string3)) {
            this.nextStats = (SPIStats)this.statsStack.pop();
        }
    }

    private static final String validate(String string) throws SAXException {
        if (string == null) {
            throw new SAXException("xmlFileCorruptError");
        }
        return string;
    }

    protected class parserThread
    extends Thread {
        boolean stop = false;

        protected parserThread() {
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "parserThread.run");
            }
            try {
                XMLStatsLogParser.this.parser.parse(XMLStatsLogParser.this.file);
            }
            catch (SAXException sAXException) {
                if (sAXException.getMessage().equals("STOP")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "parserThread.run - stopping parsing");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "parserThread.run - caught SAXException while parsing file " + XMLStatsLogParser.this.file, sAXException);
                    }
                    XMLStatsLogParser.this.exception = new Exception("xmlFileCorruptError", sAXException);
                    XMLStatsLogParser.this.EOF = true;
                    XMLStatsLogParser.this.resumeExecution();
                }
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parserThread.run - caught IOException while opening file " + XMLStatsLogParser.this.file, iOException);
                }
                XMLStatsLogParser.this.exception = iOException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parserThread.run");
            }
        }
    }
}

