/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.timer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.exceptions.NotFoundException;
import com.ibm.ws.tpv.engine.exceptions.ServerNotFoundException;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import com.ibm.ws.tpv.engine.utils.StatsUtil;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.security.auth.Subject;

public class ServerAlarmListener
implements AlarmListener {
    public static int POLLING_FREQUENCY = 5;
    private Alarm alarm;
    private TPVEngine engine;
    private ServerBean sBean;
    private ArrayList users;
    private long lastPollMillis;
    private static TraceComponent tc = Tr.register(ServerAlarmListener.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public ServerAlarmListener(ServerBean serverBean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>", serverBean);
        }
        this.sBean = serverBean;
        this.users = new ArrayList();
        this.engine = TPVEngine.getEngine();
        this.alarm = null;
        this.lastPollMillis = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    public void alarm(Object object) {
        UserInfo userInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        Subject subject = null;
        try {
            subject = WSSubject.getRunAsSubject();
            WSSubject.setRunAsSubject((Subject)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ArrayList<UserInfo> arrayList = new ArrayList<UserInfo>();
        long l = System.currentTimeMillis();
        int n = Math.round((float)(l - this.lastPollMillis) / 1000.0f);
        this.lastPollMillis = l;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "alarm - elapsed seconds: " + n);
        }
        for (int i = 0; i < this.users.size(); ++i) {
            userInfo = (UserInfo)this.users.get(i);
            userInfo.countdown -= n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "alarm - countdown=" + userInfo.countdown + " prefs=" + userInfo.up);
            }
            if (userInfo.countdown > 2) continue;
            arrayList.add(userInfo);
            userInfo.countdown = userInfo.up.getRefreshRate();
        }
        if (arrayList.size() > 0) {
            try {
                WSStats wSStats;
                block22: {
                    wSStats = null;
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    try {
                        wSStats = (WSStats)contextManager.runAsSystem(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return ServerAlarmListener.this.engine.getCollector().getServerStats(ServerAlarmListener.this.sBean.getNode(), ServerAlarmListener.this.sBean.getServer());
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug(tc, "PrivilegedActionException in Collector.getServerStats call: " + privilegedActionException.getMessage());
                    }
                }
                WSStats wSStats2 = StatsUtil.copyStats(wSStats);
                for (int i = 0; i < arrayList.size(); ++i) {
                    long l2;
                    long l3;
                    userInfo = (UserInfo)arrayList.get(i);
                    if (wSStats2 == null) {
                        this.engine.getBuffer().dispose(userInfo.up);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "alarm - storing stats for user: " + userInfo.up);
                        }
                        this.engine.getBuffer().putServerStats(userInfo.up, wSStats2);
                    }
                    userInfo.polled();
                    long l4 = this.engine.getLastAccessTime(userInfo.up.getUserId());
                    if (l4 <= -1L || (l3 = System.currentTimeMillis() - l4) <= (l2 = (long)(2 * userInfo.up.getBufferSize() * userInfo.up.getRefreshRate() * 1000))) continue;
                    this.engine.disableServer(userInfo.up);
                }
            }
            catch (ServerNotFoundException serverNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "alarm - Caught ServerNotFoundException, server is down or PMI is disabled");
                }
                this.engine.getCollector().refreshServerInfo();
            }
            catch (NotFoundException notFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "alarm - Caught NotFoundException while inserting into buffer", notFoundException);
                }
                notFoundException.printStackTrace();
            }
        }
        if (this.users.size() > 0) {
            this.reschedule();
        }
        try {
            WSSubject.setRunAsSubject(subject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    private int findCountdown(int n, int[] nArray, int[] nArray2) {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findCountdown - refreshRate: " + n);
        }
        int n3 = -1;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == n) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "findCountdown - same refresh rate, countdown: " + nArray2[n2]);
                }
                return nArray2[n2];
            }
            if (nArray[n2] > n) {
                if (nArray[n2] % n != 0) continue;
                n3 = nArray2[n2];
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "findCountdown - mod (>) refresh rate, countdown: " + n3);
                continue;
            }
            if (n % nArray[n2] != 0) continue;
            n3 = nArray2[n2];
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "findCountdown - mod (<) refresh rate, countdown: " + n3);
        }
        if (n3 > -1) {
            while (n3 > n) {
                n3 -= n;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findCountdown - adjusted countdown: " + n3);
            }
            return n3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findCountdown - no optimal countdown, trying greedy approach");
        }
        n3 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            if (Math.abs(nArray2[n2] - n) >= Math.abs(n3 - n)) continue;
            n3 = nArray2[n2];
        }
        while (n3 > n) {
            n3 -= n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findCountdown - adjusted countdown: " + n3);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coordinatePolling(UserInfo userInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "coordinatePolling", userInfo);
        }
        if (this.users.size() == 0) {
            userInfo.countdown = userInfo.up.getRefreshRate();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "coordinatePolling - no users to coordinate with, setting exact refreshRate");
            }
            return;
        }
        ArrayList arrayList = this.users;
        synchronized (arrayList) {
            boolean bl = true;
            int[] nArray = new int[this.users.size()];
            int[] nArray2 = new int[this.users.size()];
            for (int i = 0; i < this.users.size(); ++i) {
                UserInfo userInfo2 = (UserInfo)this.users.get(i);
                nArray[i] = userInfo2.countdown;
                nArray2[i] = userInfo2.up.getRefreshRate();
                if (userInfo2.up.getRefreshRate() != userInfo.up.getRefreshRate()) continue;
                bl = false;
                userInfo.countdown = userInfo2.countdown;
            }
            if (bl) {
                userInfo.countdown = this.findCountdown(userInfo.up.getRefreshRate(), nArray2, nArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "coordinatePolling");
        }
    }

    public void addUser(UserPreferences userPreferences) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addUser", userPreferences);
        }
        try {
            object = this.engine.getCollector().getServerStats(this.sBean.getNode(), this.sBean.getServer());
            WSStats wSStats = StatsUtil.copyStats((WSStats)object);
            this.engine.getBuffer().putServerStats(userPreferences, wSStats);
        }
        catch (ServerNotFoundException serverNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addUser - Caught ServerNotFoundException, server is down or PMI is disabled");
            }
            this.engine.getCollector().refreshServerInfo();
        }
        catch (NotFoundException notFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addUser - Caught NotFoundException while inserting into buffer", notFoundException);
            }
            notFoundException.printStackTrace();
        }
        object = new UserInfo(userPreferences);
        this.coordinatePolling((UserInfo)object);
        this.users.add(object);
        if (this.alarm == null) {
            this.reschedule();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addUser");
        }
    }

    public void updateUser(UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateUser", userPreferences);
        }
        for (int i = 0; i < this.users.size(); ++i) {
            UserInfo userInfo = (UserInfo)this.users.get(i);
            if (!userInfo.up.getUserId().equals(userPreferences.getUserId())) continue;
            this.users.remove(i);
            this.coordinatePolling(userInfo);
            this.users.add(userInfo);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateUser");
        }
    }

    public void removeUser(UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUser");
        }
        for (int i = 0; i < this.users.size(); ++i) {
            UserInfo userInfo = (UserInfo)this.users.get(i);
            if (!userInfo.up.getUserId().equals(userPreferences.getUserId())) continue;
            this.users.remove(i);
            if (!tc.isEntryEnabled()) break;
            Tr.debug(tc, "removeUser - removed " + userInfo.up.getUserId());
            break;
        }
        if (this.users.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeUser - no users left, cancelling alarm");
            }
            this.alarm.cancel();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUser");
        }
    }

    public void addObserver(UserPreferences userPreferences, Observer observer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addObserver", observer);
        }
        for (int i = 0; i < this.users.size(); ++i) {
            UserInfo userInfo = (UserInfo)this.users.get(i);
            if (!userInfo.up.getUserId().equals(userPreferences.getUserId())) continue;
            userInfo.addObserver(observer);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addObserver");
        }
    }

    public void deleteObserver(UserPreferences userPreferences, Observer observer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteObserver", userPreferences);
        }
        for (int i = 0; i < this.users.size(); ++i) {
            UserInfo userInfo = (UserInfo)this.users.get(i);
            if (!userInfo.up.getUserId().equals(userPreferences.getUserId())) continue;
            userInfo.deleteObserver(observer);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteObserver");
        }
    }

    public int getUserCount() {
        return this.users.size();
    }

    private void reschedule() {
        block3: {
            if (this.alarm != null) {
                this.alarm.cancel();
            }
            try {
                Subject subject = WSSubject.getRunAsSubject();
                this.alarm = AlarmManager.createDeferrable(POLLING_FREQUENCY * 1000, this, subject);
            }
            catch (WSSecurityException wSSecurityException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "reschedule - caught WSSecurityException while rescheduling", wSSecurityException);
            }
        }
    }

    private class UserInfo
    extends Observable {
        protected UserPreferences up;
        protected int countdown;

        public UserInfo(UserPreferences userPreferences) {
            this.up = userPreferences;
            this.countdown = POLLING_FREQUENCY;
        }

        public void polled() {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

