/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.user;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.tpv.engine.TPVEngine;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.user.Registry;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import com.ibm.ws.tpv.engine.utils.ServerUserBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;

public class RegistryImpl
extends Observable
implements Registry {
    public static final String ADD = "A";
    public static final String REMOVE = "R";
    public static final String UPDATE = "U";
    private HashMap _users;
    private HashMap _nodes;
    private static TraceComponent tc = Tr.register(RegistryImpl.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public RegistryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>");
        }
        this._users = new HashMap();
        this._nodes = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    public synchronized boolean addUserPreferences(UserPreferences userPreferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addUserPreferences", userPreferences);
        }
        if (userPreferences.getViewLog()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addUserPreferences - tried to add log viewing, returning false");
            }
            return false;
        }
        boolean bl = true;
        if (this.addUserPreferencesToUsers(userPreferences)) {
            this.addUserPreferencesToNodes(userPreferences);
        } else {
            bl = false;
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addUserPreferences - Prefs added, now init buffer and alert observers", userPreferences);
            }
            try {
                TPVEngine.getEngine().getFilter().register(userPreferences);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addUserPreferences - caught Exception while registering, unregistering", exception);
                }
                this.removeUserPreferences(new ServerUserBean(userPreferences.getNodeName(), userPreferences.getServerName(), userPreferences.getUserId()));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addUserPreferences - caught Exception, returning false");
                }
                return false;
            }
            TPVEngine.getEngine().getBuffer().init(userPreferences);
            Object[] objectArray = new Object[]{ADD, userPreferences};
            this.setChanged();
            this.notifyObservers(objectArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addUserPreferences", new Boolean(bl));
        }
        return bl;
    }

    private boolean addUserPreferencesToUsers(UserPreferences userPreferences) {
        HashMap<String, UserPreferences> hashMap;
        HashMap hashMap2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addUserPreferencesToUsers", userPreferences);
        }
        if ((hashMap2 = (HashMap)this._users.get(userPreferences.getUserId())) == null) {
            hashMap2 = new HashMap();
            this._users.put(userPreferences.getUserId(), hashMap2);
        }
        if ((hashMap = (HashMap<String, UserPreferences>)hashMap2.get(userPreferences.getNodeName())) == null) {
            hashMap = new HashMap<String, UserPreferences>();
            hashMap2.put(userPreferences.getNodeName(), hashMap);
        }
        if (hashMap.containsKey(userPreferences.getServerName())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addUserPreferencesToUsers", new Boolean(false));
            }
            return false;
        }
        hashMap.put(userPreferences.getServerName(), userPreferences);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addUserPreferencesToUsers", new Boolean(true));
        }
        return true;
    }

    private void addUserPreferencesToNodes(UserPreferences userPreferences) {
        HashMap<String, UserPreferences> hashMap;
        HashMap<String, HashMap<String, UserPreferences>> hashMap2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addUserPreferencesToNodes", userPreferences);
        }
        if ((hashMap2 = (HashMap<String, HashMap<String, UserPreferences>>)this._nodes.get(userPreferences.getNodeName())) == null) {
            hashMap2 = new HashMap<String, HashMap<String, UserPreferences>>();
            this._nodes.put(userPreferences.getNodeName(), hashMap2);
        }
        if ((hashMap = (HashMap<String, UserPreferences>)hashMap2.get(userPreferences.getServerName())) == null) {
            hashMap = new HashMap<String, UserPreferences>();
            hashMap2.put(userPreferences.getServerName(), hashMap);
        }
        hashMap.put(userPreferences.getUserId(), userPreferences);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addUserPreferencesToNodes");
        }
    }

    public synchronized UserPreferences[] getAllPrefsForServer(ServerBean serverBean) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPrefsForServer", serverBean);
        }
        if ((hashMap = (HashMap)this._nodes.get(serverBean.getNode())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllPrefsForServer - servers not found");
            }
            return null;
        }
        HashMap hashMap2 = (HashMap)hashMap.get(serverBean.getServer());
        if (hashMap2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllPrefsForServer - users not found");
            }
            return null;
        }
        UserPreferences[] userPreferencesArray = new UserPreferences[hashMap2.size()];
        int n = 0;
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            userPreferencesArray[n++] = (UserPreferences)hashMap2.get(iterator.next());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPrefsForServer");
        }
        return userPreferencesArray;
    }

    public ServerBean[] getMonitoredServers(String string) {
        Object object;
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMonitoredServers", string);
        }
        if ((hashMap = (HashMap)this._users.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMonitoredServers - nodes not found");
            }
            return null;
        }
        ArrayList<ServerBean> arrayList = new ArrayList<ServerBean>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (HashMap)hashMap.get(iterator.next());
            if (object == null) continue;
            Iterator iterator2 = ((HashMap)object).keySet().iterator();
            while (iterator2.hasNext()) {
                UserPreferences userPreferences = (UserPreferences)((HashMap)object).get(iterator2.next());
                arrayList.add(new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName()));
            }
        }
        object = new ServerBean[arrayList.size()];
        arrayList.toArray((T[])object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMonitoredServers", object);
        }
        return object;
    }

    public UserPreferences getUserPreferences(ServerUserBean serverUserBean) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserPreferences", serverUserBean);
        }
        if ((hashMap = (HashMap)this._nodes.get(serverUserBean.getNode())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserPreferences - servers not found");
            }
            return null;
        }
        HashMap hashMap2 = (HashMap)hashMap.get(serverUserBean.getServer());
        if (hashMap2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserPreferences - users not found");
            }
            return null;
        }
        UserPreferences userPreferences = (UserPreferences)hashMap2.get(serverUserBean.getUserId());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserPreferences", userPreferences);
        }
        return userPreferences;
    }

    public synchronized boolean removeUserPreferences(ServerUserBean serverUserBean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUserPreferences", serverUserBean);
        }
        boolean bl = false;
        UserPreferences userPreferences = this.getUserPreferences(serverUserBean);
        if (this.removeUserPreferencesFromUsers(serverUserBean) & this.removeUserPreferencesFromNodes(serverUserBean)) {
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeUserPreferences - about to remove from filter");
        }
        TPVEngine.getEngine().getFilter().cleanup(userPreferences);
        if (bl) {
            Object[] objectArray = new Object[]{REMOVE, userPreferences};
            this.setChanged();
            this.notifyObservers(objectArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUserPreferences", new Boolean(bl));
        }
        return bl;
    }

    private boolean removeUserPreferencesFromUsers(ServerUserBean serverUserBean) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUserPreferencesFromUsers", serverUserBean);
        }
        if ((hashMap = (HashMap)this._users.get(serverUserBean.getUserId())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUserPreferencesFromUsers - nodes not found", new Boolean(false));
            }
            return false;
        }
        HashMap hashMap2 = (HashMap)hashMap.get(serverUserBean.getNode());
        if (hashMap2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUserPreferencesFromUsers - servers not found", new Boolean(false));
            }
            return false;
        }
        hashMap2.remove(serverUserBean.getServer());
        if (hashMap2.size() == 0) {
            hashMap.remove(serverUserBean.getNode());
        }
        if (hashMap.size() == 0) {
            this._users.remove(serverUserBean.getUserId());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUserPreferencesFromUsers", new Boolean(true));
        }
        return true;
    }

    private boolean removeUserPreferencesFromNodes(ServerUserBean serverUserBean) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUserPreferencesFromNodes", serverUserBean);
        }
        if ((hashMap = (HashMap)this._nodes.get(serverUserBean.getNode())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUserPreferencesFromNodes", new Boolean(false));
            }
            return false;
        }
        HashMap hashMap2 = (HashMap)hashMap.get(serverUserBean.getServer());
        if (hashMap2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUserPreferencesFromNodes", new Boolean(false));
            }
            return false;
        }
        hashMap2.remove(serverUserBean.getUserId());
        if (hashMap2.size() == 0) {
            hashMap.remove(serverUserBean.getServer());
        }
        if (hashMap.size() == 0) {
            this._nodes.remove(serverUserBean.getNode());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUserPreferencesFromNodes", new Boolean(true));
        }
        return true;
    }

    public synchronized boolean updateUserPreferences(UserPreferences userPreferences) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateUserPreferences", userPreferences);
        }
        if ((hashMap = (HashMap)this._users.get(userPreferences.getUserId())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateUserPreferences", new Boolean(false));
            }
            return false;
        }
        HashMap hashMap2 = (HashMap)hashMap.get(userPreferences.getNodeName());
        if (hashMap2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateUserPreferences", new Boolean(false));
            }
            return false;
        }
        UserPreferences userPreferences2 = (UserPreferences)hashMap2.get(userPreferences.getServerName());
        if (userPreferences2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateUserPreferences", new Boolean(false));
            }
            return false;
        }
        TPVEngine.getEngine().getBuffer().setBufferSize(userPreferences);
        userPreferences2.update(userPreferences);
        ServerUserBean serverUserBean = new ServerUserBean(userPreferences.getNodeName(), userPreferences.getServerName(), userPreferences.getUserId());
        Object[] objectArray = new Object[]{UPDATE, userPreferences};
        this.setChanged();
        this.notifyObservers(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateUserPreferences", new Boolean(true));
        }
        return true;
    }

    public synchronized String[] getAllRegisteredUsers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllRegisteredUsers");
        }
        String[] stringArray = new String[this._users.size()];
        int n = 0;
        Iterator iterator = this._users.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllRegisteredUsers", stringArray);
        }
        return stringArray;
    }

    public ServerBean[] getMonitoredServers(UserPreferences userPreferences) {
        return this.getMonitoredServers(userPreferences.getUserId());
    }

    public UserPreferences getUserPreferences(UserPreferences userPreferences) {
        ServerUserBean serverUserBean = new ServerUserBean(userPreferences.getNodeName(), userPreferences.getServerName(), userPreferences.getUserId());
        return this.getUserPreferences(serverUserBean);
    }

    public synchronized void setUserPreferences(UserPreferences userPreferences) {
        if (!this.addUserPreferences(userPreferences)) {
            this.updateUserPreferences(userPreferences);
        }
    }
}

