/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tpv.engine.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.tpv.engine.UserPreferences;
import com.ibm.ws.tpv.engine.timer.ServerAlarmListener;
import com.ibm.ws.tpv.engine.user.RegistryImpl;
import com.ibm.ws.tpv.engine.utils.ServerBean;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class ServerPollingManager
implements Observer {
    private RegistryImpl registry;
    private HashMap serverAlarms;
    private static TraceComponent tc = Tr.register(ServerPollingManager.class, "TivoliPerformanceViewer", "com.ibm.ws.tpv.engine.property.tpvengine");

    public ServerPollingManager(RegistryImpl registryImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>");
        }
        this.serverAlarms = new HashMap();
        this.registry = registryImpl;
        registryImpl.addObserver(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    public void registerForUpdates(UserPreferences userPreferences, Observer observer) {
        ServerAlarmListener serverAlarmListener;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerForUpdates", userPreferences);
        }
        ServerBean serverBean = new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerBean " + serverBean.getNode() + " : " + serverBean.getServer());
        }
        if ((serverAlarmListener = (ServerAlarmListener)this.serverAlarms.get(serverBean)) != null) {
            serverAlarmListener.addObserver(userPreferences, observer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerForUpdates");
        }
    }

    public void unregisterForUpdates(UserPreferences userPreferences, Observer observer) {
        ServerBean serverBean;
        ServerAlarmListener serverAlarmListener;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterForUpdates", userPreferences);
        }
        if ((serverAlarmListener = (ServerAlarmListener)this.serverAlarms.get(serverBean = new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName()))) != null) {
            serverAlarmListener.deleteObserver(userPreferences, observer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterForUpdates");
        }
    }

    public void update(Observable observable, Object object) {
        ServerAlarmListener serverAlarmListener;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update");
        }
        String string = (String)((Object[])object)[0];
        UserPreferences userPreferences = (UserPreferences)((Object[])object)[1];
        ServerBean serverBean = new ServerBean(userPreferences.getNodeName(), userPreferences.getServerName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "update - action is: " + string + " UserPrefs is: " + userPreferences);
        }
        if ((serverAlarmListener = (ServerAlarmListener)this.serverAlarms.get(serverBean)) == null) {
            serverAlarmListener = new ServerAlarmListener(serverBean);
            this.serverAlarms.put(serverBean, serverAlarmListener);
        }
        if (string.equals("A")) {
            serverAlarmListener.addUser(userPreferences);
        } else if (string.equals("R")) {
            serverAlarmListener.removeUser(userPreferences);
            if (serverAlarmListener.getUserCount() == 0) {
                this.serverAlarms.remove(serverBean);
            }
        } else if (string.equals("U")) {
            serverAlarmListener.updateUser(userPreferences);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }
}

