/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.UDPChannelConfiguration;
import com.ibm.ws.udp.channel.impl.UDPFilterList;
import java.net.Inet6Address;
import java.net.InetAddress;

public class AccessLists {
    protected UDPFilterList excludeAccess = null;
    protected UDPFilterList includeAccess = null;
    private static final TraceComponent tc = Tr.register((Class)AccessLists.class, (String)"WebSphere UDP Channel", (String)"com.ibm.ws.udp.channel.resources.udpchannel");

    public AccessLists(UDPFilterList uDPFilterList, UDPFilterList uDPFilterList2) {
        this.excludeAccess = uDPFilterList;
        this.includeAccess = uDPFilterList2;
    }

    protected static AccessLists getInstance(UDPChannelConfiguration uDPChannelConfiguration) {
        AccessLists accessLists = null;
        boolean bl = false;
        UDPFilterList uDPFilterList = null;
        UDPFilterList uDPFilterList2 = null;
        String[] stringArray = uDPChannelConfiguration.getAddressExcludeList();
        uDPFilterList = new UDPFilterList();
        if (stringArray != null) {
            uDPFilterList.buildData(stringArray, false);
            uDPFilterList.setActive(true);
            bl = true;
        }
        String[] stringArray2 = uDPChannelConfiguration.getAddressIncludeList();
        uDPFilterList2 = new UDPFilterList();
        if (stringArray2 != null && !stringArray2.equals("")) {
            uDPFilterList2.buildData(stringArray2, false);
            uDPFilterList2.setActive(true);
            bl = true;
        }
        if (bl) {
            accessLists = new AccessLists(uDPFilterList, uDPFilterList2);
        }
        return accessLists;
    }

    public boolean accessDenied(InetAddress inetAddress) {
        if (this.includeAccess.getActive()) {
            boolean bl = false;
            if (inetAddress instanceof Inet6Address) {
                if (this.includeAccess.findInList6(inetAddress.getAddress())) {
                    bl = true;
                }
            } else if (this.includeAccess.findInList(inetAddress.getAddress())) {
                bl = true;
            }
            if (!bl) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Address and host name not in include list, address: " + inetAddress.getHostAddress() + " host name: " + inetAddress.getHostName()));
                }
                return true;
            }
        }
        if (this.excludeAccess.getActive()) {
            if (inetAddress instanceof Inet6Address) {
                if (this.excludeAccess.findInList6(inetAddress.getAddress())) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Address (IPv6) in exclude list, address: " + inetAddress.getHostAddress()));
                    }
                    return true;
                }
            } else if (this.excludeAccess.findInList(inetAddress.getAddress())) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Address in exclude list, address: " + inetAddress.getHostAddress()));
                }
                return true;
            }
        }
        return false;
    }
}

