/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import java.nio.ByteBuffer;

public class BufferDump {
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private static char convertHex(int n) {
        return (char)HEX_BYTES[n & 0xF];
    }

    public static String getHexDump(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.flip();
        int n3 = byteBuffer.limit();
        byte[] byArray = new byte[n3];
        byteBuffer.get(byArray);
        byteBuffer.limit(n2);
        byteBuffer.position(n);
        return BufferDump.getHexDump(byArray, n3);
    }

    public static String getHexDump(byte[] byArray, int n) {
        if (null == byArray || 0 > n) {
            return null;
        }
        if (byArray.length < n) {
            n = byArray.length;
        }
        int n2 = n / 16 + (n % 16 > 0 ? 1 : 0);
        StringBuffer stringBuffer = new StringBuffer(73 * n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer = BufferDump.formatLineId(stringBuffer, n3);
            stringBuffer.append(": ");
            stringBuffer = BufferDump.formatHexData(stringBuffer, byArray, n3);
            stringBuffer.append("  ");
            stringBuffer = BufferDump.formatHexData(stringBuffer, byArray, n3 + 8);
            stringBuffer.append("  ");
            stringBuffer = BufferDump.formatTextData(stringBuffer, byArray, n3);
            stringBuffer.append('\n');
            ++n4;
            n3 += 16;
        }
        return stringBuffer.toString();
    }

    private static StringBuffer formatLineId(StringBuffer stringBuffer, int n) {
        char[] cArray = new char[4];
        for (int i = 3; i >= 0; --i) {
            cArray[i] = (char)HEX_BYTES[n % 16 & 0xF];
            n >>= 4;
        }
        return stringBuffer.append(cArray);
    }

    private static StringBuffer formatHexData(StringBuffer stringBuffer, byte[] byArray, int n) {
        int n2 = n + 8;
        if (n >= byArray.length) {
            stringBuffer.append("                       ");
            return stringBuffer;
        }
        stringBuffer.append(BufferDump.convertHex(byArray[n] / 16));
        stringBuffer.append(BufferDump.convertHex(byArray[n] % 16));
        ++n;
        while (n < n2) {
            if (n >= byArray.length) {
                stringBuffer.append("   ");
            } else {
                stringBuffer.append(' ');
                stringBuffer.append(BufferDump.convertHex(byArray[n] / 16));
                stringBuffer.append(BufferDump.convertHex(byArray[n] % 16));
            }
            ++n;
        }
        return stringBuffer;
    }

    private static StringBuffer formatTextData(StringBuffer stringBuffer, byte[] byArray, int n) {
        int n2 = n + 16;
        while (n < n2) {
            if (n >= byArray.length) {
                stringBuffer.append(" ");
            } else if (Character.isLetterOrDigit(byArray[n])) {
                stringBuffer.append((char)byArray[n]);
            } else {
                stringBuffer.append('.');
            }
            ++n;
        }
        return stringBuffer;
    }
}

