/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class CumulativeLogger {
    private Timer timer = null;
    private static int lbLoggingThreadInterval = 10000;
    private Map lookupFailureTable = new HashMap();
    private boolean timerStarted = false;
    static final TraceComponent tc = Tr.register(CumulativeLogger.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");
    private static CumulativeLogger loggerInstance = null;

    CumulativeLogger() {
        this.timer = new Timer();
    }

    private static CumulativeLogger getLoggerInstance() {
        if (loggerInstance == null) {
            loggerInstance = new CumulativeLogger();
        }
        return loggerInstance;
    }

    private void startTimer() {
        if (!this.timerStarted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting LoggingTimer.");
            }
            this.timer.schedule((TimerTask)new LoggingTimerTask(), 30000L, (long)lbLoggingThreadInterval);
            this.timerStarted = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NOT Starting LoggingTimer because it was already started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _logLookupFailure(String string) {
        Map map = this.lookupFailureTable;
        synchronized (map) {
            if (this.lookupFailureTable.size() < 5) {
                LookupFailure lookupFailure;
                if (!this.timerStarted) {
                    this.startTimer();
                }
                if ((lookupFailure = (LookupFailure)this.lookupFailureTable.get(string)) == null) {
                    lookupFailure = new LookupFailure(string);
                    this.lookupFailureTable.put(string, lookupFailure);
                }
                lookupFailure.incrementCount();
            }
        }
    }

    public static void logLookupFailure(String string) {
        CumulativeLogger.getLoggerInstance()._logLookupFailure(string);
    }

    class LoggingTimerTask
    extends TimerTask {
        LoggingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            Map map = CumulativeLogger.this.lookupFailureTable;
            synchronized (map) {
                Set set = CumulativeLogger.this.lookupFailureTable.keySet();
                if (set != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        LookupFailure lookupFailure = (LookupFailure)CumulativeLogger.this.lookupFailureTable.get((String)iterator.next());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "LoggingTimerTask.run() adding " + lookupFailure.getServerName() + " to removal list.");
                        }
                        if (!tc.isWarningEnabled()) continue;
                        Tr.warning(tc, "CWUDP0006I", new Object[]{lookupFailure.getServerName(), Integer.toString(lookupFailure.getCount())});
                    }
                    CumulativeLogger.this.lookupFailureTable.clear();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stopping LoggingTimer.");
                    }
                    CumulativeLogger.this.timer.cancel();
                    CumulativeLogger.this.timerStarted = false;
                }
            }
        }
    }

    private class LookupFailure {
        private String serverName = null;
        private int count = 0;

        LookupFailure(String string) {
            this.serverName = string;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int n) {
            this.count = n;
        }

        public void incrementCount() {
            ++this.count;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

