/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.UDPBufferImpl;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.udp.channel.UDPBuffer;
import java.net.SocketAddress;

public class UDPBufferFactory {
    private static TraceComponent tc = Tr.register(UDPBufferFactory.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");
    private static UDPBufferFactory ofInstance = null;
    private static final int OBJ_SIZE = 100;
    private static final ObjectPool udpBufferObjectPool = new ObjectPool("UDPBuffer", 100);

    public static synchronized UDPBufferFactory getRef() {
        if (null == ofInstance) {
            ofInstance = new UDPBufferFactory();
        }
        return ofInstance;
    }

    public static synchronized UDPBuffer getUDPBuffer() {
        return UDPBufferFactory.getRef().getUDPBufferImpl();
    }

    public static synchronized UDPBuffer getUDPBuffer(WsByteBuffer wsByteBuffer, SocketAddress socketAddress) {
        UDPBufferImpl uDPBufferImpl = (UDPBufferImpl)UDPBufferFactory.getRef().getUDPBufferImpl();
        uDPBufferImpl.set(wsByteBuffer, socketAddress);
        return uDPBufferImpl;
    }

    protected synchronized UDPBuffer getUDPBufferImpl() {
        UDPBuffer uDPBuffer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UDPBufferFactory:getObject: entry: id=" + this.hashCode());
        }
        if ((uDPBuffer = (UDPBuffer)udpBufferObjectPool.remove()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UDPBufferFactory:allocating object");
            }
            uDPBuffer = new UDPBufferImpl(this);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "UDPBufferFactory:object removed from object pool");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UDPBufferFactory:getObject: exit: id=" + this.hashCode());
        }
        return uDPBuffer;
    }

    protected synchronized void release(UDPBuffer uDPBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UDPBufferFactory: releaseObject: entry: id=" + this.hashCode());
        }
        UDPBufferImpl uDPBufferImpl = (UDPBufferImpl)uDPBuffer;
        uDPBufferImpl.clear();
        udpBufferObjectPool.add(uDPBuffer);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "UDPBufferFactory:releaseObject added object to object pool");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UDPBufferFactory: releaseObject: exit: id=" + this.hashCode());
        }
    }
}

