/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.AccessLists;
import com.ibm.ws.udp.channel.impl.UDPChannelConfiguration;
import com.ibm.ws.udp.channel.impl.UDPConnLink;
import com.ibm.ws.udp.channel.impl.UDPNetworkLayer;
import com.ibm.ws.udp.channel.impl.WorkQueueManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.OutboundChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.udp.channel.UDPContext;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.LinkedList;

public class UDPChannel
implements OutboundChannel,
InboundChannel {
    private static final Class appSideClass = UDPContext.class;
    private WorkQueueManager workQueueManager;
    private UDPChannelConfiguration udpChannelConfig;
    private String channelName;
    private String externalName;
    private DiscriminationProcess discriminationProcess;
    private boolean stoppedFlag;
    private String displayableHostName;
    private LinkedList inUse;
    private ThreadPool threadPool;
    private ChannelFramework channelFramework;
    private UDPNetworkLayer inboundNetworkLayer;
    private AccessLists alists;
    private static PlatformHelper helper = null;
    static final TraceComponent tc = Tr.register(UDPChannel.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    UDPChannel(ChannelData channelData, UDPChannelConfiguration uDPChannelConfiguration, WorkQueueManager workQueueManager, ThreadPool threadPool) throws ChannelException {
        block5: {
            this.workQueueManager = null;
            this.udpChannelConfig = null;
            this.channelName = null;
            this.externalName = null;
            this.discriminationProcess = null;
            this.stoppedFlag = true;
            this.displayableHostName = null;
            this.inUse = new LinkedList();
            this.channelFramework = null;
            this.inboundNetworkLayer = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UDPChannel");
            }
            this.udpChannelConfig = uDPChannelConfiguration;
            this.workQueueManager = workQueueManager;
            this.threadPool = threadPool;
            this.channelFramework = channelData.getChannelFramework();
            workQueueManager.addRef();
            this.channelName = channelData.getName();
            this.externalName = uDPChannelConfiguration.getExternalName();
            this.alists = AccessLists.getInstance(uDPChannelConfiguration);
            if (helper == null) {
                try {
                    helper = PlatformHelperFactory.getPlatformHelper();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Unable to determine local OS + ", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UDPChannel");
        }
    }

    public Class getDeviceAddress() {
        throw new IllegalStateException("Not implemented and never will be");
    }

    public Class[] getApplicationAddress() {
        Class[] classArray = new Class[]{UDPContext.class};
        return classArray;
    }

    public Discriminator getDiscriminator() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDiscriminator should not be called in UDPChannel");
        }
        return null;
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.discriminationProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess discriminationProcess) {
        this.discriminationProcess = discriminationProcess;
    }

    public Class getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionLink");
        }
        UDPConnLink uDPConnLink = new UDPConnLink(this.workQueueManager, virtualConnection, this, this.udpChannelConfig, this.threadPool);
        LinkedList linkedList = this.inUse;
        synchronized (linkedList) {
            this.inUse.add(uDPConnLink);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "obtained connlink: " + uDPConnLink.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionLink");
        }
        return uDPConnLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnLink(UDPConnLink uDPConnLink) {
        LinkedList linkedList = this.inUse;
        synchronized (linkedList) {
            this.inUse.remove(uDPConnLink);
        }
    }

    public void start() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.stoppedFlag) {
            this.stoppedFlag = false;
            if (this.udpChannelConfig.isInboundChannel()) {
                this.inboundNetworkLayer = new UDPNetworkLayer(this, this.workQueueManager, this.udpChannelConfig.getHostname(), this.udpChannelConfig.getPort());
                try {
                    this.inboundNetworkLayer.initDatagramSocket(null);
                }
                catch (IOException iOException) {
                    this.stoppedFlag = true;
                    throw new RetryableChannelException((Throwable)iOException);
                }
                String string = "IPv4";
                if (this.inboundNetworkLayer.getDatagramSocket().getInetAddress() instanceof Inet6Address) {
                    string = "IPv6";
                }
                this.displayableHostName = this.udpChannelConfig.getHostname() == null ? "*  (" + string + ")" : this.inboundNetworkLayer.getDatagramSocket().getLocalAddress().getHostName() + "  (" + string + ": " + this.inboundNetworkLayer.getDatagramSocket().getLocalAddress().getHostAddress() + ")";
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "CWUDP0001I", new Object[]{this.externalName, this.displayableHostName, String.valueOf(this.inboundNetworkLayer.getListenPort())});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop(long l) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop " + l);
        }
        if (l == 0L) {
            block7: {
                this.stoppedFlag = true;
                if (this.udpChannelConfig.isInboundChannel()) {
                    try {
                        if (tc.isInfoEnabled()) {
                            Tr.info(tc, "CWUDP0002I", new Object[]{this.externalName, this.displayableHostName, String.valueOf(this.udpChannelConfig.getPort())});
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug(tc, "Got exception auditing UDP Channel Stop: " + exception);
                    }
                }
            }
            this.destroyConnLinks();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void init() throws ChannelException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "UDP Channel: " + this.externalName + " listening port: " + String.valueOf(this.udpChannelConfig.getPort()));
        }
    }

    public void destroy() throws ChannelException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "destroy");
            }
            try {
                this.workQueueManager.shutdown();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught IOException while trying to shutdown work queue manager " + iOException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
    }

    public String getName() {
        return this.channelName;
    }

    public Class getApplicationInterface() {
        return appSideClass;
    }

    public Class getDeviceInterface() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ChannelData channelData) {
        UDPChannel uDPChannel = this;
        synchronized (uDPChannel) {
            block5: {
                try {
                    this.udpChannelConfig.setValues(channelData);
                }
                catch (ChannelException channelException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Caught ChannelException while calling udpChannelConfig.setValues:" + channelException.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnLinks() {
        LinkedList linkedList = this.inUse;
        synchronized (linkedList) {
            int n = this.inUse.size();
            for (int i = 0; i < n; ++i) {
                UDPConnLink uDPConnLink = (UDPConnLink)this.inUse.removeFirst();
                uDPConnLink.destroy(null);
            }
        }
    }

    protected UDPChannelConfiguration getConfig() {
        return this.udpChannelConfig;
    }

    public boolean verifySender(InetAddress inetAddress) {
        boolean bl = true;
        if (this.alists != null) {
            bl = !this.alists.accessDenied(inetAddress);
        }
        return bl;
    }
}

