/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.UDPChannelFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class UDPChannelConfiguration {
    private static int DEFAULT_READ_BUFFER_SIZE = 1024000;
    private static PlatformHelper helper = null;
    private ChannelData channelData;
    private boolean inboundChannel;
    private Map channelProperties;
    private String externalName;
    private String hostname;
    private int port;
    private int sendBufferSize;
    private int receiveBufferSize;
    private int channelReceiveBufferSize;
    private boolean autoCreateConnLink;
    private String[] addressExcludeList;
    private String[] addressIncludeList;
    static final TraceComponent tc = Tr.register(UDPChannelFactory.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    UDPChannelConfiguration() {
        block6: {
            this.inboundChannel = true;
            this.channelProperties = null;
            this.externalName = null;
            this.hostname = null;
            this.port = 0;
            this.sendBufferSize = 0;
            this.receiveBufferSize = 0;
            this.channelReceiveBufferSize = 65535;
            this.autoCreateConnLink = false;
            this.addressExcludeList = null;
            this.addressIncludeList = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UDPChannelConfiguration");
            }
            if (helper == null) {
                try {
                    helper = PlatformHelperFactory.getPlatformHelper();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Unable to determine local OS + ", exception);
                }
            }
        }
        if (!helper.isOS400()) {
            this.sendBufferSize = DEFAULT_READ_BUFFER_SIZE;
            this.receiveBufferSize = DEFAULT_READ_BUFFER_SIZE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UDPChannelConfiguration");
        }
    }

    void setValues(ChannelData channelData) throws ChannelException {
        this.setInboundChannel(this.channelData.isInbound());
        this.setChannelProperties(this.channelData.getPropertyBag());
        this.setExternalName(this.channelData.getExternalName());
        if (this.getChannelProperties() == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "UDPChannelConfiguration object constructed with null properties");
            }
            throw new ChannelException("UDPChannelConfiguration constructed with null properties");
        }
        this.setValues(this.getChannelProperties());
    }

    void setValues(Map map) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValues");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key set size: " + map.keySet().size());
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Key data being grabbed: " + string);
            }
            try {
                Object v;
                if (this.isInboundChannel()) {
                    if (string.equalsIgnoreCase("hostname")) {
                        this.setHostname((String)this.getChannelProperties().get(string));
                        continue;
                    }
                    if (string.equalsIgnoreCase("port")) {
                        this.setPort(Integer.valueOf((String)this.getChannelProperties().get(string)));
                        continue;
                    }
                    if (string.equalsIgnoreCase("endPointName")) continue;
                }
                if (string.equalsIgnoreCase("sendBufferSizeSocket")) {
                    this.setSendBufferSize(Integer.valueOf((String)this.getChannelProperties().get(string)));
                    continue;
                }
                if (string.equalsIgnoreCase("receiveBufferSizeSocket")) {
                    this.setReceiveBufferSize(Integer.valueOf((String)this.getChannelProperties().get(string)));
                    continue;
                }
                if (string.equalsIgnoreCase("receiveBufferSizeChannel")) {
                    this.setChannelReceiveBufferSize(Integer.valueOf((String)this.getChannelProperties().get(string)));
                    continue;
                }
                if (string.equalsIgnoreCase("autoCreateConnLink")) {
                    this.setAutoCreateConnLink(Boolean.valueOf((String)this.getChannelProperties().get(string)));
                    continue;
                }
                if (string.equalsIgnoreCase("addressExcludeList")) {
                    v = this.channelProperties.get(string);
                    if (v instanceof String) {
                        this.addressExcludeList = this.convertToArray((String)v);
                        continue;
                    }
                    this.addressExcludeList = (String[])v;
                    continue;
                }
                if (string.equalsIgnoreCase("addressIncludeList")) {
                    v = this.channelProperties.get(string);
                    if (v instanceof String) {
                        this.addressIncludeList = this.convertToArray((String)v);
                        continue;
                    }
                    this.addressIncludeList = (String[])v;
                    continue;
                }
                if (string.equalsIgnoreCase("chainData")) continue;
                v = this.getChannelProperties().get(string);
                if (v instanceof String) {
                    Tr.warning(tc, "CWUDP0003W", new Object[]{this.externalName, string, v});
                    continue;
                }
                Tr.warning(tc, "CWUDP0003W", new Object[]{this.externalName, string, ""});
            }
            catch (NumberFormatException numberFormatException) {
                ChannelException channelException = new ChannelException("UDP Channel Caught a NumberFormatException processing property, Channel Name: " + this.externalName + " Property name: " + string + " value: " + (String)this.channelProperties.get(string), (Throwable)numberFormatException);
                throw channelException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValues");
        }
    }

    private String[] convertToArray(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n != n3) {
            n2 = string.indexOf(",", n);
            if (n2 > n) {
                string2 = string.substring(n, n2);
                string2 = string2.trim();
                arrayList.add(string2);
            } else if (n2 != n) {
                string2 = string.substring(n);
                string2 = string2.trim();
                arrayList.add(string2);
            }
            if (n2 == -1) break;
            n = n2 + 1;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void outputConfigToTrace() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config parameters for UDP Channel: " + this.getChannelData().getExternalName());
            if (this.isInboundChannel()) {
                Tr.debug(tc, "IsInboundChannel: true");
                Tr.debug(tc, "hostname: " + this.getHostname());
                Tr.debug(tc, "port: " + this.getPort());
            } else {
                Tr.debug(tc, "IsInboundChannel: false");
            }
            Tr.debug(tc, "receiveBufferSizeSocket: " + this.getReceiveBufferSize());
            Tr.debug(tc, "receiveBufferSizeChannel: " + this.getChannelReceiveBufferSize());
            Tr.debug(tc, "sendBufferSizeSocket: " + this.getSendBufferSize());
        }
    }

    protected void setHostname(String string) {
        this.hostname = string;
    }

    public ChannelData getChannelData() {
        return this.channelData;
    }

    public Map getChannelProperties() {
        return this.channelProperties;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isInboundChannel() {
        return this.inboundChannel;
    }

    public void setChannelData(ChannelData channelData) {
        this.channelData = channelData;
    }

    public void setChannelProperties(Map map) {
        this.channelProperties = map;
    }

    public void setExternalName(String string) {
        this.externalName = string;
    }

    public void setInboundChannel(boolean bl) {
        this.inboundChannel = bl;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    public void setSendBufferSize(int n) {
        this.sendBufferSize = n;
    }

    public int getChannelReceiveBufferSize() {
        return this.channelReceiveBufferSize;
    }

    public void setChannelReceiveBufferSize(int n) {
        this.channelReceiveBufferSize = n;
        if (n < 0 || n > 65535) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel Receive buffer size not within Limits: " + n + " setting to default: " + 65535);
            }
            this.channelReceiveBufferSize = 65535;
        }
    }

    public void setAutoCreateConnLink(boolean bl) {
        this.autoCreateConnLink = bl;
    }

    public boolean getAutoCreateConnLink() {
        return this.autoCreateConnLink;
    }

    protected String[] getAddressExcludeList() {
        return this.addressExcludeList;
    }

    protected String[] getAddressIncludeList() {
        return this.addressIncludeList;
    }
}

