/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.udp.channel.impl.UDPChannel;
import com.ibm.ws.udp.channel.impl.UDPChannelConfiguration;
import com.ibm.ws.udp.channel.impl.UDPChannelFactoryConfiguration;
import com.ibm.ws.udp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.base.ConnectorChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.udp.channel.UDPContext;
import java.io.IOException;

public class UDPChannelFactory
extends ConnectorChannelFactory {
    private Class appSideClass = null;
    private WsByteBufferPoolManager wsByteBufferManager = null;
    private ChannelFramework channelFramework = null;
    protected UDPChannelFactoryConfiguration factoryConfig = null;
    protected ThreadPool threadPool = null;
    private WorkQueueManager workQueueManager = null;
    private VirtualConnectionFactory vcFactory = null;
    private boolean autoCreateConnLink = false;
    static final TraceComponent tc = Tr.register(UDPChannelFactory.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    public UDPChannelFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UDPChannelFactory");
        }
        Class clazz = this.appSideClass = UDPContext.class;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UDPChannelFactory");
        }
    }

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createChannel");
        }
        UDPChannelConfiguration uDPChannelConfiguration = new UDPChannelConfiguration();
        uDPChannelConfiguration.setChannelData(channelData);
        uDPChannelConfiguration.setValues(channelData);
        if (tc.isDebugEnabled()) {
            uDPChannelConfiguration.outputConfigToTrace();
        }
        this.autoCreateConnLink = uDPChannelConfiguration.getAutoCreateConnLink();
        UDPChannel uDPChannel = null;
        try {
            uDPChannel = new UDPChannel(channelData, uDPChannelConfiguration, this.getWorkQueueManager(), this.getThreadPool());
        }
        catch (IOException iOException) {
            ChannelException channelException = new ChannelException("Unable to start the UDP ChannelFactory", (Throwable)iOException);
            throw channelException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createChannel");
        }
        return uDPChannel;
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.factoryConfig = new UDPChannelFactoryConfiguration((com.ibm.websphere.channel.framework.ChannelFactoryData)channelFactoryData);
        this.wsByteBufferManager = WsByteBufferPoolManagerImpl.getRef();
        this.channelFramework = channelFactoryData.getChannelFramework();
        this.vcFactory = this.channelFramework.getInboundVCFactory();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void destroy() {
    }

    public Class getApplicationInterface() {
        return this.appSideClass;
    }

    private WorkQueueManager getWorkQueueManager() throws IOException {
        WorkQueueManager workQueueManager = null;
        if (this.factoryConfig.isUniqueWorkerThreads()) {
            workQueueManager = new WorkQueueManager(this.wsByteBufferManager, this.vcFactory, this.autoCreateConnLink, this.getThreadPool());
        } else {
            if (this.workQueueManager == null) {
                this.workQueueManager = new WorkQueueManager(this.wsByteBufferManager, this.vcFactory, this.autoCreateConnLink, this.getThreadPool());
            }
            workQueueManager = this.workQueueManager;
        }
        return workQueueManager;
    }

    protected ThreadPool getThreadPool() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "UDPChannelFactory:getThreadPool called");
        }
        if (this.threadPool == null) {
            String string = this.factoryConfig.getThreadPoolName();
            if (string == null) {
                string = "UDP Thread Pool";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread Pool name is null, using [UDP Thread Pool]");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using thread pool [" + string + "]");
            }
            ThreadPoolRepository threadPoolRepository = ThreadPoolRepositoryManager.getThreadPoolRepository();
            try {
                this.threadPool = threadPoolRepository.createThreadPool(string, 1, 3);
            }
            catch (ThreadPoolAlreadyKnownException threadPoolAlreadyKnownException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread pool already exists.  [" + string + "]. Just getting it now.");
                }
                this.threadPool = threadPoolRepository.getThreadPool(string);
            }
        }
        return this.threadPool;
    }
}

