/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import java.util.Iterator;
import java.util.Map;

public class UDPChannelFactoryConfiguration {
    private ChannelFactoryData channelFactoryData = null;
    private Map channelFactoryProperties = null;
    private boolean uniqueWorkerThreads = true;
    private static String threadPoolName = null;
    private static boolean threadPoolEnabled = true;
    static final TraceComponent tc = Tr.register(UDPChannelFactoryConfiguration.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    UDPChannelFactoryConfiguration(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UDPChannelFactoryConfiguration");
        }
        this.setChannelFactoryData(channelFactoryData);
        this.setValues(this.getChannelFactoryData());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UDPChannelFactoryConfiguration");
        }
    }

    private void setValues(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        this.setChannelFactoryProperties(channelFactoryData.getProperties());
        Iterator iterator = this.getChannelFactoryProperties().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                if (string.equalsIgnoreCase("uniqueWorkerThreads")) {
                    this.setUniqueWorkerThreads(Boolean.valueOf((String)this.getChannelFactoryProperties().get(string)));
                    continue;
                }
                if (string.equalsIgnoreCase("threadPoolName")) {
                    threadPoolName = (String)this.getChannelFactoryProperties().get(string);
                    continue;
                }
                if (!string.equalsIgnoreCase("threadPoolEnabled")) continue;
                String string2 = (String)this.getChannelFactoryProperties().get(string);
                if (string2.equalsIgnoreCase("disabled")) {
                    threadPoolEnabled = false;
                    continue;
                }
                if (!string2.equalsIgnoreCase("enabled")) continue;
                threadPoolEnabled = true;
            }
            catch (Exception exception) {
                ChannelFactoryException channelFactoryException = new ChannelFactoryException("UDP Channel Factory Caught an Exception processing property:  Property name: " + string + " value: " + (String)this.getChannelFactoryProperties().get(string), (Throwable)exception);
                throw channelFactoryException;
            }
        }
    }

    public ChannelFactoryData getChannelFactoryData() {
        return this.channelFactoryData;
    }

    public void setChannelFactoryData(ChannelFactoryData channelFactoryData) {
        this.channelFactoryData = channelFactoryData;
    }

    public void setChannelFactoryProperties(Map map) {
        this.channelFactoryProperties = map;
    }

    public Map getChannelFactoryProperties() {
        return this.channelFactoryProperties;
    }

    public boolean isUniqueWorkerThreads() {
        return this.uniqueWorkerThreads;
    }

    public void setUniqueWorkerThreads(boolean bl) {
        this.uniqueWorkerThreads = bl;
    }

    public String getThreadPoolName() {
        return threadPoolName;
    }

    public boolean isThreadPoolEnabled() {
        return threadPoolEnabled;
    }
}

