/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.UDPChannel;
import com.ibm.ws.udp.channel.impl.UDPChannelConfiguration;
import com.ibm.ws.udp.channel.impl.UDPNetworkLayer;
import com.ibm.ws.udp.channel.impl.UDPReadRequestContextImpl;
import com.ibm.ws.udp.channel.impl.UDPWriteRequestContextImpl;
import com.ibm.ws.udp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.OutboundConnectionLink;
import com.ibm.wsspi.channel.base.OutboundConnectorLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.udp.channel.UDPContext;
import com.ibm.wsspi.udp.channel.UDPReadRequestContext;
import com.ibm.wsspi.udp.channel.UDPRequestContext;
import com.ibm.wsspi.udp.channel.UDPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public class UDPConnLink
extends OutboundConnectorLink
implements InboundConnectionLink,
OutboundConnectionLink,
UDPContext {
    private WorkQueueManager workQueueMgr = null;
    private UDPChannel udpChannel = null;
    private UDPChannelConfiguration cfg = null;
    private UDPNetworkLayer udpNetworkLayer = null;
    private UDPReadRequestContextImpl reader = null;
    private UDPWriteRequestContextImpl writer = null;
    private ThreadPool threadPool = null;
    static final TraceComponent tc = Tr.register(UDPConnLink.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    public UDPConnLink(WorkQueueManager workQueueManager, VirtualConnection virtualConnection, UDPChannel uDPChannel, UDPChannelConfiguration uDPChannelConfiguration, ThreadPool threadPool) {
        this.init(virtualConnection);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UDPConnLink");
        }
        this.workQueueMgr = workQueueManager;
        this.udpChannel = uDPChannel;
        this.cfg = uDPChannelConfiguration;
        this.threadPool = threadPool;
        this.reader = new UDPReadRequestContextImpl(this, this.workQueueMgr);
        this.writer = new UDPWriteRequestContextImpl(this, this.workQueueMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UDPConnLink");
        }
    }

    public void connectAsynch(Object object) {
        Object object2;
        String string = "*";
        int n = 0;
        Map map = this.vc.getStateMap();
        if (map != null) {
            object2 = (String)map.get("receiveBufferSizeChannel");
            if (object2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "vcStateMap has receiveBufferSizeChannel setting in Channel config.");
                }
                this.cfg.setChannelReceiveBufferSize(Integer.parseInt((String)object2));
            }
            if ((object2 = (String)map.get("receiveBufferSizeSocket")) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "vcStateMap has receiveBufferSizeSocket setting in Channel config.");
                }
                this.cfg.setReceiveBufferSize(Integer.parseInt((String)object2));
            }
            if ((object2 = (String)map.get("sendBufferSizeSocket")) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "vcStateMap has sendBufferSizeSocket setting in Channel config.");
                }
                this.cfg.setSendBufferSize(Integer.parseInt((String)object2));
            }
        }
        if (object != null) {
            object2 = (UDPRequestContext)object;
            string = object2.getLocalAddress().getHostName();
            n = object2.getLocalAddress().getPort();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connectAsynch called with local address: " + string + " local port: " + n);
            }
        }
        this.udpNetworkLayer = new UDPNetworkLayer(this.udpChannel, this.workQueueMgr, string, n);
        try {
            this.udpNetworkLayer.initDatagramSocket(this.getVirtualConnection());
            this.udpNetworkLayer.setConnLink(this);
            this.getApplicationCallback().ready(this.vc);
        }
        catch (IOException iOException) {
            this.getApplicationCallback().destroy((Exception)iOException);
        }
    }

    public void connect(Object object) throws Exception {
        this.connectAsynch(object);
    }

    public Object getChannelAccessor() {
        return this;
    }

    public void ready(VirtualConnection virtualConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "This should not be called because the UDPConnLink is always ready since it is the first in the chain.");
        }
    }

    public UDPReadRequestContext getReadInterface() {
        return this.reader;
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        if (this.udpNetworkLayer != null) {
            inetAddress = this.udpNetworkLayer.getDatagramSocket().getLocalAddress();
            if (tc.isDebugEnabled() && inetAddress == null) {
                Tr.debug(tc, "getLocalSocketAddress == null");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalAddress called when udpNetworkLayer == null");
        }
        return inetAddress;
    }

    public int getLocalPort() {
        int n = 0;
        if (this.udpNetworkLayer != null) {
            n = this.udpNetworkLayer.getDatagramSocket().getLocalPort();
            if (tc.isDebugEnabled() && n == 0) {
                Tr.debug(tc, "getLocalPort == 0");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLocalPort called when udpNetworkLayer == null");
        }
        return n;
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy(Exception)");
        }
        this.workQueueMgr.removeChannel(this.udpNetworkLayer.getDatagramChannel());
        this.udpNetworkLayer.destroy();
        this.udpChannel.removeConnLink(this);
        super.destroy(exception);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy(Exception)");
        }
    }

    public UDPWriteRequestContext getWriteInterface() {
        return this.writer;
    }

    public void setUDPNetworkLayer(UDPNetworkLayer uDPNetworkLayer) {
        this.udpNetworkLayer = uDPNetworkLayer;
    }

    public UDPNetworkLayer getUDPNetworkLayer() {
        return this.udpNetworkLayer;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }
}

