/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.UDPChannel;
import com.ibm.ws.udp.channel.impl.UDPChannelConfiguration;
import com.ibm.ws.udp.channel.impl.UDPConnLink;
import com.ibm.ws.udp.channel.impl.UDPSelectorMonitor;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class UDPNetworkLayer {
    private UDPChannel udpChannel = null;
    private UDPSelectorMonitor selectorMonitor = null;
    protected DatagramChannel datagramChannel = null;
    private UDPConnLink connLink = null;
    private String localBindAddress = null;
    private int localBindPort = 0;
    static final TraceComponent tc = Tr.register(UDPNetworkLayer.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    protected UDPNetworkLayer(UDPChannel uDPChannel, UDPSelectorMonitor uDPSelectorMonitor, String string, int n) {
        this.udpChannel = uDPChannel;
        this.selectorMonitor = uDPSelectorMonitor;
        this.localBindAddress = string;
        this.localBindPort = n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Constructor: localBindAddress = " + string + " localBindPort = " + n);
        }
    }

    protected synchronized DatagramSocket initDatagramSocket(VirtualConnection virtualConnection) throws IOException {
        DatagramSocket datagramSocket;
        InetSocketAddress inetSocketAddress;
        UDPChannelConfiguration uDPChannelConfiguration;
        block30: {
            int n;
            int n2;
            block29: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DatagramSocket called, new DatagramSocket needs to be created");
                }
                uDPChannelConfiguration = this.udpChannel.getConfig();
                inetSocketAddress = null;
                if (this.localBindPort != 0 && this.localBindAddress != null) {
                    if (this.localBindAddress.equals("*")) {
                        this.localBindAddress = "0.0.0.0";
                    }
                    if ((inetSocketAddress = new InetSocketAddress(this.localBindAddress, this.localBindPort)).isUnresolved()) {
                        String string = uDPChannelConfiguration.getHostname();
                        if (string == null) {
                            string = "*";
                        }
                        if (tc.isErrorEnabled()) {
                            Tr.error(tc, "CWUDP0004E", new Object[]{uDPChannelConfiguration.getChannelData().getExternalName(), string, String.valueOf(uDPChannelConfiguration.getPort())});
                        }
                        throw new IOException("local address unresolved");
                    }
                }
                this.datagramChannel = DatagramChannel.open();
                datagramSocket = this.datagramChannel.socket();
                datagramSocket.setReuseAddress(false);
                this.datagramChannel.configureBlocking(false);
                if (uDPChannelConfiguration.getReceiveBufferSize() >= 4 && uDPChannelConfiguration.getReceiveBufferSize() <= 0x1000000) {
                    n2 = datagramSocket.getReceiveBufferSize();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "size of default receive buffer " + n2);
                        Tr.debug(tc, "setting receive buffer to size " + uDPChannelConfiguration.getReceiveBufferSize());
                    }
                    try {
                        datagramSocket.setReceiveBufferSize(uDPChannelConfiguration.getReceiveBufferSize());
                        n = datagramSocket.getReceiveBufferSize();
                        if (tc.isDebugEnabled()) {
                            if (n2 == n) {
                                Tr.debug(tc, "setting receive buffer had no effect, still the same size ");
                            } else {
                                Tr.debug(tc, "new receive buffer size " + n);
                            }
                        }
                    }
                    catch (SocketException socketException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Caught SocketException " + socketException.getMessage() + " while trying to setReceiveBufferSize to " + uDPChannelConfiguration.getReceiveBufferSize());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!tc.isDebugEnabled()) break block29;
                        Tr.debug(tc, "Caught IllegalArgumentException " + illegalArgumentException.getMessage() + " while trying to setReceiveBufferSize to " + uDPChannelConfiguration.getReceiveBufferSize());
                    }
                }
            }
            if (uDPChannelConfiguration.getSendBufferSize() >= 4 && uDPChannelConfiguration.getSendBufferSize() <= 0x1000000) {
                n2 = datagramSocket.getSendBufferSize();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "size of default send buffer " + n2);
                    Tr.debug(tc, "setting send buffer to size " + uDPChannelConfiguration.getSendBufferSize());
                }
                try {
                    datagramSocket.setSendBufferSize(uDPChannelConfiguration.getSendBufferSize());
                    n = datagramSocket.getSendBufferSize();
                    if (tc.isDebugEnabled()) {
                        if (n2 == n) {
                            Tr.debug(tc, "setting send buffer had no effect, still the same size ");
                        } else {
                            Tr.debug(tc, "new send buffer size " + n);
                        }
                    }
                }
                catch (SocketException socketException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught SocketException " + socketException.getMessage() + " while trying to setSendBufferSize to " + uDPChannelConfiguration.getSendBufferSize());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!tc.isDebugEnabled()) break block30;
                    Tr.debug(tc, "Caught IllegalArgumentException " + illegalArgumentException.getMessage() + " while trying to setSendBufferSize to " + uDPChannelConfiguration.getSendBufferSize());
                }
            }
        }
        try {
            datagramSocket.bind(inetSocketAddress);
            this.selectorMonitor.setChannel(this.datagramChannel, this);
        }
        catch (IOException iOException) {
            String string = uDPChannelConfiguration.getHostname();
            if (string == null) {
                string = "*";
            }
            if (tc.isErrorEnabled()) {
                Tr.error(tc, "CWUDP0005E", new Object[]{uDPChannelConfiguration.getChannelData().getExternalName(), string, String.valueOf(uDPChannelConfiguration.getPort())});
            }
            throw new IOException(iOException.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new ServerSocket successfully created");
        }
        return this.datagramChannel.socket();
    }

    public synchronized int getListenPort() {
        DatagramSocket datagramSocket = this.datagramChannel.socket();
        int n = this.localBindPort;
        if (datagramSocket != null) {
            n = datagramSocket.getLocalPort();
        }
        return n;
    }

    public synchronized DatagramSocket getDatagramSocket() {
        return this.datagramChannel.socket();
    }

    public synchronized DatagramChannel getDatagramChannel() {
        return this.datagramChannel;
    }

    public synchronized int send(WsByteBuffer wsByteBuffer, SocketAddress socketAddress) throws IOException {
        int n = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending buffer " + wsByteBuffer + " to " + ((InetSocketAddress)socketAddress).getAddress());
        }
        n = this.datagramChannel.send(wsByteBuffer.getWrappedByteBuffer(), socketAddress);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Buffer sent");
        }
        return n;
    }

    public synchronized SocketAddress receive(WsByteBuffer wsByteBuffer) throws IOException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive");
        }
        SocketAddress socketAddress = null;
        StartPrivilegedThread startPrivilegedThread = new StartPrivilegedThread(wsByteBuffer.getWrappedByteBuffer());
        Result result = (Result)AccessController.doPrivileged(startPrivilegedThread);
        if (result.ex != null) {
            throw result.ex;
        }
        socketAddress = result.ret;
        if (tc.isDebugEnabled()) {
            if (socketAddress != null) {
                Tr.debug(tc, "Received buffer " + wsByteBuffer + " from " + ((InetSocketAddress)socketAddress).getAddress());
            } else {
                Tr.debug(tc, "Received buffer " + wsByteBuffer + " from returnAddress == null");
            }
        }
        if (socketAddress != null && !(bl = this.getUDPChannel().verifySender(((InetSocketAddress)socketAddress).getAddress()))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received buffer from sender not in include list or is in exclude list. " + ((InetSocketAddress)socketAddress).getAddress());
            }
            socketAddress = null;
            wsByteBuffer.flip();
            wsByteBuffer.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive");
        }
        return socketAddress;
    }

    public synchronized UDPChannel getUDPChannel() {
        return this.udpChannel;
    }

    public synchronized void destroy() {
        block2: {
            try {
                this.datagramChannel.close();
                this.datagramChannel = null;
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Caught IOException when trying to close datagram Channel " + iOException.getMessage());
            }
        }
    }

    public synchronized UDPConnLink getConnLink() {
        return this.connLink;
    }

    public synchronized void setConnLink(UDPConnLink uDPConnLink) {
        this.connLink = uDPConnLink;
    }

    class StartPrivilegedThread
    implements PrivilegedAction {
        ByteBuffer buf = null;

        public StartPrivilegedThread(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
        }

        public Object run() {
            Result result = new Result();
            try {
                result.ret = UDPNetworkLayer.this.datagramChannel.receive(this.buf);
                result.ex = null;
            }
            catch (IOException iOException) {
                result.ex = iOException;
                result.ret = null;
            }
            return result;
        }
    }

    public class Result {
        public IOException ex = null;
        public SocketAddress ret = null;
    }
}

