/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.UDPBufferFactory;
import com.ibm.ws.udp.channel.impl.UDPBufferImpl;
import com.ibm.ws.udp.channel.impl.UDPConnLink;
import com.ibm.ws.udp.channel.impl.UDPRequestContextImpl;
import com.ibm.ws.udp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.udp.channel.UDPBuffer;
import com.ibm.wsspi.udp.channel.UDPReadCompletedCallback;
import com.ibm.wsspi.udp.channel.UDPReadCompletedCallbackThreaded;
import com.ibm.wsspi.udp.channel.UDPReadRequestContext;
import java.net.SocketAddress;

public class UDPReadRequestContextImpl
extends UDPRequestContextImpl
implements UDPReadRequestContext {
    private boolean readCalled = false;
    private boolean readAlwaysCalled = false;
    private boolean readFlag = false;
    private UDPReadCompletedCallback readCallback = null;
    private UDPReadCompletedCallbackThreaded readCallbackThreaded = null;
    private boolean forceQueue = false;
    private UDPBufferImpl udpBuffer = new UDPBufferImpl();
    static final TraceComponent tc = Tr.register(UDPReadRequestContextImpl.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    UDPReadRequestContextImpl(UDPConnLink uDPConnLink, WorkQueueManager workQueueManager) {
        super(uDPConnLink, workQueueManager, 1);
    }

    public synchronized VirtualConnection read(UDPReadCompletedCallback uDPReadCompletedCallback, boolean bl) {
        VirtualConnection virtualConnection = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read(long numBytes, UDPReadCompletedCallback callback, boolean forceQueue, int timeout )");
        }
        this.setReadCallback(uDPReadCompletedCallback);
        this.readCalled = true;
        this.forceQueue = bl;
        virtualConnection = this.getWorkQueueManager().processWork(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read(long numBytes, UDPReadCompletedCallback callback, boolean forceQueue, int timeout )");
        }
        return virtualConnection;
    }

    public synchronized void readAlways(UDPReadCompletedCallbackThreaded uDPReadCompletedCallbackThreaded, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readAlways(UDPReadCompletedCallback callback, boolean readFlag)");
        }
        if (bl) {
            this.setReadThreadedCallback(uDPReadCompletedCallbackThreaded);
            this.readAlwaysCalled = true;
        } else {
            this.setReadThreadedCallback(null);
            this.readAlwaysCalled = false;
        }
        this.readFlag = bl;
        this.getWorkQueueManager().processWork(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readAlways(UDPReadCompletedCallback callback, boolean readFlag)");
        }
    }

    protected synchronized void setReadCallback(UDPReadCompletedCallback uDPReadCompletedCallback) {
        this.readCallback = uDPReadCompletedCallback;
    }

    protected synchronized void setReadThreadedCallback(UDPReadCompletedCallbackThreaded uDPReadCompletedCallbackThreaded) {
        this.readCallbackThreaded = uDPReadCompletedCallbackThreaded;
    }

    protected synchronized UDPReadCompletedCallback getReadCallback() {
        return this.readCallback;
    }

    protected synchronized UDPReadCompletedCallbackThreaded getReadThreadedCallback() {
        return this.readCallbackThreaded;
    }

    public synchronized UDPBuffer getUDPBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBuffer");
        }
        this.readCalled = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBuffer");
        }
        return this.udpBuffer;
    }

    protected synchronized void setBuffer(WsByteBuffer wsByteBuffer, SocketAddress socketAddress, boolean bl) {
        if (this.readCalled || bl || this.readAlwaysCalled) {
            this.udpBuffer.set(wsByteBuffer, socketAddress);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setBuffer called with buffer " + wsByteBuffer + " address " + socketAddress);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBuffer called but no read was called.");
        }
    }

    protected void complete(UDPBuffer uDPBuffer) {
        if (this.readAlwaysCalled && this.getReadThreadedCallback() != null) {
            this.getReadThreadedCallback().complete(this.getConnLink().getVirtualConnection(), uDPBuffer);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling multi-threaded read callback.");
            }
        }
    }

    protected void complete() {
        if (this.readAlwaysCalled && this.getReadThreadedCallback() != null) {
            UDPBufferImpl uDPBufferImpl = (UDPBufferImpl)UDPBufferFactory.getUDPBuffer();
            uDPBufferImpl.set(this.udpBuffer.getBuffer(), this.udpBuffer.getAddress());
            this.getReadThreadedCallback().complete(this.getConnLink().getVirtualConnection(), uDPBufferImpl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "!!!!!Calling multi-threaded read callback.");
            }
        } else if (this.getReadCallback() != null) {
            this.getReadCallback().complete(this.getConnLink().getVirtualConnection(), this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling read callback.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No read callback set?????.");
        }
    }

    public boolean isForceQueue() {
        return this.forceQueue;
    }

    public boolean isReadAlwaysCalled() {
        return this.readAlwaysCalled;
    }

    public boolean isReadFlag() {
        return this.readFlag;
    }
}

