/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.udp.channel.impl.CumulativeLogger;
import com.ibm.ws.udp.channel.impl.UDPConnLink;
import com.ibm.ws.udp.channel.impl.UDPRequestContextImpl;
import com.ibm.ws.udp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.udp.channel.UDPWriteCompletedCallback;
import com.ibm.wsspi.udp.channel.UDPWriteRequestContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class UDPWriteRequestContextImpl
extends UDPRequestContextImpl
implements UDPWriteRequestContext {
    private UDPWriteCompletedCallback writeCallback = null;
    private WsByteBuffer writeBuffer = null;
    private SocketAddress address = null;
    private boolean forceQueue = false;
    static final TraceComponent tc = Tr.register(UDPWriteRequestContextImpl.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    UDPWriteRequestContextImpl(UDPConnLink uDPConnLink, WorkQueueManager workQueueManager) {
        super(uDPConnLink, workQueueManager, 2);
    }

    public void setBuffer(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBuffer");
        }
        this.writeBuffer = wsByteBuffer;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBuffer");
        }
    }

    protected WsByteBuffer getBuffer() {
        return this.writeBuffer;
    }

    public VirtualConnection write(SocketAddress socketAddress, UDPWriteCompletedCallback uDPWriteCompletedCallback, boolean bl) {
        VirtualConnection virtualConnection = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write(SocketAddress address, UDPWriteCompletedCallback callback, boolean forceQueue)");
        }
        if (((InetSocketAddress)socketAddress).getAddress() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "write called but adddress is unresolvable [" + socketAddress + "]");
            }
            CumulativeLogger.logLookupFailure(((InetSocketAddress)socketAddress).getHostName());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write when address is unresolvable.");
            }
            return this.getConnLink().getVirtualConnection();
        }
        this.setWriteCallback(uDPWriteCompletedCallback);
        this.setAddress(socketAddress);
        this.setForceQueue(bl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "write called for buffer " + this.getBuffer() + " to address " + socketAddress);
        }
        virtualConnection = this.getWorkQueueManager().processWork(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write(SocketAddress address, UDPWriteCompletedCallback callback, boolean forceQueue)");
        }
        return virtualConnection;
    }

    private void setAddress(SocketAddress socketAddress) {
        this.address = socketAddress;
    }

    protected SocketAddress getAddress() {
        return this.address;
    }

    protected void setWriteCallback(UDPWriteCompletedCallback uDPWriteCompletedCallback) {
        this.writeCallback = uDPWriteCompletedCallback;
    }

    protected UDPWriteCompletedCallback getWriteCallback() {
        return this.writeCallback;
    }

    public boolean isForceQueue() {
        return this.forceQueue;
    }

    public void setForceQueue(boolean bl) {
        this.forceQueue = bl;
    }
}

