/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.udp.channel.impl.BufferDump;
import com.ibm.ws.udp.channel.impl.NIOChannelModRequest;
import com.ibm.ws.udp.channel.impl.UDPBufferFactory;
import com.ibm.ws.udp.channel.impl.UDPChannel;
import com.ibm.ws.udp.channel.impl.UDPConnLink;
import com.ibm.ws.udp.channel.impl.UDPNetworkLayer;
import com.ibm.ws.udp.channel.impl.UDPReadRequestContextImpl;
import com.ibm.ws.udp.channel.impl.UDPRequestContextImpl;
import com.ibm.ws.udp.channel.impl.UDPSelectorMonitor;
import com.ibm.ws.udp.channel.impl.UDPThreadingDiags;
import com.ibm.ws.udp.channel.impl.UDPWriteRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.DiscriminationProcessException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.udp.channel.UDPWriteCompletedCallback;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WorkQueueManager
implements UDPSelectorMonitor {
    static int numWorkerThreads = 0;
    private boolean shutdown = false;
    private Selector selector = null;
    private Thread selectorThread = null;
    private int selectorTimeout = 10000;
    private WsByteBufferPoolManager byteBufferManager = null;
    private int refCount = 0;
    private VirtualConnectionFactory vcFactory = null;
    private Object channelRequestingToBeAddedRemovedSync = new Object();
    private boolean channelRequestingToBeAddedRemoved = false;
    private Map channelToSelectionKeyMap = new HashMap();
    private ArrayList channelModList = new ArrayList();
    private MyNamedLock lock = new MyNamedLock();
    private boolean readAlways = false;
    private ThreadPool threadPool = null;
    private int numReceivesBeforeNewWorker = 10;
    private int numFailuresBeforeWorkerDie = 3;
    private UDPWriteRequestContextImpl outstandingWriteRequest = null;
    private UDPOutstandingWriteLock outstandingWriteLock = new UDPOutstandingWriteLock();
    private SelectorTask selectorTask = null;
    private long selectorThreadId = 0L;
    static final TraceComponent tc = Tr.register(WorkQueueManager.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");

    public WorkQueueManager(WsByteBufferPoolManager wsByteBufferPoolManager, VirtualConnectionFactory virtualConnectionFactory, boolean bl, ThreadPool threadPool) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkQueueManager");
        }
        this.byteBufferManager = wsByteBufferPoolManager;
        this.vcFactory = virtualConnectionFactory;
        this.threadPool = threadPool;
        this.selector = Selector.open();
        this.selectorTask = new SelectorTask();
        this.selectorThread = new Thread(this.selectorTask);
        this.selectorThread.setName("UDP WorkQueueManager Thread:" + numWorkerThreads++);
        this.selectorThread.start();
        this.selectorThreadId = this.selectorThread.getId();
        String string = System.getProperty("numReceivesBeforeNewWorker");
        if (string != null && string.equals("")) {
            this.numReceivesBeforeNewWorker = Integer.parseInt(string);
        }
        if ((string = System.getProperty("numFailuresBeforeWorkerDie")) != null && string.equals("")) {
            this.numFailuresBeforeWorkerDie = Integer.parseInt(string);
        }
        if (UDPThreadingDiags.tc.isDebugEnabled()) {
            UDPThreadingDiags.debug("Creating new WQM : " + this.hashCode() + " with thread id: " + this.selectorThreadId);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SelectorTasks's thread id = " + this.selectorThreadId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkQueueManager");
        }
    }

    public synchronized void addRef() {
        ++this.refCount;
    }

    public synchronized void decRef() {
        --this.refCount;
    }

    public void shutdown() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this.decRef();
        if (this.refCount == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reference Count is 0 so shutting down.");
            }
            this.shutdown = true;
            this.selector.wakeup();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setChannel(DatagramChannel datagramChannel, UDPNetworkLayer uDPNetworkLayer) throws IOException {
        int n = 0;
        if (uDPNetworkLayer.getUDPChannel().getConfig().isInboundChannel()) {
            n = 1;
        }
        NIOChannelModRequest nIOChannelModRequest = new NIOChannelModRequest(1, datagramChannel, n, uDPNetworkLayer);
        Object object = this.channelModList;
        synchronized (object) {
            this.channelModList.add(nIOChannelModRequest);
        }
        object = this.channelRequestingToBeAddedRemovedSync;
        synchronized (object) {
            this.channelRequestingToBeAddedRemoved = true;
        }
        if (UDPThreadingDiags.tc.isDebugEnabled()) {
            UDPThreadingDiags.debug("Adding channel for port: " + datagramChannel.socket().getLocalPort() + " to WQM : " + this.hashCode());
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChannel(DatagramChannel datagramChannel) {
        NIOChannelModRequest nIOChannelModRequest = new NIOChannelModRequest(2, datagramChannel, 0, null);
        Object object = this.channelModList;
        synchronized (object) {
            this.channelModList.add(nIOChannelModRequest);
        }
        object = this.channelRequestingToBeAddedRemovedSync;
        synchronized (object) {
            this.channelRequestingToBeAddedRemoved = true;
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChannelInSelector(DatagramChannel datagramChannel, UDPNetworkLayer uDPNetworkLayer, int n, int n2) throws IOException {
        NIOChannelModRequest nIOChannelModRequest = new NIOChannelModRequest(3, datagramChannel, n, n2, uDPNetworkLayer);
        Object object = this.channelModList;
        synchronized (object) {
            this.channelModList.add(nIOChannelModRequest);
        }
        object = this.channelRequestingToBeAddedRemovedSync;
        synchronized (object) {
            this.channelRequestingToBeAddedRemoved = true;
        }
        if (Thread.currentThread().getId() != this.selectorThreadId) {
            this.selector.wakeup();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "selector.wakeup() for selector " + this.selector.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChannelMods() throws IOException {
        ArrayList arrayList = this.channelModList;
        synchronized (arrayList) {
            Iterator iterator = this.channelModList.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                NIOChannelModRequest nIOChannelModRequest = (NIOChannelModRequest)iterator.next();
                if (nIOChannelModRequest.getRequestType() == 3) {
                    object2 = (SelectionKey)this.channelToSelectionKeyMap.get(nIOChannelModRequest.getChannel());
                    if (object2 != null) {
                        int n = ((SelectionKey)object2).interestOps();
                        if (tc.isDebugEnabled()) {
                            object = " & ";
                            if (nIOChannelModRequest.getInterestOperator() == 2) {
                                object = " | ";
                            }
                            Tr.debug(tc, "Modifying currentOps " + n + " for channel " + object2.hashCode());
                            Tr.debug(tc, "boolean operation interestOps " + n + (String)object + nIOChannelModRequest.getInterestMask() + " for channel " + object2.hashCode());
                        }
                        if (nIOChannelModRequest.getInterestOperator() == 2) {
                            n |= nIOChannelModRequest.getInterestMask();
                        } else if (nIOChannelModRequest.getInterestOperator() == 1) {
                            n &= nIOChannelModRequest.getInterestMask();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New currentOps " + n + " for channel " + object2.hashCode());
                        }
                        ((SelectionKey)object2).interestOps(n);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unable to find SelectionKey for channel.");
                    continue;
                }
                if (nIOChannelModRequest.getRequestType() == 1) {
                    object2 = this.selector;
                    synchronized (object2) {
                        SelectionKey selectionKey = nIOChannelModRequest.getChannel().register(this.selector, nIOChannelModRequest.getInterestMask(), new SelectionKeyAttachment(nIOChannelModRequest.getNetworkLayer()));
                        this.channelToSelectionKeyMap.put(nIOChannelModRequest.getChannel(), selectionKey);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding channel with interestOps " + nIOChannelModRequest.getInterestMask());
                        }
                        continue;
                    }
                }
                if (nIOChannelModRequest.getRequestType() != 2) continue;
                object2 = this.selector;
                synchronized (object2) {
                    DatagramChannel datagramChannel;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing channel");
                    }
                    if ((datagramChannel = nIOChannelModRequest.getChannel()) != null) {
                        this.channelToSelectionKeyMap.remove(datagramChannel);
                        object = datagramChannel.keyFor(this.selector);
                        if (object != null) {
                            ((SelectionKey)object).cancel();
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SelectionKey was null when removing channel.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DatagramChannel was null when removing channel.");
                    }
                }
            }
            this.channelModList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualConnection processWriteRequest(UDPWriteRequestContextImpl uDPWriteRequestContextImpl, boolean bl) {
        VirtualConnection virtualConnection = null;
        UDPOutstandingWriteLock uDPOutstandingWriteLock = this.outstandingWriteLock;
        synchronized (uDPOutstandingWriteLock) {
            block13: {
                boolean bl2 = false;
                if (bl) {
                    bl2 = true;
                } else {
                    if (this.outstandingWriteRequest == null) {
                        bl2 = true;
                    }
                    bl2 = !uDPWriteRequestContextImpl.isForceQueue();
                }
                if (bl2) {
                    try {
                        virtualConnection = this.doPhysicalWrite(uDPWriteRequestContextImpl);
                    }
                    catch (IOException iOException) {
                        UDPWriteCompletedCallback uDPWriteCompletedCallback = uDPWriteRequestContextImpl.getWriteCallback();
                        if (uDPWriteCompletedCallback != null) {
                            uDPWriteCompletedCallback.error(uDPWriteRequestContextImpl.getConnLink().getVirtualConnection(), uDPWriteRequestContextImpl, iOException);
                        }
                        break block13;
                    }
                }
                this.outstandingWriteRequest = uDPWriteRequestContextImpl;
                try {
                    this.setChannelInSelector(uDPWriteRequestContextImpl.getConnLink().getUDPNetworkLayer().getDatagramChannel(), uDPWriteRequestContextImpl.getConnLink().getUDPNetworkLayer(), 4, 2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Turning on WRITE from processWriteRequest");
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Caught IOException while setChannelInSelector. " + iOException.getMessage());
                }
            }
        }
        return virtualConnection;
    }

    private VirtualConnection doPhysicalWrite(UDPWriteRequestContextImpl uDPWriteRequestContextImpl) throws IOException {
        VirtualConnection virtualConnection = null;
        this.outstandingWriteRequest = uDPWriteRequestContextImpl;
        UDPConnLink uDPConnLink = uDPWriteRequestContextImpl.getConnLink();
        UDPNetworkLayer uDPNetworkLayer = uDPConnLink.getUDPNetworkLayer();
        int n = 1;
        try {
            n = uDPNetworkLayer.send(uDPWriteRequestContextImpl.getBuffer(), uDPWriteRequestContextImpl.getAddress());
        }
        catch (IOException iOException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught exception " + iOException.toString() + " while sending data.  Packet is lost.");
            }
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.udp.channel.impl.WorkQueueManager", "1", this);
        }
        if (n != 0) {
            this.outstandingWriteRequest = null;
            virtualConnection = uDPWriteRequestContextImpl.getConnLink().getVirtualConnection();
        } else {
            this.setChannelInSelector(uDPWriteRequestContextImpl.getConnLink().getUDPNetworkLayer().getDatagramChannel(), uDPWriteRequestContextImpl.getConnLink().getUDPNetworkLayer(), 4, 2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Turning on WRITE from doPhyiscalWrite");
            }
        }
        return virtualConnection;
    }

    private void setupReadOp(UDPReadRequestContextImpl uDPReadRequestContextImpl) {
        block3: {
            try {
                SelectionKey selectionKey;
                this.setChannelInSelector(uDPReadRequestContextImpl.getConnLink().getUDPNetworkLayer().getDatagramChannel(), uDPReadRequestContextImpl.getConnLink().getUDPNetworkLayer(), 1, 2);
                if (tc.isDebugEnabled() && (selectionKey = (SelectionKey)this.channelToSelectionKeyMap.get(uDPReadRequestContextImpl.getConnLink().getUDPNetworkLayer().getDatagramChannel())) != null) {
                    Tr.debug(tc, "Turning on READ from processReadRequest for channel " + selectionKey.hashCode());
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "setupReadOp IOException caught. " + iOException.getMessage());
            }
        }
    }

    private VirtualConnection processReadRequest(UDPReadRequestContextImpl uDPReadRequestContextImpl) {
        VirtualConnection virtualConnection;
        block11: {
            virtualConnection = null;
            if (uDPReadRequestContextImpl.isForceQueue() || uDPReadRequestContextImpl.isReadAlwaysCalled() && uDPReadRequestContextImpl.isReadFlag()) {
                this.setupReadOp(uDPReadRequestContextImpl);
                if (uDPReadRequestContextImpl.isReadAlwaysCalled() && uDPReadRequestContextImpl.isReadFlag()) {
                    this.readAlways = true;
                }
            } else {
                if (uDPReadRequestContextImpl.isReadAlwaysCalled() && !uDPReadRequestContextImpl.isReadFlag()) {
                    this.readAlways = false;
                    try {
                        this.setChannelInSelector(uDPReadRequestContextImpl.getConnLink().getUDPNetworkLayer().getDatagramChannel(), uDPReadRequestContextImpl.getConnLink().getUDPNetworkLayer(), -2, 1);
                    }
                    catch (IOException iOException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processReadRequest IOException caught. " + iOException.getMessage());
                        }
                        break block11;
                    }
                }
                UDPNetworkLayer uDPNetworkLayer = uDPReadRequestContextImpl.getConnLink().getUDPNetworkLayer();
                WsByteBuffer wsByteBuffer = this.byteBufferManager.allocateDirect(uDPNetworkLayer.getUDPChannel().getConfig().getChannelReceiveBufferSize());
                try {
                    SocketAddress socketAddress = uDPNetworkLayer.receive(wsByteBuffer);
                    if (socketAddress != null) {
                        uDPReadRequestContextImpl.setBuffer(wsByteBuffer, socketAddress, false);
                        virtualConnection = uDPReadRequestContextImpl.getConnLink().getVirtualConnection();
                    } else {
                        wsByteBuffer.release();
                        this.setupReadOp(uDPReadRequestContextImpl);
                    }
                }
                catch (IOException iOException) {
                    wsByteBuffer.release();
                }
            }
        }
        return virtualConnection;
    }

    private void callWriteCompletedCallback(UDPWriteRequestContextImpl uDPWriteRequestContextImpl) {
        UDPWriteCompletedCallback uDPWriteCompletedCallback = uDPWriteRequestContextImpl.getWriteCallback();
        if (uDPWriteCompletedCallback != null) {
            uDPWriteCompletedCallback.complete(uDPWriteRequestContextImpl.getConnLink().getVirtualConnection(), uDPWriteRequestContextImpl);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "callWriteCompletedCallback write completed, but no callback???");
        }
    }

    public VirtualConnection processWork(UDPRequestContextImpl uDPRequestContextImpl) {
        VirtualConnection virtualConnection = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processWork");
        }
        if (uDPRequestContextImpl.getRequestType() == 1) {
            UDPReadRequestContextImpl uDPReadRequestContextImpl = (UDPReadRequestContextImpl)uDPRequestContextImpl;
            virtualConnection = this.processReadRequest(uDPReadRequestContextImpl);
        } else if (uDPRequestContextImpl.getRequestType() == 2) {
            UDPWriteRequestContextImpl uDPWriteRequestContextImpl = (UDPWriteRequestContextImpl)uDPRequestContextImpl;
            virtualConnection = this.processWriteRequest(uDPWriteRequestContextImpl, false);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processWork called with unknown UDPRequestContextImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processWork");
        }
        return virtualConnection;
    }

    private void sendToDiscriminaters(VirtualConnection virtualConnection, UDPReadRequestContextImpl uDPReadRequestContextImpl, UDPChannel uDPChannel) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendToDiscriminaters");
        }
        int n = 0;
        try {
            n = uDPChannel.getDiscriminationProcess().discriminate(virtualConnection, (Object)uDPReadRequestContextImpl.getUDPBuffer().getBuffer(), (ConnectionLink)uDPReadRequestContextImpl.getConnLink());
        }
        catch (DiscriminationProcessException discriminationProcessException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while discriminating data received from client ");
            }
            uDPReadRequestContextImpl.getConnLink().close(virtualConnection, new IOException("Discrimination failed " + discriminationProcessException.getMessage()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Discrimination returned " + n);
        }
        if (n == 1) {
            ConnectionReadyCallback connectionReadyCallback = uDPReadRequestContextImpl.getConnLink().getApplicationCallback();
            if (connectionReadyCallback != null) {
                if (this.threadPool != null) {
                    Worker worker = new Worker(connectionReadyCallback, virtualConnection);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting thread pool thread and executing ConnectionReadyCallback");
                    }
                    int n2 = this.threadPool.execute((Runnable)worker);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "After thread pool execute call ConnectionReadyCallback rc = " + n2);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ThreadPool is null executing ConnectionReadyCallback directly");
                    }
                    connectionReadyCallback.ready(virtualConnection);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No application callback found, closing connection");
                }
                uDPReadRequestContextImpl.getConnLink().close(virtualConnection, null);
            }
        } else if (n == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Discrimination failed, no one claimed data even after 1 complete buffer presented - probably garbage passed in");
                uDPReadRequestContextImpl.getConnLink().close(virtualConnection, null);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "Error occurred while discriminating data received from client ");
            }
            uDPReadRequestContextImpl.getConnLink().close(virtualConnection, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendToDiscriminaters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWrite(SelectionKey selectionKey) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "key is writeable ");
        }
        UDPOutstandingWriteLock uDPOutstandingWriteLock = this.outstandingWriteLock;
        synchronized (uDPOutstandingWriteLock) {
            block10: {
                try {
                    if (this.outstandingWriteRequest != null) {
                        VirtualConnection virtualConnection = this.processWriteRequest(this.outstandingWriteRequest, true);
                        if (virtualConnection != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "processWriteRequest returned vc calling completed callback.");
                            }
                            this.callWriteCompletedCallback(this.outstandingWriteRequest);
                        }
                        this.setChannelInSelector(this.outstandingWriteRequest.getConnLink().getUDPNetworkLayer().getDatagramChannel(), this.outstandingWriteRequest.getConnLink().getUDPNetworkLayer(), -5, 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Turning off WRITE from selection thread");
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Caught IOException while setChannelInSelector. " + iOException.getMessage());
                }
            }
        }
    }

    protected boolean handleRead(SelectionKey selectionKey, UDPNetworkLayer uDPNetworkLayer) {
        boolean bl;
        block23: {
            bl = true;
            try {
                Object object;
                WsByteBuffer wsByteBuffer = this.byteBufferManager.allocateDirect(uDPNetworkLayer.getUDPChannel().getConfig().getChannelReceiveBufferSize());
                SocketAddress socketAddress = uDPNetworkLayer.receive(wsByteBuffer);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Buffer from Address " + socketAddress);
                    object = BufferDump.getHexDump(wsByteBuffer.getWrappedByteBuffer());
                    Tr.debug(tc, (String)object);
                }
                if (socketAddress != null) {
                    object = uDPNetworkLayer.getConnLink();
                    if (object == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating new UDPConnLink");
                        }
                        try {
                            VirtualConnection virtualConnection = this.vcFactory.createConnection();
                            object = (UDPConnLink)uDPNetworkLayer.getUDPChannel().getConnectionLink(virtualConnection);
                            uDPNetworkLayer.setConnLink((UDPConnLink)object);
                            ((UDPConnLink)object).setUDPNetworkLayer(uDPNetworkLayer);
                            UDPReadRequestContextImpl uDPReadRequestContextImpl = (UDPReadRequestContextImpl)((UDPConnLink)object).getReadInterface();
                            uDPReadRequestContextImpl.setBuffer(wsByteBuffer, socketAddress, true);
                            this.sendToDiscriminaters(virtualConnection, uDPReadRequestContextImpl, uDPNetworkLayer.getUDPChannel());
                        }
                        catch (ChainException chainException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caught ChainException while creating VC " + chainException.getMessage());
                            }
                            break block23;
                        }
                        catch (ChannelException channelException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caught ChannelException while creating VC " + channelException.getMessage());
                            }
                            break block23;
                        }
                    }
                    if (!this.readAlways) {
                        this.setChannelInSelector(uDPNetworkLayer.getDatagramChannel(), uDPNetworkLayer, -2, 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Turning off READ from selection thread");
                        }
                        UDPReadRequestContextImpl uDPReadRequestContextImpl = (UDPReadRequestContextImpl)((UDPConnLink)object).getReadInterface();
                        uDPReadRequestContextImpl.setBuffer(wsByteBuffer, socketAddress, false);
                        if (this.threadPool != null) {
                            Worker worker = null;
                            worker = new Worker(uDPReadRequestContextImpl);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Getting thread pool thread and executing");
                            }
                            int n = this.threadPool.execute((Runnable)worker, 1);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "After thread pool execute call rc = " + n);
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ThreadPool is null executing UDPReadRequestContextImpl.complete directly");
                            }
                            uDPReadRequestContextImpl.complete();
                        }
                    } else {
                        UDPReadRequestContextImpl uDPReadRequestContextImpl = (UDPReadRequestContextImpl)((UDPConnLink)object).getReadInterface();
                        uDPReadRequestContextImpl.complete(UDPBufferFactory.getUDPBuffer(wsByteBuffer, socketAddress));
                    }
                    break block23;
                }
                wsByteBuffer.release();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Why did I get a read event and there was nothing to read????");
                }
                bl = false;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught IOException while setChannelInSelector. " + iOException.getMessage());
                }
                bl = false;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught Throwable while setChannelInSelector. " + throwable.getMessage());
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.16.1.2 ");
        }
    }

    private class UDPOutstandingWriteLock {
        private UDPOutstandingWriteLock() {
        }
    }

    private class MyNamedLock {
        private MyNamedLock() {
        }
    }

    protected class Worker
    implements Runnable {
        private UDPReadRequestContextImpl req = null;
        private ConnectionReadyCallback cb = null;
        private VirtualConnection vc = null;

        protected Worker(UDPReadRequestContextImpl uDPReadRequestContextImpl) {
            this.req = uDPReadRequestContextImpl;
        }

        protected Worker(ConnectionReadyCallback connectionReadyCallback, VirtualConnection virtualConnection) {
            this.cb = connectionReadyCallback;
            this.vc = virtualConnection;
        }

        public void run() {
            if (this.req != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Worker thread processing read request");
                }
                this.req.complete();
            } else if (this.cb != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Worker thread processing ConnectionReadyCallback");
                }
                this.cb.ready(this.vc);
            }
        }
    }

    protected class MultiThreadedWorker
    implements Runnable {
        SelectionKey key = null;
        long threadIdfWQM = 0L;

        protected MultiThreadedWorker(SelectionKey selectionKey, long l) {
            this.key = selectionKey;
            this.threadIdfWQM = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SelectionKeyAttachment selectionKeyAttachment = (SelectionKeyAttachment)this.key.attachment();
            try {
                boolean bl = false;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (!bl) {
                    boolean bl2 = WorkQueueManager.this.handleRead(this.key, selectionKeyAttachment.udpNetworkLayer);
                    WorkQueueManager.this.handleWrite(this.key);
                    if (!bl2) {
                        if (n3 > n4) {
                            n4 = n3;
                        }
                        n2 = 0;
                        if (++n != WorkQueueManager.this.numFailuresBeforeWorkerDie) continue;
                        bl = true;
                        if (!UDPThreadingDiags.tc.isDebugEnabled()) continue;
                        UDPThreadingDiags.debug(this.threadIdfWQM + ":Stopping this worker thread: " + selectionKeyAttachment.getNumThreadsProcessing() + ":" + n4);
                        continue;
                    }
                    ++n3;
                    n = 0;
                    if (++n2 <= WorkQueueManager.this.numReceivesBeforeNewWorker) continue;
                    n2 = 0;
                    if (selectionKeyAttachment.getNumThreadsProcessing() < WorkQueueManager.this.threadPool.getMaximumPoolSize()) {
                        try {
                            int n5 = WorkQueueManager.this.threadPool.execute((Runnable)new MultiThreadedWorker(this.key, this.threadIdfWQM), 2);
                            if (n5 != 0) {
                                if (!UDPThreadingDiags.tc.isDebugEnabled()) continue;
                                UDPThreadingDiags.debug(this.threadIdfWQM + ":Failed to get thread from thread pool.  rc = " + n5);
                                continue;
                            }
                            selectionKeyAttachment.incNumThreadsProcessing();
                            if (!UDPThreadingDiags.tc.isDebugEnabled()) continue;
                            UDPThreadingDiags.debug(this.threadIdfWQM + ":Starting up new worker thread from worker thread: " + selectionKeyAttachment.getNumThreadsProcessing() + " after processing " + n2 + " packets.");
                        }
                        catch (Throwable throwable) {
                            UDPThreadingDiags.debug(this.threadIdfWQM + ":Caught throwable while executing new worker thread = " + throwable.getMessage());
                        }
                        continue;
                    }
                    UDPThreadingDiags.debug(this.threadIdfWQM + ":Did not launch another worker because already at maximum number  = " + selectionKeyAttachment.getNumThreadsProcessing() + " Thread Pool size is = " + WorkQueueManager.this.threadPool.getMaximumPoolSize());
                }
            }
            catch (Throwable throwable) {
                UDPThreadingDiags.debug(this.threadIdfWQM + ":Caught throwable while in worker thread = " + throwable.getMessage());
            }
            finally {
                selectionKeyAttachment.decNumThreadsProcessing();
                if (selectionKeyAttachment.getNumThreadsProcessing() == 0) {
                    MyNamedLock myNamedLock = WorkQueueManager.this.lock;
                    synchronized (myNamedLock) {
                        WorkQueueManager.this.lock.notify();
                    }
                }
            }
        }
    }

    protected class SelectionKeyAttachment {
        private int numThreadsProcessing = 0;
        private UDPNetworkLayer udpNetworkLayer = null;

        SelectionKeyAttachment(UDPNetworkLayer uDPNetworkLayer) {
            this.udpNetworkLayer = uDPNetworkLayer;
        }

        public synchronized int getNumThreadsProcessing() {
            return this.numThreadsProcessing;
        }

        public synchronized void incNumThreadsProcessing() {
            ++this.numThreadsProcessing;
        }

        public synchronized void decNumThreadsProcessing() {
            --this.numThreadsProcessing;
        }

        public UDPNetworkLayer getUdpNetworkLayer() {
            return this.udpNetworkLayer;
        }
    }

    public class SelectorTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block49: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "SelectorTask.run");
                }
                MyNamedLock myNamedLock = WorkQueueManager.this.lock;
                synchronized (myNamedLock) {
                    long l = 10000L;
                    long l2 = 0L;
                    int n = 0;
                    while (!WorkQueueManager.this.shutdown) {
                        try {
                            Iterator<SelectionKey> iterator;
                            block48: {
                                Object object;
                                Object object2;
                                Set<SelectionKey> set;
                                int n2 = 0;
                                iterator = WorkQueueManager.this.selector;
                                synchronized (iterator) {
                                    if (UDPThreadingDiags.tc.isDebugEnabled()) {
                                        UDPThreadingDiags.debug(Thread.currentThread().getId() + ":Calling select");
                                    }
                                    n2 = WorkQueueManager.this.selector.select(WorkQueueManager.this.selectorTimeout);
                                }
                                if (n2 == 0) {
                                    if (tc.isEventEnabled() && !WorkQueueManager.this.shutdown) {
                                        long l3 = System.currentTimeMillis();
                                        if (l2 > 0L && l3 > l2 + l) {
                                            l2 = 0L;
                                            set = WorkQueueManager.this.selector.keys();
                                            if (set != null) {
                                                Tr.event(tc, "*** current interest ops ");
                                                object2 = set.iterator();
                                                while (object2.hasNext()) {
                                                    object = (SelectionKey)object2.next();
                                                    if (object == null) continue;
                                                    Tr.event(tc, "channel = " + object.hashCode() + " interestOps " + ((SelectionKey)object).interestOps());
                                                }
                                                Tr.event(tc, "*** end current interest ops ");
                                            }
                                        }
                                    }
                                } else {
                                    if (UDPThreadingDiags.tc.isDebugEnabled()) {
                                        UDPThreadingDiags.debug(Thread.currentThread().getId() + ":returned from select = " + n2);
                                    }
                                    if (tc.isEventEnabled()) {
                                        l2 = System.currentTimeMillis();
                                    }
                                    iterator = WorkQueueManager.this.selector.selectedKeys().iterator();
                                    while (iterator.hasNext()) {
                                        block47: {
                                            SelectionKey selectionKey = iterator.next();
                                            try {
                                                set = (SelectionKeyAttachment)selectionKey.attachment();
                                                object2 = ((SelectionKeyAttachment)((Object)set)).udpNetworkLayer;
                                                object = ((UDPNetworkLayer)object2).getConnLink();
                                                if (!selectionKey.isValid()) {
                                                    iterator.remove();
                                                    continue;
                                                }
                                                if (WorkQueueManager.this.readAlways && object != null) {
                                                    int n3;
                                                    ((SelectionKeyAttachment)((Object)set)).incNumThreadsProcessing();
                                                    if (UDPThreadingDiags.tc.isDebugEnabled()) {
                                                        UDPThreadingDiags.debug(Thread.currentThread().getId() + ":Starting worker thread from WQM: " + ((SelectionKeyAttachment)((Object)set)).getNumThreadsProcessing());
                                                    }
                                                    MultiThreadedWorker multiThreadedWorker = new MultiThreadedWorker(selectionKey, Thread.currentThread().getId());
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Getting thread pool thread and executing read");
                                                    }
                                                    if ((n3 = WorkQueueManager.this.threadPool.execute((Runnable)multiThreadedWorker, 1)) != 0 && tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Failed to get thread from thread pool.  rc = " + n3);
                                                    }
                                                } else {
                                                    WorkQueueManager.this.readAlways = false;
                                                    if (selectionKey.isReadable()) {
                                                        WorkQueueManager.this.handleRead(selectionKey, (UDPNetworkLayer)object2);
                                                    }
                                                    if (selectionKey.isWritable()) {
                                                        WorkQueueManager.this.handleWrite(selectionKey);
                                                    }
                                                }
                                            }
                                            catch (CancelledKeyException cancelledKeyException) {
                                                if (!tc.isDebugEnabled()) break block47;
                                                Tr.debug(tc, "Cancelled key exception.");
                                            }
                                        }
                                        iterator.remove();
                                    }
                                    if (WorkQueueManager.this.readAlways) {
                                        try {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Waiting on lock.");
                                            }
                                            WorkQueueManager.this.lock.wait();
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "After wait on lock.");
                                            }
                                        }
                                        catch (InterruptedException interruptedException) {
                                            if (!tc.isDebugEnabled()) break block48;
                                            Tr.debug(tc, "Caught InterruptedException waiting on lock.");
                                        }
                                    }
                                }
                            }
                            iterator = WorkQueueManager.this.channelRequestingToBeAddedRemovedSync;
                            synchronized (iterator) {
                                if (WorkQueueManager.this.channelRequestingToBeAddedRemoved) {
                                    WorkQueueManager.this.channelRequestingToBeAddedRemoved = false;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "channelRequestingToBeAddedRemoved for selector " + WorkQueueManager.this.selector.hashCode());
                                    }
                                    WorkQueueManager.this.handleChannelMods();
                                }
                            }
                            n = 0;
                        }
                        catch (IOException iOException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caught IOException while selecting. " + iOException.getMessage());
                            }
                            if (++n <= 5) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Sleeping for 5 seconds so we don't spin out of control. ");
                            }
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "SelectorTask.run");
                    }
                }
                try {
                    WorkQueueManager.this.selector.close();
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block49;
                    Tr.debug(tc, "Caught IOException while closing selector. " + iOException.getMessage());
                }
            }
        }
    }
}

