/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udp.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.UDPInboundChannel;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.runtime.WSThreadPool;
import com.ibm.ws.runtime.WSThreadPoolRepository;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.udp.channel.impl.UDPChannelFactory;
import com.ibm.ws.udp.channel.inbound.impl.WSUdpOutboundDefinition;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSUdpInboundChannelFactory
extends UDPChannelFactory
implements WSChannelFactory {
    private static final TraceComponent tc = Tr.register(WSUdpInboundChannelFactory.class, "WebSphere UDP Channel", "com.ibm.ws.udp.channel.resources.udpchannel");
    private static PlatformHelper helper = null;

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        return null;
    }

    private PlatformHelper getHelper() {
        block3: {
            if (helper == null) {
                try {
                    helper = PlatformHelperFactory.getPlatformHelper();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Unable to determine local OS + ", exception);
                }
            }
        }
        return helper;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createChannelConfigurationMap");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        UDPInboundChannel uDPInboundChannel = (UDPInboundChannel)transportChannel;
        Server server2 = (Server)channelFrameworkService.lookupService(Server.class);
        EndPointMgr endPointMgr = (EndPointMgr)channelFrameworkService.lookupService(EndPointMgr.class);
        if (server2 == null) {
            throw new ConfigurationError("UDP channel factory could not determine its parent server");
        }
        if (endPointMgr == null) {
            throw new ConfigurationError("UDP channel factory could not locate the EndPointMgr");
        }
        try {
            EList eList;
            Object[] objectArray;
            EList eList2;
            EndPointMgr.NodeEndPoints nodeEndPoints = endPointMgr.getNodeEndPoints(server2.getNodeName());
            EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(server2.getName());
            EndPoint endPoint = serverEndPoints.getEndPoint(uDPInboundChannel.getEndPointName());
            hashMap.put("hostname", endPoint.getHost());
            hashMap.put("port", String.valueOf(endPoint.getPort()));
            hashMap.put("endPointName", uDPInboundChannel.getEndPointName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UDP Address for Endpoint: " + uDPInboundChannel.getEndPointName() + ":");
                Tr.debug(tc, "UDP Host = " + endPoint.getHost());
                Tr.debug(tc, "UDP Port = " + endPoint.getPort());
            }
            if ((eList2 = transportChannel.getProperties()) != null) {
                for (int i = 0; i < eList2.size(); ++i) {
                    objectArray = (Object[])eList2.get(i);
                    if (objectArray.getName().equals("receiveBufferSizeChannel")) {
                        hashMap.put("receiveBufferSizeChannel", objectArray.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Custom property " + objectArray.getName() + ":" + objectArray.getValue());
                        continue;
                    }
                    if (objectArray.getName().equals("sendBufferSizeSocket")) {
                        hashMap.put("sendBufferSizeSocket", objectArray.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Custom property " + objectArray.getName() + ":" + objectArray.getValue());
                        continue;
                    }
                    if (objectArray.getName().equals("receiveBufferSizeSocket")) {
                        hashMap.put("receiveBufferSizeSocket", objectArray.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Custom property " + objectArray.getName() + ":" + objectArray.getValue());
                        continue;
                    }
                    if (objectArray.getName().equals("threadPoolName")) {
                        hashMap.put("threadPoolName", objectArray.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Custom property " + objectArray.getName() + ":" + objectArray.getValue());
                        continue;
                    }
                    if (objectArray.getName().equals("threadPoolEnabled")) {
                        hashMap.put("threadPoolEnabled", objectArray.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Custom property " + objectArray.getName() + ":" + objectArray.getValue());
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unrecognized custom property " + objectArray.getName() + ":" + objectArray.getValue());
                }
            }
            if ((eList = uDPInboundChannel.getAddressExcludeList()) != null && eList.size() > 0) {
                objectArray = new String[eList.size()];
                objectArray = (String[])eList.toArray(objectArray);
                hashMap.put("addressExcludeList", objectArray);
            }
            if ((eList = uDPInboundChannel.getAddressIncludeList()) != null && eList.size() > 0) {
                objectArray = new String[eList.size()];
                objectArray = (String[])eList.toArray(objectArray);
                hashMap.put("addressIncludeList", objectArray);
            }
        }
        catch (Exception exception) {
            throw new ConfigurationError("endPointName \"" + uDPInboundChannel.getEndPointName() + "\" could not be resolved; please check serverindex.xml", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createChannelConfigurationMap");
        }
        return hashMap;
    }

    private Property checkVarExpansion(Property property, VariableMap variableMap) {
        return property;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return new WSUdpOutboundDefinition(map);
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }

    protected ThreadPool getThreadPool() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSUdpInboundChannelFactory:getThreadPool called");
        }
        if (this.factoryConfig.isThreadPoolEnabled()) {
            String string = this.factoryConfig.getThreadPoolName();
            if (string == null) {
                string = "UDP Thread Pool";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread Pool name is null, using [UDP Thread Pool]");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using thread pool [" + string + "]");
            }
            WSThreadPoolRepository wSThreadPoolRepository = (WSThreadPoolRepository)ThreadPoolRepositoryManager.getThreadPoolRepository();
            WSThreadPool wSThreadPool = null;
            try {
                wSThreadPool = (WSThreadPool)wSThreadPoolRepository.createThreadPool(string, 5, 10);
            }
            catch (ThreadPoolAlreadyKnownException threadPoolAlreadyKnownException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread pool already exists.  [" + string + "]. Just getting it now.");
                }
                wSThreadPool = (WSThreadPool)wSThreadPoolRepository.getThreadPool(string);
            }
            if (this.getHelper().isZOS()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling  setDecoratedZOS on the threadpool.");
                }
                com.ibm.ws.util.ThreadPool threadPool = wSThreadPool.getBackingThreadPool();
                threadPool.setDecoratedZOS();
            }
            this.threadPool = wSThreadPool;
            if (this.threadPool == null && tc.isEventEnabled()) {
                Tr.event(tc, "UDP Channel Factory: - Could not obtain named thread pool from ThreadPoolRepositoryManager, thread pool name: " + string);
            }
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Not using thread pool for UDP Channel Factory");
        }
        return this.threadPool;
    }
}

