/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.uow;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import javax.transaction.Synchronization;

public class ComponentContextSynchronizationWrapper
implements Synchronization {
    private static final TraceComponent tc = Tr.register(ComponentContextSynchronizationWrapper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private Synchronization _sync;
    private ComponentMetaData _componentMetaData;

    public ComponentContextSynchronizationWrapper(Synchronization synchronization) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ComponentContextSynchronizationWrapper", synchronization);
        }
        this._sync = synchronization;
        this.captureComponentContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ComponentContextSynchronizationWrapper", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion", this);
        }
        try {
            this.setComponentContextOnThread();
            this._sync.beforeCompletion();
        }
        finally {
            this.removeComponentContextFromThread();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeCompletion");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion", new Object[]{new Integer(n), this});
        }
        try {
            this.setComponentContextOnThread();
            this._sync.afterCompletion(n);
        }
        finally {
            this.removeComponentContextFromThread();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterCompletion");
            }
        }
    }

    private void captureComponentContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "captureComponentContext", this);
        }
        this._componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "captureComponentContext");
        }
    }

    private void setComponentContextOnThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setComponentContextOnThread", this);
        }
        ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(this._componentMetaData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setComponentContextOnThread");
        }
    }

    private void removeComponentContextFromThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeComponentContextFromThread", this);
        }
        ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeComponentContextFromThread");
        }
    }
}

