/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

public class BoundedBuffer {
    private int waitingThreads = 0;
    private static final int SPINS_TAKE_;
    private static final int SPINS_PUT_;
    private static final boolean YIELD_TAKE_;
    private static final boolean YIELD_PUT_;
    private static final long WAIT_SLICE_;
    private Object putQueue_ = new Object();
    private int putQueueLen_ = 0;
    private Object getQueue_ = new Object();
    private int getQueueLen_ = 0;
    private Object[] buffer;
    private int takeIndex = 0;
    private int putIndex = 0;
    private AtomicInteger numberOfUsedSlots = new AtomicInteger(0);
    private final BoundedBufferLock lock = new BoundedBufferLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGet_() {
        if (this.getQueueLen_ > 0) {
            Object object = this.getQueue_;
            synchronized (object) {
                this.getQueue_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitGet_(long l) throws InterruptedException {
        Object object = this.getQueue_;
        synchronized (object) {
            try {
                ++this.getQueueLen_;
                if (this.numberOfUsedSlots.get() <= 0) {
                    this.getQueue_.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                this.getQueue_.notify();
                throw interruptedException;
            }
            finally {
                --this.getQueueLen_;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPut_() {
        if (this.putQueueLen_ > 0) {
            Object object = this.putQueue_;
            synchronized (object) {
                this.putQueue_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPut_(long l) throws InterruptedException {
        Object object = this.putQueue_;
        synchronized (object) {
            try {
                ++this.putQueueLen_;
                if (this.numberOfUsedSlots.get() >= this.buffer.length) {
                    this.putQueue_.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                this.putQueue_.notify();
                throw interruptedException;
            }
            finally {
                --this.putQueueLen_;
            }
        }
    }

    public BoundedBuffer(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[n];
    }

    public int size() {
        return this.numberOfUsedSlots.get();
    }

    public int capacity() {
        return this.buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.numberOfUsedSlots.get() > 0) {
                return this.buffer[this.takeIndex];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(object);
                    this.numberOfUsedSlots.getAndIncrement();
                    bl = true;
                }
            }
            if (bl) {
                this.notifyGet_();
                return;
            }
            int n = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (n > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --n;
                    continue;
                }
                this.waitPut_(WAIT_SLICE_);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, long l) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        long l2 = l <= 0L ? 0L : -1L;
        long l3 = l;
        Object object2 = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(object);
                    this.numberOfUsedSlots.getAndIncrement();
                    object2 = object;
                }
            }
            if (object2 != null) {
                this.notifyGet_();
                return object2;
            }
            if (l2 == -1L) {
                l2 = System.currentTimeMillis();
            }
            int n = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (l3 <= 0L) {
                    return null;
                }
                if (n > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --n;
                } else {
                    this.waitPut_(l);
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, long l, int n) throws InterruptedException {
        if (object == null || n > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        long l2 = l <= 0L ? 0L : -1L;
        long l3 = l;
        Object object2 = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < n) {
                    this.insert(object);
                    this.numberOfUsedSlots.getAndIncrement();
                    object2 = object;
                }
            }
            if (object2 != null) {
                this.notifyGet_();
                return object2;
            }
            if (l2 == -1L) {
                l2 = System.currentTimeMillis();
            }
            int n2 = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (l3 <= 0L) {
                    return null;
                }
                if (n2 > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --n2;
                } else {
                    this.waitPut_(l);
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object, long l) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        long l2 = l <= 0L ? 0L : -1L;
        long l3 = l;
        boolean bl = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(object);
                    this.numberOfUsedSlots.getAndIncrement();
                    bl = true;
                }
            }
            if (bl) {
                this.notifyGet_();
                return true;
            }
            if (l2 == -1L) {
                l2 = System.currentTimeMillis();
            }
            int n = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (l3 <= 0L) {
                    return false;
                }
                if (n > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --n;
                } else {
                    this.waitPut_(l3);
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object object = null;
        block3: while (true) {
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                if (this.numberOfUsedSlots.get() > 0) {
                    object = this.extract();
                    this.numberOfUsedSlots.getAndDecrement();
                }
                if (object != null) {
                    --this.waitingThreads;
                }
            }
            if (object != null) {
                this.notifyPut_();
                return object;
            }
            int n = SPINS_TAKE_;
            while (true) {
                if (this.numberOfUsedSlots.get() > 0) continue block3;
                if (n > 0) {
                    if (YIELD_TAKE_) {
                        Thread.yield();
                    }
                    --n;
                    continue;
                }
                this.waitGet_(WAIT_SLICE_);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long l) throws InterruptedException {
        Object object = null;
        long l2 = l <= 0L ? 0L : -1L;
        long l3 = l;
        block3: while (true) {
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                if (this.numberOfUsedSlots.get() > 0) {
                    object = this.extract();
                    this.numberOfUsedSlots.getAndDecrement();
                }
                if (object != null) {
                    --this.waitingThreads;
                }
            }
            if (object != null) {
                this.notifyPut_();
                return object;
            }
            if (l2 == -1L) {
                l2 = System.currentTimeMillis();
            }
            int n = SPINS_TAKE_;
            while (true) {
                if (this.numberOfUsedSlots.get() > 0) continue block3;
                if (l3 <= 0L) {
                    return null;
                }
                if (n > 0) {
                    if (YIELD_TAKE_) {
                        Thread.yield();
                    }
                    --n;
                } else {
                    this.waitGet_(l3);
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            break;
        }
    }

    synchronized void incrementWaitingThreads() {
        ++this.waitingThreads;
    }

    synchronized void decrementWaitingThreads() {
        --this.waitingThreads;
    }

    synchronized int excessWaitingThreads() {
        return this.waitingThreads - this.numberOfUsedSlots.get();
    }

    private final void insert(Object object) {
        this.buffer[this.putIndex] = object;
        if (++this.putIndex >= this.buffer.length) {
            this.putIndex = 0;
        }
    }

    private final Object extract() {
        Object object = this.buffer[this.takeIndex];
        this.buffer[this.takeIndex] = null;
        if (++this.takeIndex >= this.buffer.length) {
            this.takeIndex = 0;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expand(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            Object[] objectArray = new Object[this.buffer.length + n];
            if (this.putIndex > this.takeIndex) {
                int n2 = this.putIndex - this.takeIndex;
                System.arraycopy(this.buffer, this.takeIndex, objectArray, 0, n2);
                this.putIndex = n2;
            } else if (this.putIndex != this.takeIndex || this.buffer[this.takeIndex] != null) {
                int n3 = this.buffer.length - this.takeIndex;
                System.arraycopy(this.buffer, this.takeIndex, objectArray, 0, n3);
                System.arraycopy(this.buffer, 0, objectArray, n3, this.putIndex);
                this.putIndex += n3;
            } else {
                this.putIndex = 0;
            }
            this.takeIndex = 0;
            this.buffer = objectArray;
        }
    }

    static {
        long l;
        int n;
        String string;
        try {
            string = System.getProperty("com.ibm.ws.util.BoundedBuffer.spins_take");
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            n = 16;
        }
        SPINS_TAKE_ = n;
        try {
            string = System.getProperty("com.ibm.ws.util.BoundedBuffer.spins_put");
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            n = 4;
        }
        SPINS_PUT_ = n;
        YIELD_TAKE_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_take");
        YIELD_PUT_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_put");
        try {
            string = System.getProperty("com.ibm.ws.util.BoundedBuffer.wait");
            l = Long.parseLong(string);
        }
        catch (Throwable throwable) {
            l = 1000L;
        }
        WAIT_SLICE_ = l;
    }

    private class BoundedBufferLock {
        private BoundedBufferLock() {
        }
    }

    private static class AtomicInteger {
        private int val_;

        public AtomicInteger(int n) {
            this.val_ = n;
        }

        final synchronized int get() {
            return this.val_;
        }

        final synchronized int getAndIncrement() {
            return this.val_++;
        }

        final synchronized int getAndDecrement() {
            return this.val_--;
        }
    }
}

