/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CaptureInputStream
extends FilterInputStream {
    private ByteArrayOutputStream captureOs = new ByteArrayOutputStream();

    public CaptureInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = super.read();
        this.captureOs.write(new Integer(n).byteValue());
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > 0) {
            this.captureOs.write(byArray, 0, n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.captureOs.write(byArray, n, n3);
        }
        return n3;
    }

    public void close() throws IOException {
        super.close();
        this.captureOs.flush();
    }

    public byte[] getCapturedInput() {
        return this.captureOs.toByteArray();
    }
}

