/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.CaptureInputStream;
import com.ibm.ws.util.CaptureOutputStream;
import com.ibm.ws.util.CapturedSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

class CaptureSocket
extends Socket {
    int idx = -1;
    boolean captureOutput = false;
    CaptureInputStream captureIs = null;
    CaptureOutputStream captureOs = null;
    CapturedSocket capturedSocket = null;
    ObjectOutputStream capturedOs = null;

    public CaptureSocket(ObjectOutputStream objectOutputStream, int n, boolean bl) {
        this.capturedOs = objectOutputStream;
        this.idx = n;
        this.captureOutput = bl;
    }

    public void capture() throws SocketException {
        this.capturedSocket = new CapturedSocket(this);
    }

    public int getIdx() {
        return this.idx;
    }

    public void close() throws IOException {
        try {
            this.capturedSocket.setCapturedInput(this.getCapturedInput());
            this.capturedSocket.setCapturedOutput(this.getCapturedOutput());
            this.capturedOs.writeObject(this.capturedSocket);
            this.capturedOs.flush();
            System.out.println("connection " + this.idx + " is closed and captured");
            super.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.util.CaptureServerSocket.close", "99", this);
            exception.printStackTrace();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.captureIs == null) {
            this.captureIs = new CaptureInputStream(super.getInputStream());
        }
        return this.captureIs;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.captureOutput) {
            if (this.captureOs == null) {
                this.captureOs = new CaptureOutputStream(super.getOutputStream());
            }
            return this.captureOs;
        }
        return super.getOutputStream();
    }

    public byte[] getCapturedInput() {
        return this.captureIs.getCapturedInput();
    }

    public byte[] getCapturedOutput() {
        if (this.captureOs == null) {
            return null;
        }
        return this.captureOs.getCapturedOutput();
    }
}

