/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;

public class ExtendedDocumentRootUtils {
    private static TraceComponent tc = Tr.register(ExtendedDocumentRootUtils.class.getName(), "Extended_DocumentRootUtils");
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private Vector searchPath = new Vector();
    private boolean useContentLength = false;
    private ZipFile matchedZipFile;
    private ZipEntry matchedEntry;
    private ExtDocRootFile extDocRootFile;

    public ExtendedDocumentRootUtils(ServletContext servletContext, String string) {
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: extendedDocumentRoot ", string);
            }
            this.createSearchPath(servletContext, string);
        }
    }

    public ExtendedDocumentRootUtils(String string, String string2) {
        if (string2 != null) {
            if (string != null && !(string = string.replace('\\', '/')).endsWith("/")) {
                string = string + "/";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: baseDir ", string);
                Tr.debug(tc, "constructor: extendedDocumentRoot ", string2);
            }
            this.createSearchPath(string, string2);
        }
    }

    public boolean searchPathExists() {
        if (tc.isDebugEnabled()) {
            String string = !this.searchPath.isEmpty() ? "true" : "false";
            Tr.debug(tc, "searchPathExists ", string);
        }
        return !this.searchPath.isEmpty();
    }

    private void createSearchPath(ServletContext servletContext, String string) {
        String string2 = servletContext.getRealPath("/../");
        this.createSearchPath(string2, string);
    }

    private void createSearchPath(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createSearchPath: baseDir ", string);
            Tr.debug(tc, "createSearchPath: extendedDocumentRoot ", string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                File file;
                String string3 = stringTokenizer.nextToken().trim();
                if (string3 == null) continue;
                if (isWindows && string3.indexOf(":") == 1 || string3.startsWith("/")) {
                    file = new File(string3);
                    this.searchPath.addElement(file.toString());
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "add to searchPath " + file.toString());
                    continue;
                }
                file = new File(string + string3);
                String string4 = file.getCanonicalPath();
                this.searchPath.addElement(string4);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "add to searchPath " + string4);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
    }

    public void handleExtendedDocumentRoots(String string) throws FileNotFoundException, IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleExtendedDocumentRoots: filename " + string);
        }
        boolean bl = false;
        Enumeration enumeration = this.searchPath.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string2 = enumeration.nextElement().toString();
            File file = new File(string2);
            if (file.isDirectory()) {
                object = new File(file, string);
                if (!((File)object).exists()) continue;
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleExtendedDocumentRoots: found match in directory" + ((File)object).toString());
                }
                this.handleCaseSensitivityCheck(((File)object).toString(), string);
                this.extDocRootFile = new FileResource((File)object);
                this.useContentLength = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "handleExtendedDocumentRoots: useContentLength " + this.useContentLength);
                break;
            }
            if (!file.exists()) continue;
            object = new ZipFile(file);
            ZipEntry zipEntry = ((ZipFile)object).getEntry(string.substring(1).replace('\\', '/'));
            if (zipEntry != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleExtendedDocumentRoots: found match in zip or jar file" + file.toString());
                }
                bl = true;
                this.extDocRootFile = new ZipFileResource(file, zipEntry.getName());
                ((ZipFile)object).close();
                break;
            }
            ((ZipFile)object).close();
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleExtendedDocumentRoots: unable to locate resource " + string);
            }
            throw new FileNotFoundException(string);
        }
    }

    public InputStream getInputStream() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInputStream for ExtendedDocumentRoot this -->" + this);
        }
        try {
            return this.extDocRootFile.getIS();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getMatchedFile() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMatchedFile = [" + this.extDocRootFile.getMatch() + "]");
        }
        return this.extDocRootFile.getMatch();
    }

    public long getLastModifiedMatchedFile() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastModifiedMatchedFile = [" + (this.extDocRootFile.getMatch() == null ? 0L : this.extDocRootFile.getMatch().lastModified()) + "]");
        }
        return this.extDocRootFile.getMatch() == null ? 0L : this.extDocRootFile.getMatch().lastModified();
    }

    public boolean useContentLength() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "useContentLength = [" + this.useContentLength + "]");
        }
        return this.useContentLength;
    }

    public ZipFile getMatchedZipFile() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            return ((ZipFileResource)this.extDocRootFile).getZipFile();
        }
        return null;
    }

    public ZipEntry getMatchedEntry() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            return ((ZipFileResource)this.extDocRootFile).getZipEntry();
        }
        return null;
    }

    private void handleCaseSensitivityCheck(String string, String string2) throws FileNotFoundException, IOException {
        if (FileSystem.isCaseInsensitive) {
            File file;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file system is case insensitive");
            }
            if (!FileSystem.uriCaseCheck(file = new File(string), string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleCaseSensitivityCheck failed for = [" + string + "]");
                }
                throw new FileNotFoundException(string);
            }
        }
    }

    protected class FileResource
    implements ExtDocRootFile {
        private File file;

        protected FileResource(File file) {
            this.file = file;
        }

        public InputStream getIS() throws IOException {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return FileResource inputstream file -->" + this.file);
            }
            return new FileInputStream(this.file);
        }

        public File getMatch() {
            return this.file;
        }
    }

    protected class ZipFileResource
    implements ExtDocRootFile {
        private String entry;
        private File jarFile;

        protected ZipFileResource(File file, String string) {
            this.entry = string;
            this.jarFile = file;
        }

        public InputStream getIS() throws IOException {
            ZipFile zipFile = new ZipFile(this.jarFile);
            ZipEntry zipEntry = zipFile.getEntry(this.entry);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return ZipFileResource inputstream zip -->" + this.jarFile + " entry -->" + this.entry);
            }
            return zipFile.getInputStream(zipEntry);
        }

        public File getMatch() {
            return this.jarFile;
        }

        public ZipFile getZipFile() {
            try {
                return new ZipFile(this.jarFile);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public ZipEntry getZipEntry() {
            try {
                return new ZipFile(this.jarFile).getEntry(this.entry);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static interface ExtDocRootFile {
        public InputStream getIS() throws IOException;

        public File getMatch();
    }
}

