/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.AsynchBeansInvocationService;
import com.ibm.ws.util.InvocationToken;
import com.ibm.ws.util.WebInvocationTokenImpl;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import javax.naming.InitialContext;

public class InvocationTokenAccessorImpl {
    private static final TraceComponent _tc = Tr.register(InvocationTokenAccessorImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static EJBContainer _ejbContainer = null;
    private static InvocationTokenAccessorImpl _instance = new InvocationTokenAccessorImpl();
    private static AsynchBeansInvocationService _abInvocService = null;
    private static boolean needsInit = true;

    private InvocationTokenAccessorImpl() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "InvocationTokenAccessorImpl");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "InvocationTokenAccessorImpl");
        }
    }

    public static InvocationTokenAccessorImpl getInvocationTokenAccessor() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInvocationTokenAccessor");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInvocationTokenAccessor", _instance);
        }
        return _instance;
    }

    public int getTokenIndex() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTokenIndex");
        }
        int n = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaDataIndex();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTokenIndex", new Integer(n));
        }
        return n;
    }

    private static synchronized void init() {
        block4: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "init");
            }
            _abInvocService = AsynchBeansInvocationService.getInstance();
            try {
                InitialContext initialContext = new InitialContext();
                _ejbContainer = (EJBContainer)initialContext.lookup("services:websphere/EJBContainer");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.util.InvocationTokenAccessorImpl.init", "101");
                throwable.printStackTrace();
                if (!_tc.isEventEnabled()) break block4;
                Tr.event(_tc, "init", throwable);
            }
        }
        needsInit = false;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public InvocationToken getCurrentInvocationToken() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCurrentInvocationToken");
        }
        if (needsInit) {
            InvocationTokenAccessorImpl.init();
        }
        InvocationToken invocationToken = null;
        ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (componentMetaData == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCurrentInvocationToken", "The ComponentMetaData is null!");
            }
        } else if (componentMetaData instanceof EJBComponentMetaData) {
            invocationToken = _ejbContainer.getCurrentInvocationToken();
            if (invocationToken == null && (invocationToken = _abInvocService.getCurrentInvocationToken(componentMetaData)) == null) {
                Tr.debug(_tc, "getCurrentInvocationToken", "Didn't get a token from either the EJB container or the Asynch Beans invocation service!");
            }
        } else if (componentMetaData instanceof WebComponentMetaData) {
            invocationToken = _abInvocService.getCurrentInvocationToken(componentMetaData);
            if (invocationToken == null) {
                WebComponentMetaData webComponentMetaData = (WebComponentMetaData)componentMetaData;
                invocationToken = new WebInvocationTokenImpl(this.getTokenIndex(), webComponentMetaData);
                if (invocationToken == null) {
                    Tr.debug(_tc, "getCurrentInvocationToken", "Didn't get a token from either the Web container or the Asynch Beans invocation service!");
                }
            }
        } else {
            invocationToken = _abInvocService.getCurrentInvocationToken(componentMetaData);
            if (invocationToken == null) {
                Tr.debug(_tc, "getCurrentInvocationToken", "Didn't get a token from the Asynch Beans invocation service!");
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCurrentInvocationToken", "EjbContainer = " + _ejbContainer);
            Tr.debug(_tc, "getCurrentInvocationToken", "currentComponentMetaData = " + componentMetaData);
            Tr.debug(_tc, "getCurrentInvocationToken", "token = " + invocationToken);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCurrentInvocationToken", invocationToken);
        }
        return invocationToken;
    }
}

